/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import com.ibm.team.workitem.common.internal.util.SeparatedStringIterator;
import com.ibm.team.workitem.common.model.Identifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SeparatedStringList
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private static final char SEPARATOR = '|';
    private static final char ESCAPE_CHAR = '\\';

    public SeparatedStringList() {
    }

    public SeparatedStringList(Collection<String> collection) {
        super(collection);
    }

    public SeparatedStringList(String value) {
        SeparatedStringList.parse(this, value);
    }

    public static void parse(Collection<String> collection, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        SeparatedStringIterator iterator = new SeparatedStringIterator(value, '|', '\\');
        while (iterator.hasNext()) {
            String part = iterator.next();
            if (part.length() <= 0) continue;
            collection.add(part);
        }
    }

    public static String toCommaSeparatedValue(Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        if (collection != null) {
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                builder.append(iterator.next());
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    public static String escape(String value) {
        StringBuilder builder = new StringBuilder(value.length() + 5);
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '|' || c == '\\') {
                builder.append('\\');
            }
            builder.append(c);
            ++i;
        }
        return builder.toString();
    }

    public String getSeparatedString() {
        StringBuilder builder = new StringBuilder();
        if (this.size() > 0) {
            builder.append('|');
        }
        for (String value : this) {
            builder.append(SeparatedStringList.escape(value));
            builder.append('|');
        }
        return builder.toString();
    }

    public <T> List<Identifier<T>> toIdentifiers(Class<T> clazz) {
        ArrayList<Identifier<T>> list = new ArrayList<Identifier<T>>(this.size());
        for (String s : this) {
            list.add(Identifier.create(clazz, s));
        }
        return list;
    }
}

