/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.wiki.transformer;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.ILinkDetectorContextProvider;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.TextLinkDetectorManager;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.linkdetection.SimpleWorkItemLinkDetectorContextProvider;
import com.ibm.team.workitem.common.internal.wiki.transformer.IItemReferenceDetector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public class DefaultReferenceDetector
implements IItemReferenceDetector {
    private LinkDetector fDelegate;
    private URI fBaseUri;

    public DefaultReferenceDetector(URI baseUri, IProjectAreaHandle projectArea) {
        this(baseUri, projectArea, false);
    }

    public DefaultReferenceDetector(URI baseUri, IProjectAreaHandle projectArea, boolean isServer) {
        Assert.isNotNull((Object)baseUri);
        this.fBaseUri = baseUri;
        this.fDelegate = TextLinkDetectorManager.getDefault().createLinkDetector(isServer);
        this.fDelegate.setContext((ILinkDetectorContextProvider)new SimpleWorkItemLinkDetectorContextProvider(baseUri, projectArea));
    }

    @Override
    public IItemReferenceDetector.Reference detect(String text) {
        List uris;
        List match = this.fDelegate.match(text);
        if (!match.isEmpty() && !(uris = ((DetectedTextLink)match.get(0)).createURIs()).isEmpty()) {
            URI uri = (URI)((DetectedTextLink)match.get(0)).createURIs().get(0);
            try {
                Location location = Location.location((URI)uri);
                return DefaultReferenceDetector.safeReference(location);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (this.fBaseUri != null) {
            URI uri;
            try {
                uri = new URI(text);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            try {
                Location tmp = Location.location((URI)uri);
                Location location = Location.location((Location)tmp, (String)this.fBaseUri.toASCIIString(), null);
                return DefaultReferenceDetector.safeReference(location);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
        }
        return null;
    }

    private static IItemReferenceDetector.Reference safeReference(Location location) {
        if (location.getType() == null) {
            return null;
        }
        return new IItemReferenceDetector.Reference(location);
    }
}

