/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowDescriptor;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowManager;
import com.ibm.team.workitem.common.internal.workflow.IWorkflowState;
import com.ibm.team.workitem.common.internal.workflow.InternalWorkflowKeys;
import com.ibm.team.workitem.common.internal.workflow.Messages;
import com.ibm.team.workitem.common.internal.workflow.WorkflowException;
import com.ibm.team.workitem.common.internal.workflow.WorkflowInfo;
import com.ibm.team.workitem.common.internal.workflow.WorkflowManager;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.StateResolutionPair;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultWorkflow
implements IWorkflowDescriptor,
InternalWorkflowKeys {
    private static final String CLASS = "class";
    public static final String WORKFLOW = "workflow";
    private static final String START_ACTION_ID = "startActionId";
    private String fPluginId;
    private String fId;
    private String fName;
    private String fStartActionId;
    private String fResolveActionId;
    private String fReopenActionId;
    private final Map<String, State> fStates = new HashMap<String, State>();
    private final ArrayList<State> fStates2 = new ArrayList();
    private final Map<String, Action> fActions = new HashMap<String, Action>();
    private final ArrayList<Action> fActions2 = new ArrayList();
    private final Map<String, Resolution> fResolutions = new HashMap<String, Resolution>();
    private final ArrayList<Resolution> fResolutions2 = new ArrayList();

    public DefaultWorkflow(InputStream inputStream) throws WorkflowException {
        this(inputStream, null);
    }

    public DefaultWorkflow(InputStream inputStream, String pluginId) throws WorkflowException {
        this.fPluginId = pluginId;
        InputStreamReader r = new InputStreamReader(inputStream);
        this.readXML(r, null);
    }

    public DefaultWorkflow(IProcessConfigurationElement element) {
        this.init(element);
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public void setId(String id) {
        this.fId = id;
    }

    @Override
    public Object getName() {
        return this.fName;
    }

    @Override
    public IWorkflowState createWorkflowState() throws WorkflowException {
        return new WorkflowState();
    }

    public static IWorkflowState getWorkflow(IWorkflowManager workflowManager, IProjectAreaHandle projectArea, String workflowId) throws WorkflowException {
        Assert.isNotNull((Object)workflowId);
        IWorkflowDescriptor workflowDescriptor = ((WorkflowManager)workflowManager).getWorkflowDescriptor(projectArea, workflowId, false, null);
        IWorkflowState wf = null;
        if (workflowDescriptor != null) {
            wf = workflowDescriptor.createWorkflowState();
        }
        return wf;
    }

    @Override
    public void getWorkflowInfo(IMemento memento) {
        memento.putString("id", this.fId);
        if (this.fName != null) {
            memento.putString("name", this.fName);
        }
        if (this.fPluginId != null) {
            memento.putString("pluginId", this.fPluginId);
        }
        if (this.fResolveActionId != null) {
            memento.putString("resolveActionId", this.fResolveActionId);
        }
        if (this.fReopenActionId != null) {
            memento.putString("reopenActionId", this.fReopenActionId);
        }
        if (this.fStartActionId != null) {
            memento.putString(START_ACTION_ID, this.fStartActionId);
        }
        for (Action a : this.fActions2) {
            a.getMemento2(memento);
        }
        for (State st : this.fStates2) {
            st.getMemento2(memento);
        }
        for (Resolution r : this.fResolutions2) {
            r.getMemento(memento);
        }
    }

    private void init(IProcessConfigurationElement element) {
        IProcessConfigurationElement[] children = element.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                IProcessConfigurationElement workflow = children[i];
                if (WORKFLOW.equals(workflow.getName())) {
                    this.fName = workflow.getAttribute("name");
                    this.fStartActionId = workflow.getAttribute(START_ACTION_ID);
                    this.fResolveActionId = workflow.getAttribute("resolveActionId");
                    this.fReopenActionId = workflow.getAttribute("reopenActionId");
                    IProcessConfigurationElement[] children2 = workflow.getChildren();
                    if (children2 != null) {
                        IProcessConfigurationElement node2;
                        int j = 0;
                        while (j < children2.length) {
                            node2 = children2[j];
                            if ("resolution".equals(node2.getName())) {
                                this.getResolution(node2);
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < children2.length) {
                            node2 = children2[j];
                            if ("action".equals(node2.getName())) {
                                this.getAction(node2);
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < children2.length) {
                            String id;
                            node2 = children2[j];
                            if ("state".equals(node2.getName()) && (id = node2.getAttribute("id")) != null) {
                                State s = new State(node2);
                                this.fStates.put(id, s);
                                this.fStates2.add(s);
                            }
                            ++j;
                        }
                    }
                    return;
                }
                ++i;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void readXML(Reader reader, String baseDir) throws WorkflowException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Action getAction(IProcessConfigurationElement element) {
        String id = element.getAttribute("id");
        Action a = this.fActions.get(id);
        if (a == null) {
            a = new Action(element);
            this.fActions.put(id, a);
            this.fActions2.add(a);
        }
        return a;
    }

    private Action getAction(Element element) {
        String id = element.getAttribute("id");
        Action a = this.fActions.get(id);
        if (a == null) {
            a = new Action(element);
            this.fActions.put(id, a);
            this.fActions2.add(a);
        }
        return a;
    }

    private Resolution getResolution(IProcessConfigurationElement element) {
        String id = element.getAttribute("id");
        Resolution r = this.fResolutions.get(id);
        if (r == null) {
            r = new Resolution(element);
            this.fResolutions.put(id, r);
            this.fResolutions2.add(r);
        }
        return r;
    }

    private Resolution getResolution(Element element) {
        String id = element.getAttribute("id");
        Resolution r = this.fResolutions.get(id);
        if (r == null) {
            r = new Resolution(element);
            this.fResolutions.put(id, r);
            this.fResolutions2.add(r);
        }
        return r;
    }

    public Map<String, Set<StateResolutionPair>> getStateGroupMappings() {
        HashMap<String, Set<StateResolutionPair>> stateGroupMappings = new HashMap<String, Set<StateResolutionPair>>();
        for (State state : this.fStates2) {
            String stateGroup = state.getGroup();
            if (stateGroup == null || stateGroup.length() <= 0) continue;
            HashSet<StateResolutionPair> pairs = (HashSet<StateResolutionPair>)stateGroupMappings.get(stateGroup);
            if (pairs == null) {
                pairs = new HashSet<StateResolutionPair>();
                stateGroupMappings.put(stateGroup, pairs);
            }
            Identifier<IState> stateId = this.createIdentifier(IState.class, state.getId());
            pairs.add(new StateResolutionPair(stateId, this.getId()));
        }
        for (Action action : this.fActions2) {
            for (String resolutionId : action.fResolutions2) {
                Resolution resolution;
                String resolutionGroup = action.getResolutionGroup(resolutionId);
                if (resolutionGroup == null && (resolution = this.fResolutions.get(resolutionId)) != null) {
                    resolutionGroup = resolution.getGroup();
                }
                if (resolutionGroup == null || resolutionGroup.length() <= 0) continue;
                HashSet<StateResolutionPair> pairs = (HashSet<StateResolutionPair>)stateGroupMappings.get(resolutionGroup);
                if (pairs == null) {
                    pairs = new HashSet<StateResolutionPair>();
                    stateGroupMappings.put(resolutionGroup, pairs);
                }
                Identifier<IState> stateIdentifier = this.createIdentifier(IState.class, action.getNewState());
                Identifier<IResolution> resolutionIdentifier = this.createIdentifier(IResolution.class, resolutionId);
                pairs.add(new StateResolutionPair(stateIdentifier, resolutionIdentifier, this.getId()));
            }
        }
        return stateGroupMappings;
    }

    private <T> Identifier<T> createIdentifier(Class<T> clazz, String value) {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (IState.class == clazz) {
            value = WorkflowInfo.stripOffPrefix(value, 's');
        } else if (IResolution.class == clazz) {
            value = WorkflowInfo.stripOffPrefix(value, 'r');
        }
        return Identifier.create(clazz, value);
    }

    private class Action {
        String fId;
        String fName;
        String fIcon;
        String fNewState;
        Map<String, Resolution> fResolutions = new HashMap<String, Resolution>();
        ArrayList<String> fResolutions2 = new ArrayList();
        Map<String, String> fResolutionGroups = new HashMap<String, String>();

        Action(Element element) {
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            String state = element.getAttribute("state");
            if (state.trim().length() > 0) {
                this.fNewState = state;
            }
            NodeList resolutions = element.getElementsByTagName("resolution");
            int i = 0;
            while (i < resolutions.getLength()) {
                Node node = resolutions.item(i);
                if (node instanceof Element) {
                    Element e = (Element)node;
                    Resolution r = DefaultWorkflow.this.getResolution(e);
                    String id = e.getAttribute("id");
                    String group = e.getAttribute("group");
                    if (id != null && r != null) {
                        this.fResolutions.put(id, r);
                        this.fResolutions2.add(id);
                        if (group != null && group.length() > 0) {
                            this.fResolutionGroups.put(id, group);
                        }
                    }
                }
                ++i;
            }
        }

        Action(IProcessConfigurationElement element) {
            IProcessConfigurationElement[] resolutions;
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            String state = element.getAttribute("state");
            if (state != null && state.trim().length() > 0) {
                this.fNewState = state;
            }
            if ((resolutions = element.getChildren()) != null) {
                int i = 0;
                while (i < resolutions.length) {
                    IProcessConfigurationElement node = resolutions[i];
                    if ("resolution".equals(node.getName())) {
                        Resolution r = DefaultWorkflow.this.getResolution(node);
                        String id = node.getAttribute("id");
                        String group = node.getAttribute("group");
                        if (id != null && r != null) {
                            this.fResolutions.put(id, r);
                            this.fResolutions2.add(id);
                            if (group != null && group.length() > 0) {
                                this.fResolutionGroups.put(id, group);
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        void getMemento2(IMemento parent) {
            IMemento action = parent.createChild("action");
            action.putString("id", this.fId);
            action.putString("name", this.fName);
            action.putString("icon", this.fIcon);
            action.putString("state", this.fNewState);
            String[] resolutionIds = this.getResolutionIds();
            int j = 0;
            while (j < resolutionIds.length) {
                IMemento memento = action.createChild("resolution");
                memento.putString("id", resolutionIds[j]);
                ++j;
            }
        }

        String getNewState() {
            return this.fNewState;
        }

        public String[] getResolutionIds() {
            return this.fResolutions2.toArray(new String[this.fResolutions2.size()]);
        }

        String getResolutionGroup(String resolutionId) {
            return this.fResolutionGroups.get(resolutionId);
        }
    }

    private class Resolution {
        String fId;
        String fName;
        String fIcon;
        String fGroup;

        Resolution(Element element) {
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            this.fGroup = element.getAttribute("group");
        }

        public Resolution(IProcessConfigurationElement element) {
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            this.fGroup = element.getAttribute("group");
        }

        public void getMemento(IMemento parent) {
            IMemento resolution = parent.createChild("resolution");
            resolution.putString("id", this.fId);
            resolution.putString("name", this.fName);
            resolution.putString("icon", this.fIcon);
            resolution.putString("group", this.fGroup);
        }

        String getGroup() {
            return this.fGroup;
        }
    }

    private class State {
        String fId;
        String fName;
        String fIcon;
        String fGroup;
        int fShowResolution;
        Map<String, Action> fActions = new HashMap<String, Action>();
        ArrayList<String> fActions2 = new ArrayList();

        State(Element element) {
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            this.fGroup = element.getAttribute("group");
            String s = element.getAttribute("showResolution");
            if (s != null && "true".equals(s)) {
                this.fShowResolution = 1;
            }
            NodeList actions = element.getElementsByTagName("action");
            int i = 0;
            while (i < actions.getLength()) {
                Node node = actions.item(i);
                if (node instanceof Element) {
                    Element e = (Element)node;
                    Action a = DefaultWorkflow.this.getAction(e);
                    String id = e.getAttribute("id");
                    if (id != null && a != null) {
                        this.fActions.put(id, a);
                        this.fActions2.add(id);
                    }
                }
                ++i;
            }
        }

        State(IProcessConfigurationElement element) {
            IProcessConfigurationElement[] actions;
            this.fId = element.getAttribute("id");
            this.fName = element.getAttribute("name");
            this.fIcon = element.getAttribute("icon");
            this.fGroup = element.getAttribute("group");
            String s = element.getAttribute("showResolution");
            if (s != null && "true".equals(s)) {
                this.fShowResolution = 1;
            }
            if ((actions = element.getChildren()) != null) {
                int i = 0;
                while (i < actions.length) {
                    IProcessConfigurationElement node = actions[i];
                    if ("action".equals(node.getName())) {
                        Action a = DefaultWorkflow.this.getAction(node);
                        String id = node.getAttribute("id");
                        if (id != null && a != null) {
                            this.fActions.put(id, a);
                            this.fActions2.add(id);
                        }
                    }
                    ++i;
                }
            }
        }

        public void getMemento(IMemento parent) {
            IMemento stat = parent.createChild("state");
            stat.putString("id", this.fId);
            stat.putString("name", this.fName);
            stat.putString("icon", this.fIcon);
            stat.putInteger("showResolution", this.fShowResolution);
        }

        public void getMemento2(IMemento parent) {
            IMemento stat = parent.createChild("state");
            stat.putString("id", this.fId);
            stat.putString("name", this.fName);
            stat.putString("icon", this.fIcon);
            if (this.fGroup != null) {
                stat.putString("group", this.fGroup);
            }
            stat.putInteger("showResolution", this.fShowResolution);
            String[] actionIds = this.getActionIds();
            int j = 0;
            while (j < actionIds.length) {
                IMemento memento = stat.createChild("action");
                memento.putString("id", actionIds[j]);
                ++j;
            }
        }

        String getId() {
            return this.fId;
        }

        String run(String actionId, WorkflowState wfs) throws WorkflowException {
            Action action = this.fActions.get(actionId);
            if (action == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.NO_ACTION_IN_STATE"), (Object)actionId, (Object[])new Object[]{this.fId}));
            }
            return action.getNewState();
        }

        public String[] getActionIds() {
            return this.fActions2.toArray(new String[this.fActions2.size()]);
        }

        String getGroup() {
            return this.fGroup;
        }
    }

    private class WorkflowState
    implements IWorkflowState {
        private String fStateId;

        public WorkflowState() throws WorkflowException {
            if (DefaultWorkflow.this.fStartActionId == null) {
                throw new WorkflowException(Messages.getString("DefaultWorkflow.WORKFLOW_HAS_NO_START_ACTION"));
            }
            Action action = (Action)DefaultWorkflow.this.fActions.get(DefaultWorkflow.this.fStartActionId);
            if (action == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.UNKNOWN_ACTION"), (Object)DefaultWorkflow.this.fStartActionId, (Object[])new Object[0]));
            }
            this.fStateId = action.getNewState();
        }

        @Override
        public String getStateId() {
            return this.fStateId;
        }

        @Override
        public void setStateId(String id) {
            this.fStateId = id;
        }

        @Override
        public String getStartActionId() {
            return DefaultWorkflow.this.fStartActionId;
        }

        @Override
        public void doAction(String stateId, String actionId) throws WorkflowException {
            State state;
            if (stateId != null && !stateId.equals(this.fStateId)) {
                this.fStateId = stateId;
            }
            if ((state = (State)DefaultWorkflow.this.fStates.get(this.fStateId)) == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.ILLEGAL_STATE"), (Object)this.fStateId, (Object[])new Object[0]));
            }
            if (DefaultWorkflow.this.fActions.get(actionId) == null) {
                throw new WorkflowException(NLS.bind((String)Messages.getString("DefaultWorkflow.UNKNOWN_STATE"), (Object)actionId, (Object[])new Object[0]));
            }
            String newState = state.run(actionId, this);
            if (newState != null) {
                this.fStateId = newState;
            }
        }
    }
}

