/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.workflow;

import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.Identifier;
import org.eclipse.core.runtime.Assert;

public class StateResolutionPair {
    private final Identifier<IState> fStateId;
    private final Identifier<IResolution> fResolutionId;
    private final String fWorkflowId;

    public StateResolutionPair(Identifier<IState> stateId, String workflowId) {
        this(stateId, null, workflowId);
    }

    public StateResolutionPair(Identifier<IState> stateId, Identifier<IResolution> resolutionId, String workflowId) {
        Assert.isNotNull(stateId);
        Assert.isNotNull((Object)workflowId);
        this.fStateId = stateId;
        this.fResolutionId = resolutionId;
        this.fWorkflowId = workflowId;
    }

    public Identifier<IState> getStateId() {
        return this.fStateId;
    }

    public Identifier<IResolution> getResolutionId() {
        return this.fResolutionId;
    }

    public String getWorkflowId() {
        return this.fWorkflowId;
    }

    public int hashCode() {
        int hashCode = this.fStateId.hashCode() ^ this.fWorkflowId.hashCode();
        if (this.fResolutionId == null) {
            return hashCode;
        }
        return hashCode ^ this.fResolutionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StateResolutionPair other = (StateResolutionPair)obj;
        return this.fStateId.equals(other.fStateId) && this.fWorkflowId.equals(other.fWorkflowId) && (this.fResolutionId != null && this.fResolutionId.equals(other.fResolutionId) || this.fResolutionId == other.fResolutionId);
    }

    public String toString() {
        return this.fStateId + ", " + this.fResolutionId + ", " + this.fWorkflowId;
    }
}

