/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.models.Group;
import com.urbancode.release.rest.models.NotificationScheme;
import com.urbancode.release.rest.models.NotificationTemplate;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;

public class NotificationRule
extends ClientEntity<NotificationRule> {
    public NotificationScheme scheme;
    public NotificationType type;
    public NotificationEvent event;
    public FilterType filter;
    public Role role;
    public Group group;
    public User user;
    public String email;
    public Integer offset;
    public NotificationTemplate template;
    public Role filterRole;
    public Group filterGroup;
    public User filterUser;
    public String notifyType;

    public NotificationRule() {
        this.path = "/notificationRules/";
        this.offset = 0;
    }

    public NotificationScheme getScheme() {
        return this.scheme;
    }

    public NotificationRule setScheme(NotificationScheme scheme) {
        return this.scheme(scheme);
    }

    public NotificationRule scheme(NotificationScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public NotificationType getType() {
        return this.type;
    }

    public NotificationRule setType(NotificationType type) {
        return this.type(type);
    }

    public NotificationRule type(NotificationType type) {
        this.type = type;
        return this;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public NotificationEvent getEvent() {
        return this.event;
    }

    public NotificationRule setEvent(NotificationEvent event) {
        return this.event(event);
    }

    public NotificationRule event(NotificationEvent event) {
        this.event = event;
        return this;
    }

    public NotificationEvent getFilter() {
        return this.event;
    }

    public NotificationRule setFilter(FilterType filter) {
        return this.filter(filter);
    }

    public NotificationRule filter(FilterType filter) {
        this.filter = filter;
        return this;
    }

    public Role getRole() {
        return this.role;
    }

    public NotificationRule setRole(Role role) {
        return this.role(role);
    }

    public NotificationRule role(Role role) {
        this.notifyType = "role";
        this.role = role;
        return this;
    }

    public Group getGroup() {
        return this.group;
    }

    public NotificationRule setGroup(Group group) {
        return this.group(group);
    }

    public NotificationRule group(Group group) {
        this.notifyType = "group";
        this.group = group;
        return this;
    }

    public User getUser() {
        return this.user;
    }

    public NotificationRule setUser(User user) {
        return this.user(user);
    }

    public NotificationRule user(User user) {
        this.notifyType = "user";
        this.user = user;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public NotificationRule setEmail(String email) {
        return this.email(email);
    }

    public NotificationRule email(String email) {
        this.notifyType = "email";
        this.email = email;
        return this;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public NotificationRule setOffset(Integer offset) {
        return this.offset(offset);
    }

    public NotificationRule offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public NotificationTemplate getTemplate() {
        return this.template;
    }

    public NotificationRule setTemplate(NotificationTemplate template) {
        return this.template(template);
    }

    public NotificationRule template(NotificationTemplate template) {
        this.template = template;
        return this;
    }

    public Role getFilterRole() {
        return this.filterRole;
    }

    public NotificationRule setFilterRole(Role filterRole) {
        return this.filterRole(filterRole);
    }

    public NotificationRule filterRole(Role filterRole) {
        this.filterRole = filterRole;
        return this;
    }

    public Group getFilterGroup() {
        return this.filterGroup;
    }

    public NotificationRule setFilterGroup(Group filterGroup) {
        return this.filterGroup(filterGroup);
    }

    public NotificationRule filterGroup(Group filterGroup) {
        this.filterGroup = filterGroup;
        return this;
    }

    public User getFilterUser() {
        return this.filterUser;
    }

    public NotificationRule setFilterUser(User filterUser) {
        return this.filterUser(filterUser);
    }

    public NotificationRule filterUser(User filterUser) {
        this.filterUser = filterUser;
        return this;
    }

    public JsonArray getNotificationJobForModelAndForScheme(NotificationScheme scheme, String id) {
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + scheme.id + "/notificationJobScheduledFor/" + id, new Object[0])).asString();
        JsonParser parser = new JsonParser();
        return parser.parse(jsonString).getAsJsonArray();
    }

    public JsonObject getNotificationJobForGroupAndKey(String group, String key) {
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "notificationJobForGroupAndkey/" + group + "/key/" + key, new Object[0])).asString();
        JsonParser parser = new JsonParser();
        return parser.parse(jsonString).getAsJsonObject();
    }

    public JsonArray getNotificationJobForScheme(NotificationScheme scheme, ScheduledDeployment deployment) {
        String jobGroupPath = "notificationJobForScheme";
        if (deployment != null) {
            jobGroupPath = "notificationJobScheduledForDeployment/" + deployment.id;
        }
        String jsonString = ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + scheme.id + "/" + jobGroupPath, new Object[0])).asString();
        JsonParser parser = new JsonParser();
        return parser.parse(jsonString).getAsJsonArray();
    }

    public static enum NotificationGroup {
        NotificationCreatorGroup,
        NotificationCleanerGroup,
        NotificationGroup;

    }

    public static enum FilterType {
        OWNED_BY_ME,
        MY_ROLE,
        ALL;

    }

    public static enum NotificationEvent {
        BeforeTaskStart,
        AtTaskStart,
        AtTaskOpen,
        AfterTaskOpen,
        AtTaskSuccess,
        AtTaskFail,
        AtTaskSkip,
        AfterTaskStart,
        BeforeSegmentStart,
        AtSegmentStart,
        AfterSegmentStart,
        AtSegmentEnd,
        AfterSegmentEnd,
        BeforeDeploymentStart,
        AtDeploymentStart,
        AfterDeploymentStart,
        AtDeploymentEnd,
        AtDeploymentAbort,
        BeforeApproval,
        AtApproval,
        AfterApproval,
        AtApplicationAddedToRelease,
        AtApplicationRemovedFromRelease;

    }

    public static enum NotificationType {
        Task,
        Segment,
        Deployment,
        Approval,
        Release;

    }
}

