/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.builder.RequestSpecBuilder;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.config.SSLConfig;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.filter.log.ResponseLoggingFilter;
import com.jayway.restassured.filter.session.SessionFilter;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.mapper.factory.GsonObjectMapperFactory;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.internal.ExplicitNullsDereferencingFactory;
import com.urbancode.release.rest.framework.internal.SuppressReadOnlyStrategy;
import com.urbancode.release.rest.models.AuthenticationRealm;
import com.urbancode.release.rest.models.AuthorizationRealm;
import com.urbancode.release.rest.models.internal.ApplicationEnvironment;
import com.urbancode.release.rest.models.internal.ApplicationEnvironmentExecution;
import com.urbancode.release.rest.models.internal.ApprovalItem;
import com.urbancode.release.rest.models.internal.ApprovalSet;
import com.urbancode.release.rest.models.internal.ApprovalTemplate;
import com.urbancode.release.rest.models.internal.DeploymentExecution;
import com.urbancode.release.rest.models.internal.DeploymentExecutionUpdate;
import com.urbancode.release.rest.models.internal.DeploymentNotification;
import com.urbancode.release.rest.models.internal.DeploymentPlan;
import com.urbancode.release.rest.models.internal.EnvironmentActivity;
import com.urbancode.release.rest.models.internal.EnvironmentTag;
import com.urbancode.release.rest.models.internal.EventType;
import com.urbancode.release.rest.models.internal.Exemption;
import com.urbancode.release.rest.models.internal.Gate;
import com.urbancode.release.rest.models.internal.IntegrationProvider;
import com.urbancode.release.rest.models.internal.JiraIntegrationProvider;
import com.urbancode.release.rest.models.internal.Lifecycle;
import com.urbancode.release.rest.models.internal.Milestone;
import com.urbancode.release.rest.models.internal.MilestoneTemplate;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.PhaseModel;
import com.urbancode.release.rest.models.internal.Plugin;
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider;
import com.urbancode.release.rest.models.internal.ProcessChecklistTemplate;
import com.urbancode.release.rest.models.internal.RTCIntegrationProvider;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.SegmentExecution;
import com.urbancode.release.rest.models.internal.SegmentPlan;
import com.urbancode.release.rest.models.internal.Status;
import com.urbancode.release.rest.models.internal.SuggestedTask;
import com.urbancode.release.rest.models.internal.TargetTag;
import com.urbancode.release.rest.models.internal.TaskComment;
import com.urbancode.release.rest.models.internal.TaskExecution;
import com.urbancode.release.rest.models.internal.TaskPlan;
import com.urbancode.release.rest.models.internal.TaskTag;
import com.urbancode.release.rest.models.internal.UCDIntegrationProvider;
import com.urbancode.release.rest.models.internal.UCDPluginIntegrationProvider;
import com.urbancode.release.rest.models.internal.UCMobilePluginIntegrationProvider;
import com.urbancode.release.rest.models.internal.UCRPlugin;
import com.urbancode.release.rest.models.internal.VersionStatus;
import com.urbancode.release.rest.models.internal.VersionStatusAttachment;
import com.urbancode.release.rest.models.internal.VersionStatusComment;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.cert.X509Certificate;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class InternalClients {
    protected static Logger log = Logger.getLogger(InternalClients.class);

    public static ApplicationEnvironment applicationEnvironment() {
        return new ApplicationEnvironment();
    }

    public static ApplicationEnvironmentExecution applicationEnvironmentExecution() {
        return new ApplicationEnvironmentExecution();
    }

    public static ApprovalItem approvalItem() {
        return new ApprovalItem();
    }

    public static ApprovalTemplate approvalTemplate() {
        return new ApprovalTemplate();
    }

    public static ApprovalSet approvalSet() {
        return new ApprovalSet();
    }

    public static DeploymentExecution deploymentExecution() {
        return new DeploymentExecution();
    }

    public static DeploymentExecutionUpdate deploymentExecutionUpdate() {
        return new DeploymentExecutionUpdate();
    }

    public static DeploymentNotification deploymentNotification() {
        return new DeploymentNotification();
    }

    public static DeploymentPlan deploymentPlan() {
        return new DeploymentPlan();
    }

    public static EnvironmentActivity environmentActivity() {
        return new EnvironmentActivity();
    }

    public static EnvironmentTag environmentTag() {
        return new EnvironmentTag();
    }

    public static EventType eventType() {
        return new EventType();
    }

    public static Exemption exemption() {
        return new Exemption();
    }

    public static Gate gate() {
        return new Gate();
    }

    public static Lifecycle lifecycle() {
        return new Lifecycle();
    }

    public static Milestone milestone() {
        return new Milestone();
    }

    public static MilestoneTemplate milestoneTemplate() {
        return new MilestoneTemplate();
    }

    public static Phase phase() {
        return new Phase();
    }

    public static PhaseModel phaseModel() {
        return new PhaseModel();
    }

    public static ProcessChecklistTemplate processChecklistTemplate() {
        return new ProcessChecklistTemplate();
    }

    public static ReleaseEnvironment releaseEnvironment() {
        return new ReleaseEnvironment();
    }

    public static ScheduledDeployment scheduledDeployment() {
        return new ScheduledDeployment();
    }

    public static SegmentExecution segmentExecution() {
        return new SegmentExecution();
    }

    public static SegmentPlan segmentPlan() {
        return new SegmentPlan();
    }

    public static Status status() {
        return new Status();
    }

    public static SuggestedTask suggestedTask() {
        return new SuggestedTask();
    }

    public static TaskComment taskComment() {
        return new TaskComment();
    }

    public static TaskExecution taskExecution() {
        return new TaskExecution();
    }

    public static TaskPlan taskPlan() {
        return new TaskPlan();
    }

    public static TaskTag taskTag() {
        return new TaskTag();
    }

    public static IntegrationProvider integrationProvider() {
        return new IntegrationProvider();
    }

    public static UCDIntegrationProvider ucdIntegrationProvider() {
        return new UCDIntegrationProvider();
    }

    public static JiraIntegrationProvider jiraIntegrationProvider() {
        return new JiraIntegrationProvider();
    }

    public static RTCIntegrationProvider rtcIntegrationProvider() {
        return new RTCIntegrationProvider();
    }

    public static PluginIntegrationProvider pluginIntegrationProvider() {
        return new PluginIntegrationProvider();
    }

    public static Plugin plugin() {
        return new Plugin();
    }

    public static UCRPlugin ucrPlugin() {
        return new UCRPlugin();
    }

    public static UCDPluginIntegrationProvider ucdPluginIntegrationProvider() {
        return new UCDPluginIntegrationProvider();
    }

    public static UCMobilePluginIntegrationProvider ucmobilePluginIntegrationProvider() {
        return new UCMobilePluginIntegrationProvider();
    }

    public static VersionStatus versionStatus() {
        return new VersionStatus();
    }

    public static VersionStatusAttachment versionStatusAttachment() {
        return new VersionStatusAttachment();
    }

    public static VersionStatusComment versionStatusComment() {
        return new VersionStatusComment();
    }

    public static TargetTag targetTag() {
        return new TargetTag();
    }

    public static void loginAsExpectFailure(String baseURL, String username, String password) {
        Clients.printVersionNumber();
        RestAssured.config = RestAssuredConfig.config().objectMapperConfig(ObjectMapperConfig.objectMapperConfig().gsonObjectMapperFactory(new GsonObjectMapperFactory(){

            @Override
            public Gson create(Class cls, String charset) {
                GsonBuilder gson = new GsonBuilder().serializeNulls().registerTypeAdapterFactory(new ExplicitNullsDereferencingFactory()).addSerializationExclusionStrategy(new SuppressReadOnlyStrategy()).registerTypeAdapter((Type)((Object)IntegrationProvider.class), new IntegrationProvider.Deserializer()).registerTypeAdapter((Type)((Object)AuthenticationRealm.class), new AuthenticationRealm.Deserializer()).registerTypeAdapter((Type)((Object)AuthorizationRealm.class), new AuthorizationRealm.Deserializer());
                if (log.isDebugEnabled()) {
                    gson.setPrettyPrinting();
                }
                return gson.create();
            }
        }));
        RestAssured.requestSpecification = new RequestSpecBuilder().setPort(80).build();
        try {
            TrustStrategy acceptingTrustStrategy = new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] certificate, String authType) {
                    return true;
                }
            };
            SSLSocketFactory sslFactory = new SSLSocketFactory(acceptingTrustStrategy, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            RestAssured.requestSpecification = RestAssured.given().config(RestAssured.config().sslConfig(SSLConfig.sslConfig().sslSocketFactory(sslFactory)));
            URL serverUrl = new URL(baseURL);
            if (serverUrl.getProtocol().equals("https") && serverUrl.getPort() == -1) {
                RestAssured.requestSpecification = RestAssured.given().port(443);
            }
        }
        catch (Exception ex) {
            log.error("Can not apply SSL strategy " + ex);
        }
        RestAssured.requestSpecification = log.isDebugEnabled() ? ((RequestSpecification)RestAssured.given().log().all(false)).filter(new ResponseLoggingFilter(LogDetail.ALL, false, System.out)) : RestAssured.given().filter(new ResponseLoggingFilter(LogDetail.ALL, false, System.out, Matchers.greaterThanOrEqualTo(400)));
        RestAssured.requestSpecification = RestAssured.given().baseUri(baseURL).contentType(ContentType.JSON).auth().basic(username, password).filter(new SessionFilter());
        RestAssured.expect().statusCode(401).get("ping", new Object[0]);
        RestAssured.expect().statusCode(200);
    }

    public static ClientEntity saveExpectStatus(ClientEntity entity, int statusCode) {
        log.debug("saveExpectStatus(" + statusCode + ")");
        if (entity.id == null) {
            log.debug("post()");
            entity.id = ((Response)entity.query.apply(RestAssured.given()).body((Object)entity, ObjectMapperType.GSON).expect().statusCode(statusCode).post(entity.writePath(), new Object[0])).then().extract().header("Location");
            log.debug("getting post() response Location");
            entity.id = entity.id.substring(entity.id.lastIndexOf(47) + 1);
            log.debug("retrieved post() response ID:" + entity.id);
        } else {
            log.debug("put()");
            entity.query.apply(RestAssured.given()).body((Object)entity, ObjectMapperType.GSON).expect().statusCode(statusCode).put(entity.writePath(entity.id), new Object[0]);
        }
        return entity;
    }
}

