/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LengthLimitedInputStream
extends FilterInputStream {
    protected long remaining;
    protected long readSinceMark;

    public LengthLimitedInputStream(InputStream in, long limit) {
        super(in);
        in.mark(0);
        this.remaining = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            throw new IOException("Stream ended prematurely");
        }
        --this.remaining;
        ++this.readSinceMark;
        return result;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)super.available(), this.remaining);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.readSinceMark = 0L;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.remaining == 0L) {
            return -1;
        }
        int read = this.in.read(b, off, len = (int)Math.min((long)len, this.remaining));
        if (read == -1) {
            throw new IOException("Stream ended prematurely");
        }
        this.remaining -= (long)read;
        this.readSinceMark += (long)read;
        return read;
    }

    @Override
    public void reset() throws IOException {
        if (this.remaining == 0L) {
            throw new IllegalStateException("Will not reset once read to EOF");
        }
        this.in.reset();
        this.remaining += this.readSinceMark;
        this.readSinceMark = 0L;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(Math.min(n, this.remaining));
        this.remaining -= skipped;
        this.readSinceMark += skipped;
        return skipped;
    }
}

