/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class Sandbox
implements ISandbox {
    private final ILocation copyFileAreaRoot;
    private final boolean isCaseSensitive;

    public Sandbox(ICopyFileArea copyFileArea) {
        this.copyFileAreaRoot = copyFileArea.getRoot();
        this.isCaseSensitive = copyFileArea.isCaseSensitive();
    }

    public Sandbox(ILocation copyFileAreaRoot) {
        this.copyFileAreaRoot = copyFileAreaRoot;
        this.isCaseSensitive = copyFileAreaRoot.isCaseSensitive();
    }

    @Override
    public IShare[] allShares(IProgressMonitor monitor) throws FileSystemException {
        return SharingManager.getInstance().allShares(this.copyFileAreaRoot, monitor);
    }

    @Override
    public IShareable findShareable(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemException {
        return SharingManager.getInstance().findShareable(this.copyFileAreaRoot, connection, component, versionable, monitor);
    }

    @Override
    public IShareable findShareable(IRelativeLocation location, ResourceType typeHint) {
        return SharingManager.getInstance().findShareable(this, location, typeHint);
    }

    @Override
    public IShareable findShareableByPath(IPath path, ResourceType typeHint) {
        return SharingManager.getInstance().findShareable(this, new RelativeLocation(path.segments()), typeHint);
    }

    @Override
    public List<IRelativeLocation> getPathRelativeToShares(IContextHandle context, IComponentHandle component, List<List<INameItemPair>> ancestorReports, IProgressMonitor progress) throws FileSystemException {
        return SharingManager.getInstance().getPathRelativeToShares(this.copyFileAreaRoot, context, component, ancestorReports, progress);
    }

    @Override
    public ILocation getRoot() {
        return this.copyFileAreaRoot;
    }

    public int hashCode() {
        return this.copyFileAreaRoot.getCanonicalForm(this.isCaseSensitive, true).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sandbox other = (Sandbox)obj;
        return this.copyFileAreaRoot.sameLocation(other.copyFileAreaRoot, this.isCaseSensitive & other.isCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public boolean isExistingSandbox() {
        return SharingManager.getInstance().isExistingCopyFileArea(this.copyFileAreaRoot, false);
    }

    @Override
    public boolean isRegistered() {
        return SharingManager.getInstance().isExistingCopyFileArea(this.copyFileAreaRoot, true);
    }

    @Override
    public boolean isCorrupted(IProgressMonitor monitor) throws FileSystemException {
        return SharingManager.getInstance().isCorruptedCopyFileArea(this.copyFileAreaRoot, monitor);
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedConfigurations(IProgressMonitor monitor) throws FileSystemException {
        return SharingManager.getInstance().allLoadedConfigurations(this.copyFileAreaRoot, monitor);
    }

    public String toString() {
        return this.getRoot().toString();
    }
}

