/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.filesystem.client.internal.copyfileareas.migration.DiskBackedHashMapEntriesValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.GlobalMetadataValidator;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.HeapValidator;
import com.ibm.team.internal.repository.rcp.util.RAFWrapper;
import java.io.File;
import java.io.IOException;

public class InverseItemInfoMapValidator
extends DiskBackedHashMapEntriesValidator {
    protected static final int STRING_TAG = 1;
    protected static final int INVERSE_ITEM_INFO_TAG = 3;
    protected static final int METADATA_VERSION = 4;
    protected static final int METADATA_VERSION_M5D1 = 5;
    protected static final int METADATA_VERSION_M6D1 = 6;
    protected static final int METADATA_VERSION_RC1 = 7;
    protected static final long NULL_CHECKSUM = -1L;
    protected File cfaRoot;

    public InverseItemInfoMapValidator(File rootPath, HeapValidator hv, GlobalMetadataValidator gv) throws IOException {
        super(hv, gv);
        this.cfaRoot = rootPath;
    }

    @Override
    public void beginValidation() throws IOException {
        super.beginValidation();
        if (!this.hv.getHeapFile().getName().equals(".inverseiteminfo.dat")) {
            this.log.append("Invalid inverse item info map file name " + this.hv.getHeapFile() + "\n");
        }
        if (!this.hv.getHeapFile().getParentFile().equals(this.cfaRoot)) {
            this.log.append("Invalid inverse item info map location " + this.hv.getHeapFile() + " relative to root " + this.cfaRoot + "\n");
        }
    }

    @Override
    public void validateEntry(long entryOffset, long keyOffset, boolean keyIsHeapADT, long valueOffset, boolean valueIsHeapADT, int hash, RAFWrapper raf) throws IOException {
        if (keyIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on inverse item info key of entry at " + entryOffset + "\n");
        }
        if (valueIsHeapADT) {
            this.log.append("HeapADT attribute unexpectedly set on inverse item info value of entry at " + entryOffset + "\n");
        }
        String itemId = this.validateKey(entryOffset, keyOffset, hash, raf);
        this.validateValue(entryOffset, valueOffset, raf, itemId);
    }

    protected String validateKey(long entryOffset, long keyOffset, int hashCode, RAFWrapper raf) throws IOException {
        if (keyOffset < 0L || keyOffset >= this.hv.getWorkingAreaSize()) {
            this.log.append("The inverse item info key pointer is at an impossible location " + keyOffset + " at " + entryOffset + "\n");
            return null;
        }
        this.setPosition(keyOffset);
        try {
            String itemId;
            int tag = this.validateByte("inverse item info key", keyOffset, "tag", raf);
            if (tag == -1) {
                return null;
            }
            if (tag != 1) {
                this.log.append("Unexpected tag found instead of STRING_TAG " + tag + " at offset " + keyOffset + "\n");
            }
            if ((itemId = this.validateUUID("inverse item info key", keyOffset, "item id", raf)) != null) {
                this.addKey(itemId, entryOffset, keyOffset, "inverse item info");
                if (hashCode != itemId.hashCode()) {
                    this.log.append("The entry at " + entryOffset + " contains a hash code (" + hashCode + ") for inverse item info key at " + keyOffset + " with item id \"" + itemId + "\" whose hash code is " + itemId.hashCode() + "\n");
                }
            }
            String string = itemId;
            return string;
        }
        finally {
            this.hv.claim(new HeapValidator.HeapClaimant(keyOffset, this.getPosition() - keyOffset, "Inverse Item Info Key"));
        }
    }

    /*
     * Exception decompiling
     */
    protected void validateValue(long entryOffset, long valueOffset, RAFWrapper raf, String keyItem) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 31[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static class ConnectionComponent {
        protected String connection;
        protected String component;

        public ConnectionComponent(String connection, String component) {
            this.connection = connection;
            this.component = component;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ConnectionComponent)) {
                return false;
            }
            ConnectionComponent other = (ConnectionComponent)obj;
            return other.connection.equals(this.connection) && other.component.equals(this.component);
        }

        public int hashCode() {
            return this.connection.hashCode() ^ this.component.hashCode();
        }
    }
}

