/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.queries;

import com.ibm.team.filesystem.client.internal.queries.AbstractQuery;
import com.ibm.team.filesystem.client.internal.queries.IQuery;
import com.ibm.team.filesystem.client.internal.queries.QueryCache;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.IFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public final class FilteredQuery
extends AbstractQuery {
    private IQuery toFilter;
    private IFilter toApply;

    public FilteredQuery(IQuery toFilter, IFilter toApply) {
        this.toFilter = toFilter;
        this.toApply = toApply;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)obj;
            return fq.toApply.equals(this.toApply) && fq.toFilter.equals(this.toFilter);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.toFilter.hashCode() + this.toApply.hashCode();
    }

    @Override
    public List compute(IProgressMonitor mon) throws TeamRepositoryException {
        List unfiltered = QueryCache.execute(this.toFilter, mon);
        ArrayList filtered = new ArrayList();
        for (Object next : unfiltered) {
            if (!this.toApply.select(next)) continue;
            filtered.add(next);
        }
        return filtered;
    }
}

