/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.rest.util.CommitUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ConflictResolutionUtil;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.rest.util.ISyncViewProxy;
import com.ibm.team.filesystem.client.internal.rest.util.RefreshUtil;
import com.ibm.team.filesystem.client.internal.rest.util.SandboxUpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.UpdateDilemmaUtil;
import com.ibm.team.filesystem.client.internal.rest.util.VerifyOutOfSyncUtil;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.AbortCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CloseChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CompleteCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.CreateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAbortCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.ICompleteCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.ICreateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.IProcessAcceptQueueOperation;
import com.ibm.team.filesystem.client.operations.IUpdateCurrentPatchOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ProcessAcceptQueueDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAbortCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCloseChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompleteChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompleteCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCreateCurrentPatch;
import com.ibm.team.filesystem.client.rest.parameters.ParmsProcessAcceptQueue;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateCurrentPatch;
import com.ibm.team.filesystem.common.IContentChangeDetail;
import com.ibm.team.filesystem.common.IContentTypeChangeDetail;
import com.ibm.team.filesystem.common.IEncodingChangeDetail;
import com.ibm.team.filesystem.common.IExecutableBitChangeDetail;
import com.ibm.team.filesystem.common.ILineDelimiterChangeDetail;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ISymbolicLinkChangeDetail;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CompleteChangeSetsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ChangeSetDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ConfigurationWithUncheckedInChangesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.FilesystemRestClientDTOcoreFactory;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.CommitDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.SandboxUpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.dilemma.UpdateDilemmaDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.AbortCurrentPatchResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.AcceptQueueDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ChangeSetSourceDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CompleteCurrentPatchResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ContentChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ContentTypeChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.CurrentPatchDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.EncodingChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ExecuteBitChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.FilesystemRestClientDTOpatchFactory;
import com.ibm.team.filesystem.common.internal.rest.client.patch.LineDelimiterChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.MoveChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.PageDescriptorDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ProcessAcceptQueueResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.PropertyChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.SymbolicLinkChangeDetailDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.UpdateCurrentPatchResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.VersionableChangeDTO;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IChangeSetSource;
import com.ibm.team.scm.common.IChangeSetSourcesPage;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IMoveChangeDetail;
import com.ibm.team.scm.common.IPageDescriptor;
import com.ibm.team.scm.common.IPropertyChangeDetail;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class PortsDTOUtil {
    public static ChangeSetSourceDTO asPortSourceDTO(IChangeSetHandle changeSet) {
        if (changeSet == null) {
            return null;
        }
        ChangeSetSourceDTO csps = FilesystemRestClientDTOpatchFactory.eINSTANCE.createChangeSetSourceDTO();
        csps.setSourceId(changeSet.getItemId().getUuidValue());
        csps.setSourceType("changeset");
        return csps;
    }

    private static ChangeSetSourceDTO asChangeSetSourceDTO(IChangeSetSource portSource) {
        ChangeSetSourceDTO csps = FilesystemRestClientDTOpatchFactory.eINSTANCE.createChangeSetSourceDTO();
        csps.setSourceId(portSource.getSourceId().getUuidValue());
        csps.setSourceType(PortsDTOUtil.getSourceType(portSource));
        return csps;
    }

    private static String getSourceType(IChangeSetSource portSource) {
        if (portSource.getSourceType() == 1) {
            return "changeset";
        }
        return "patch";
    }

    public static CurrentPatchDTO asCurrentPortDTO(ICurrentPatch currentPort) {
        if (currentPort == null) {
            return null;
        }
        CurrentPatchDTO cpDto = FilesystemRestClientDTOpatchFactory.eINSTANCE.createCurrentPatchDTO();
        IChangeSetSource ps = currentPort.getSource();
        cpDto.setSource(PortsDTOUtil.asChangeSetSourceDTO(ps));
        if (currentPort.getTargetChangeSet() != null) {
            cpDto.setTargetChangeSetId(currentPort.getTargetChangeSet().getItemId().getUuidValue());
        }
        cpDto.setComponentId(currentPort.getComponent().getItemId().getUuidValue());
        cpDto.setWorkspaceId(currentPort.getWorkspace().getItemId().getUuidValue());
        for (IVersionableChange portChange : currentPort.getVersionableChanges()) {
            VersionableChangeDTO pcDto = PortsDTOUtil.asPortChangeDto(portChange);
            cpDto.getChanges().add(pcDto);
        }
        return cpDto;
    }

    public static AcceptQueueDTO getPortData(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IPageDescriptor pageDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        AcceptQueueDTO portsDTO = FilesystemRestClientDTOpatchFactory.eINSTANCE.createAcceptQueueDTO();
        ICurrentPatch currentPort = workspaceConnection.getCurrentPatch(componentHandle);
        CurrentPatchDTO cpDto = PortsDTOUtil.asCurrentPortDTO(currentPort);
        if (cpDto != null) {
            portsDTO.setCurrentPatch(cpDto);
        }
        if (pageDescriptor != null) {
            int maxPageSize = pageDescriptor.getMaxPageSize();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)maxPageSize);
            IChangeSetSourcesPage page = workspaceConnection.fetchFromAcceptQueue(pageDescriptor, (IProgressMonitor)progress);
            for (IChangeSetSource portSource : page.getChangeSetSources()) {
                ChangeSetSourceDTO csps = PortsDTOUtil.asChangeSetSourceDTO(portSource);
                portsDTO.getAcceptQueue().add(csps);
            }
            pageDescriptor = page.getPageDescriptor();
            PageDescriptorDTO pageDescriptorDTO = FilesystemRestClientDTOpatchFactory.eINSTANCE.createPageDescriptorDTO();
            pageDescriptorDTO.setRepositoryURI(workspaceConnection.teamRepository().getRepositoryURI());
            pageDescriptorDTO.setWorkspaceID(pageDescriptor.getWorkspace().getItemId().getUuidValue());
            pageDescriptorDTO.setComponentID(componentHandle.getItemId().getUuidValue());
            pageDescriptorDTO.setMaxPageSize(pageDescriptor.getMaxPageSize());
            pageDescriptorDTO.setStartIndex(pageDescriptor.getStartIndex());
            pageDescriptorDTO.setTotalSize(pageDescriptor.getTotalSize());
            pageDescriptorDTO.setSyncTime(pageDescriptor.getSyncTime());
            portsDTO.setPageDescriptor(pageDescriptorDTO);
        }
        return portsDTO;
    }

    private static VersionableChangeDTO asPortChangeDto(IVersionableChange portChange) {
        IVersionableChange vc = portChange;
        VersionableChangeDTO vcd = FilesystemRestClientDTOpatchFactory.eINSTANCE.createVersionableChangeDTO();
        vcd.setVersionableItemId(vc.getVersionable().getItemId().getUuidValue());
        vcd.setVersionableType(CoreUtil.getVersionableItemType(vc.getVersionable()));
        vcd.setName(vc.getName());
        vcd.setParentPathHint(PortsDTOUtil.toString(vc.getParentPathHint(), false));
        vcd.setKind(PortsDTOUtil.getVersionableChangeKindString(vc.kind()));
        vcd.setChangeType(PortsDTOUtil.getVersionableChangeTypeString(vc.changeType()));
        vcd.setResolved(vc.isResolved());
        if ((vc.getFlags() & 0x10) != 0) {
            if ((vc.getFlags() & 0x20) != 0) {
                vcd.getIncidentals().add("item_missing");
            }
            if ((vc.getFlags() & 0x40) != 0) {
                vcd.getIncidentals().add("parent_missing");
            }
            if ((vc.getFlags() & 0x80) != 0) {
                vcd.getIncidentals().add("name_collision");
            }
            if ((vc.getFlags() & 0x100) != 0) {
                vcd.getIncidentals().add("depends_on_change");
            }
            if ((vc.getFlags() & 0x200) != 0) {
                vcd.getIncidentals().add("has_descendants");
            }
        }
        if (vc.getBeforeState() != null) {
            vcd.setBeforeStateId(vc.getBeforeState().getStateId().getUuidValue());
        }
        if (vc.getAfterState() != null) {
            vcd.setAfterStateId(vc.getAfterState().getStateId().getUuidValue());
        }
        if (vc.getConfigurationState() != null) {
            vcd.setConfigurationStateId(vc.getConfigurationState().getStateId().getUuidValue());
        }
        for (UUID uuid : vc.getChildChanges()) {
            vcd.getChildChanges().add(uuid.getUuidValue());
        }
        if (vc.getDependsOnId() != null) {
            vcd.setDependsOnId(vc.getDependsOnId().getUuidValue());
        }
        for (IChangeDetail changeDetail : vc.getChanges()) {
            ChangeDetailDTO cdd = PortsDTOUtil.asChangeDetailDto(changeDetail);
            vcd.getChangeDetails().add(cdd);
        }
        return vcd;
    }

    private static String getVersionableChangeTypeString(int changeType) {
        switch (changeType) {
            case 8: {
                return "add";
            }
            case 4: {
                return "delete";
            }
        }
        return "mod";
    }

    private static String getVersionableChangeKindString(int kind) {
        switch (kind) {
            case 1: {
                return "autoresolve";
            }
            case 3: {
                return "gap";
            }
            case 2: {
                return "conflict";
            }
        }
        return "autoresolve";
    }

    private static String toString(String[] path, boolean ignoreLast) {
        if (path == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int length = path.length;
        if (ignoreLast) {
            --length;
        }
        int i = 0;
        while (i < length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return buffer.toString();
    }

    private static ChangeDetailDTO asChangeDetailDto(IChangeDetail changeDetail) {
        ChangeDetailDTO dto = PortsDTOUtil.internalAsChangeDetailDto(changeDetail);
        dto.setId(changeDetail.getId().getUuidValue());
        dto.setPortChangeId(changeDetail.getParentId().getUuidValue());
        dto.setResolved(changeDetail.isResolved());
        dto.setKind(PortsDTOUtil.getChangeDetailKindString(changeDetail.kind()));
        return dto;
    }

    private static String getChangeDetailKindString(int kind) {
        switch (kind) {
            case 0: {
                return "autoresolve";
            }
            case 1: {
                return "conflict";
            }
            case 2: {
                return "incidental";
            }
        }
        return "autoresolve";
    }

    private static ChangeDetailDTO internalAsChangeDetailDto(IChangeDetail changeDetail) {
        if (changeDetail instanceof IPropertyChangeDetail) {
            IPropertyChangeDetail pcd = (IPropertyChangeDetail)changeDetail;
            PropertyChangeDetailDTO pcdd = FilesystemRestClientDTOpatchFactory.eINSTANCE.createPropertyChangeDetailDTO();
            pcdd.setPropertyName(pcd.getPropertyName());
            pcdd.setBeforeValue(pcd.getBeforeValue());
            pcdd.setAfterValue(pcd.getAfterValue());
            pcdd.setType(PortsDTOUtil.getPropertyChangeType(pcd.getType()));
            return pcdd;
        }
        if (changeDetail instanceof IMoveChangeDetail) {
            IMoveChangeDetail mcd = (IMoveChangeDetail)changeDetail;
            MoveChangeDetailDTO mcdd = FilesystemRestClientDTOpatchFactory.eINSTANCE.createMoveChangeDetailDTO();
            mcdd.setBeforeName(mcd.getBeforeName());
            mcdd.setAfterName(mcd.getAfterName());
            mcdd.setBeforeParentId(mcd.getBeforeParent().getItemId().getUuidValue());
            mcdd.setAfterParentId(mcd.getAfterParent().getItemId().getUuidValue());
            mcdd.setBeforeParentPathHint(PortsDTOUtil.toString(mcd.getBeforeParentPathHint(), false));
            mcdd.setAfterParentPathHint(PortsDTOUtil.toString(mcd.getAfterParentPathHint(), false));
            if ((mcd.getFlags() & 2) != 0) {
                if ((mcd.getFlags() & 0x80) != 0) {
                    mcdd.setIncidentalDetails("name_collision");
                } else if ((mcd.getFlags() & 0x40) != 0) {
                    mcdd.setIncidentalDetails("parent_missing");
                } else if ((mcd.getFlags() & 0x100) != 0) {
                    mcdd.setIncidentalDetails("depends_on_change");
                }
            }
            return mcdd;
        }
        if (changeDetail instanceof ISymbolicLinkChangeDetail) {
            ISymbolicLinkChangeDetail slcd = (ISymbolicLinkChangeDetail)changeDetail;
            SymbolicLinkChangeDetailDTO slcdd = FilesystemRestClientDTOpatchFactory.eINSTANCE.createSymbolicLinkChangeDetailDTO();
            slcdd.setBeforeTarget(slcd.getBeforeTarget());
            slcdd.setAfterTarget(slcd.getAfterTarget());
            slcdd.setBeforeDirectory(slcd.isBeforeDirectory());
            slcdd.setAfterDirectory(slcd.isAfterDirectory());
            return slcdd;
        }
        if (changeDetail instanceof IContentChangeDetail) {
            IContentChangeDetail bcd = (IContentChangeDetail)changeDetail;
            ContentChangeDetailDTO cdDto = FilesystemRestClientDTOpatchFactory.eINSTANCE.createContentChangeDetailDTO();
            cdDto.setBeforeContentHash(bcd.getBeforeContentHash().toString());
            cdDto.setAfterContentHash(bcd.getAfterContentHash().toString());
            return cdDto;
        }
        if (changeDetail instanceof IEncodingChangeDetail) {
            IEncodingChangeDetail cd = (IEncodingChangeDetail)changeDetail;
            EncodingChangeDetailDTO cdDto = FilesystemRestClientDTOpatchFactory.eINSTANCE.createEncodingChangeDetailDTO();
            cdDto.setBeforeCharacterEncoding(cd.getBeforeCharacterEncoding());
            cdDto.setAfterCharacterEncoding(cd.getAfterCharacterEncoding());
            return cdDto;
        }
        if (changeDetail instanceof ILineDelimiterChangeDetail) {
            ILineDelimiterChangeDetail cd = (ILineDelimiterChangeDetail)changeDetail;
            LineDelimiterChangeDetailDTO cdDto = FilesystemRestClientDTOpatchFactory.eINSTANCE.createLineDelimiterChangeDetailDTO();
            cdDto.setBeforeLineDelimiter(CoreUtil.getLineDelimiter(cd.getBeforeLineDelimiter()));
            cdDto.setAfterLineDelimiter(CoreUtil.getLineDelimiter(cd.getAfterLineDelimiter()));
            return cdDto;
        }
        if (changeDetail instanceof IContentTypeChangeDetail) {
            IContentTypeChangeDetail cd = (IContentTypeChangeDetail)changeDetail;
            ContentTypeChangeDetailDTO cdDto = FilesystemRestClientDTOpatchFactory.eINSTANCE.createContentTypeChangeDetailDTO();
            cdDto.setBeforeContentType(cd.getBeforeType());
            cdDto.setAfterContentType(cd.getAfterType());
            return cdDto;
        }
        if (changeDetail instanceof IExecutableBitChangeDetail) {
            IExecutableBitChangeDetail cd = (IExecutableBitChangeDetail)changeDetail;
            ExecuteBitChangeDetailDTO cdDto = FilesystemRestClientDTOpatchFactory.eINSTANCE.createExecuteBitChangeDetailDTO();
            cdDto.setExecutable(cd.isExecutable());
            return cdDto;
        }
        throw new IllegalStateException(NLS.bind((String)"Unexpected IChangeDetail type : {0}", (Object)changeDetail.getClass().getName()));
    }

    private static String getPropertyChangeType(int type) {
        switch (type) {
            case 1: {
                return "add";
            }
            case 2: {
                return "delete";
            }
        }
        return "mod";
    }

    public static AbortCurrentPatchResultDTO abortPorts(ParmsAbortCurrentPatch parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        List<IComponentHandle> componentHandles = parms.getComponentHandles();
        AbortCurrentPatchResultDTO result = FilesystemRestClientDTOpatchFactory.eINSTANCE.createAbortCurrentPatchResultDTO();
        AbortCurrentPatchDilemmaHandler dilemmaHandler = PortsDTOUtil.getAbortPortsDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(5));
        IAbortCurrentPatchOperation op = IOperationFactory.instance.getAbortCurrentPatchOperation(dilemmaHandler);
        op.setFlags(PortsDTOUtil.getPortAbortFlags(parms));
        op.abort(wc, componentHandles);
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        return result;
    }

    private static AbortCurrentPatchDilemmaHandler getAbortPortsDilemmaHandler(ParmsAbortCurrentPatch parms, List outOfSyncShares, final List<ConfigurationWithUncheckedInChangesDTO> configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor progress) throws TeamRepositoryException {
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        AbortCurrentPatchDilemmaHandler dilemmaHandler = new AbortCurrentPatchDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    private static int getPortAbortFlags(ParmsAbortCurrentPatch parms) {
        if (parms.action != null) {
            if (parms.action.equals("discard_all")) {
                return 2;
            }
            if (parms.action.equals("discard_current")) {
                return 1;
            }
        }
        return 0;
    }

    public static CompleteCurrentPatchResultDTO completeCurrentPort(ParmsCompleteCurrentPatch parms, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        CompleteCurrentPatchResultDTO result = FilesystemRestClientDTOpatchFactory.eINSTANCE.createCompleteCurrentPatchResultDTO();
        CompleteCurrentPatchDilemmaHandler dilemmaHandler = PortsDTOUtil.getCompleteCurrentPortDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getUnresolvedChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), monitor.newChild(5));
        ICompleteCurrentPatchOperation op = IOperationFactory.instance.getCompleteCurrentPatchOperation(dilemmaHandler);
        op.completeCurrentPatch(wc, parms.getComponentHandle());
        op.setFlags(parms.getFlags());
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        try {
            result.setAcceptQueueSize(wc.getAcceptQueueSize(parms.getComponentHandle()));
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
        return result;
    }

    private static CompleteCurrentPatchDilemmaHandler getCompleteCurrentPortDilemmaHandler(ParmsCompleteCurrentPatch parms, List outOfSyncShares, final List configurationsWithUncheckedInChanges, final List unresolvedPortChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, SubMonitor progress) {
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, (IProgressMonitor)progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final int unresolvedChangesInstruction = PortsDTOUtil.getInstruction(parms.completeCurrentPortDilemmaHandler != null ? parms.completeCurrentPortDilemmaHandler.unresolvedChangesInstruction : null);
        CompleteCurrentPatchDilemmaHandler dilemmaHandler = new CompleteCurrentPatchDilemmaHandler(){

            @Override
            public int unresolvedChanges(Collection<IVersionableChange> unresolvedChanges) {
                if (unresolvedPortChanges != null) {
                    for (IVersionableChange portChange : unresolvedChanges) {
                        unresolvedPortChanges.add(PortsDTOUtil.asPortChangeDto(portChange));
                    }
                }
                return unresolvedChangesInstruction;
            }

            @Override
            protected int evaluateUncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    private static int getInstruction(String instruction) {
        int result = instruction == null ? 2 : (instruction.equals("cancel") ? 1 : (instruction.equals("no") ? 3 : (instruction.equals("continue") ? 0 : 2)));
        return result;
    }

    public static UpdateCurrentPatchResultDTO createCurrentPatch(ParmsCreateCurrentPatch parms, ISyncViewProxy syncViewProxy, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        IWorkspaceConnection sourceWorkspace = parms.sourceWorkspace == null ? wc : parms.sourceWorkspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        UpdateCurrentPatchResultDTO result = FilesystemRestClientDTOpatchFactory.eINSTANCE.createUpdateCurrentPatchResultDTO();
        CreateCurrentPatchDilemmaHandler dilemmaHandler = PortsDTOUtil.getCreateCurrentPatchDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), (IProgressMonitor)monitor.newChild(5));
        ICreateCurrentPatchOperation op = IOperationFactory.instance.getCreateCurrentPatchOperation(dilemmaHandler);
        op.setContext(wc, parms.getComponentHandle());
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        ICurrentPatch currentPort = wc.getCurrentPatch(parms.getComponentHandle());
        if (currentPort != null) {
            throw new TeamRepositoryException(Messages.PortsDTOUtil_2);
        }
        Collection<ILogicalChange> conflicts = ConflictResolutionUtil.getConflicts(sourceWorkspace, parms.conflicts, syncViewProxy, (IProgressMonitor)monitor.newChild(5));
        boolean hasConflictToApply = false;
        for (ILogicalChange conflict : conflicts) {
            if (!PortsDTOUtil.isPatchableConflict(conflict)) continue;
            op.applyConflict(conflict);
            hasConflictToApply = true;
        }
        if (!hasConflictToApply) {
            if (conflicts.isEmpty()) {
                throw new TeamRepositoryException(Messages.PortsDTOUtil_4);
            }
            throw new TeamRepositoryException(Messages.PortsDTOUtil_5);
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        if (!result.isCancelled()) {
            currentPort = wc.getCurrentPatch(parms.getComponentHandle());
            if (currentPort == null) {
                throw new TeamRepositoryException(Messages.PortsDTOUtil_3);
            }
            UUID[] changeIds = PortsDTOUtil.getAffectedItemIds(currentPort);
            Map<UUID, Set<UUID>> requests = PortsDTOUtil.createUpdateRequestMap(currentPort, changeIds);
            result.setCurrentPatch(PortsDTOUtil.asCurrentPortDTO(currentPort));
            for (Map.Entry<UUID, Set<UUID>> request : requests.entrySet()) {
                IVersionableChange change = currentPort.getVersionableChange(request.getKey());
                IVersionableHandle versionable = change.getVersionable();
                if (change.isResolved()) {
                    result.getResolvedVersionableIds().add(versionable.getItemId().getUuidValue());
                }
                Set<UUID> details = request.getValue();
                for (UUID uuid : details) {
                    IChangeDetail changeDetail = change.getChangeDetail(uuid);
                    if (!changeDetail.isResolved()) continue;
                    result.getResolvedChangeDetailIds().add(changeDetail.getId().getUuidValue());
                }
            }
        }
        return result;
    }

    private static boolean isPatchableConflict(ILogicalChange conflict) {
        return conflict.kind() != 3 || !conflict.isChangeType(2);
    }

    private static UUID[] getAffectedItemIds(ICurrentPatch currentPort) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (IVersionableChange vc : currentPort.getVersionableChanges()) {
            result.add(vc.getId());
        }
        return result.toArray(new UUID[result.size()]);
    }

    private static CreateCurrentPatchDilemmaHandler getCreateCurrentPatchDilemmaHandler(ParmsCreateCurrentPatch parms, List outOfSyncShares, List configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, IProgressMonitor progress) {
        SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, progress);
        CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        final UpdateCurrentPatchDilemmaHandler updateCurrentPatchDilemmaHandler = PortsDTOUtil.getUpdateCurrentPatchDilemmaHandler(sandboxUpdateDilemmaUtil, updateDilemmaUtil, commitDilemmaHandler, configurationsWithUncheckedInChanges, uncheckedInChangesInstruction);
        CreateCurrentPatchDilemmaHandler dilemmaHandler = new CreateCurrentPatchDilemmaHandler(){

            @Override
            public UpdateCurrentPatchDilemmaHandler getUpdateCurrentPortDilemmaHandler() {
                return updateCurrentPatchDilemmaHandler;
            }
        };
        return dilemmaHandler;
    }

    public static UpdateCurrentPatchResultDTO updateCurrentPort(ParmsUpdateCurrentPatch parms, IProgressMonitor progress) throws TeamRepositoryException {
        IVersionableHandle versionable;
        IVersionableChange change;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        UpdateCurrentPatchResultDTO result = FilesystemRestClientDTOpatchFactory.eINSTANCE.createUpdateCurrentPatchResultDTO();
        UpdateCurrentPatchDilemmaHandler dilemmaHandler = PortsDTOUtil.getUpdateCurrentPortDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), monitor.newChild(5));
        IUpdateCurrentPatchOperation op = IOperationFactory.instance.getUpdateCurrentPortOperation(dilemmaHandler);
        op.setContext(wc, parms.getComponentHandle());
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        ICurrentPatch currentPort = wc.getCurrentPatch(parms.getComponentHandle());
        if (currentPort == null) {
            throw new TeamRepositoryException(Messages.PortsDTOUtil_0);
        }
        Map<UUID, Set<UUID>> requests = PortsDTOUtil.createUpdateRequestMap(currentPort, parms);
        for (Map.Entry<UUID, Set<UUID>> request : requests.entrySet()) {
            change = currentPort.getVersionableChange(request.getKey());
            versionable = change.getVersionable();
            PortsDTOUtil.requestUpdate(op, parms, versionable, request.getValue());
        }
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        currentPort = wc.getCurrentPatch(parms.getComponentHandle());
        if (currentPort != null) {
            result.setCurrentPatch(PortsDTOUtil.asCurrentPortDTO(currentPort));
        }
        for (Map.Entry<UUID, Set<UUID>> request : requests.entrySet()) {
            change = currentPort.getVersionableChange(request.getKey());
            versionable = change.getVersionable();
            if (change.isResolved()) {
                result.getResolvedVersionableIds().add(versionable.getItemId().getUuidValue());
            }
            Set<UUID> details = request.getValue();
            for (UUID uuid : details) {
                IChangeDetail changeDetail = change.getChangeDetail(uuid);
                if (!changeDetail.isResolved()) continue;
                result.getResolvedChangeDetailIds().add(changeDetail.getId().getUuidValue());
            }
        }
        return result;
    }

    private static Map<UUID, Set<UUID>> createUpdateRequestMap(ICurrentPatch currentPort, ParmsUpdateCurrentPatch parms) throws ItemNotFoundException {
        UUID[] changeIds = new UUID[parms.changeIds.length];
        int i = 0;
        while (i < parms.changeIds.length) {
            UUID id;
            String idString = parms.changeIds[i];
            changeIds[i] = id = UUID.valueOf((String)idString);
            ++i;
        }
        return PortsDTOUtil.createUpdateRequestMap(currentPort, changeIds);
    }

    private static Map<UUID, Set<UUID>> createUpdateRequestMap(ICurrentPatch currentPort, UUID[] changeIds) throws ItemNotFoundException {
        HashMap<UUID, Set<UUID>> result = new HashMap<UUID, Set<UUID>>();
        UUID[] uUIDArray = changeIds;
        int n = changeIds.length;
        int n2 = 0;
        while (n2 < n) {
            UUID id = uUIDArray[n2];
            IVersionableChange change = currentPort.getVersionableChange(id);
            if (change == null) {
                IVersionableChange vc = PortsDTOUtil.findVersionableChangeForDetailId(currentPort, id);
                if (vc == null) {
                    throw new ItemNotFoundException(NLS.bind((String)Messages.PortsDTOUtil_1, (Object)id.getUuidValue()));
                }
                HashSet<UUID> set = (HashSet<UUID>)result.get(vc.getId());
                if (set == null) {
                    set = new HashSet<UUID>();
                    result.put(vc.getId(), set);
                }
                set.add(id);
            } else {
                result.put(change.getId(), new HashSet());
            }
            ++n2;
        }
        return result;
    }

    private static IVersionableChange findVersionableChangeForDetailId(ICurrentPatch currentPort, UUID id) {
        for (IVersionableChange pc : currentPort.getVersionableChanges()) {
            if (pc.getChangeDetail(id) == null) continue;
            return pc;
        }
        return null;
    }

    private static void requestUpdate(IUpdateCurrentPatchOperation op, ParmsUpdateCurrentPatch parms, IVersionableHandle versionable, Set<UUID> changeDetailIds) {
        if (parms.action.equals("autoresolve")) {
            op.autoResolve(versionable, changeDetailIds, parms.isBestEffort());
        } else if (parms.action.equals("mark_as_resolved")) {
            op.markAsResolved(versionable, changeDetailIds, parms.isForce());
        } else if (parms.action.equals("mark_as_unresolved")) {
            op.markAsUnresolved(versionable, changeDetailIds);
        } else if (parms.action.equals("resolve_with_proposed")) {
            op.resolveWithProposed(versionable, changeDetailIds, parms.isForce());
        } else if (parms.action.equals("undo")) {
            op.undoChanges(versionable, changeDetailIds, parms.isForce());
        } else if (parms.action.equals("reparent")) {
            IFolderHandle newParent = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(UUID.valueOf((String)parms.newParenId), null);
            op.reparentVersionable(versionable, newParent);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static UpdateCurrentPatchDilemmaHandler getUpdateCurrentPortDilemmaHandler(ParmsUpdateCurrentPatch parms, List outOfSyncShares, List configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, SubMonitor progress) {
        SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, (IProgressMonitor)progress);
        CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        return PortsDTOUtil.getUpdateCurrentPatchDilemmaHandler(sandboxUpdateDilemmaUtil, updateDilemmaUtil, commitDilemmaHandler, configurationsWithUncheckedInChanges, uncheckedInChangesInstruction);
    }

    private static UpdateCurrentPatchDilemmaHandler getUpdateCurrentPatchDilemmaHandler(final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil, final UpdateDilemmaUtil updateDilemmaUtil, final CommitDilemmaHandler commitDilemmaHandler, final List configurationsWithUncheckedInChanges, final int uncheckedInChangesInstruction) {
        UpdateCurrentPatchDilemmaHandler dilemmaHandler = new UpdateCurrentPatchDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    public static ProcessAcceptQueueResultDTO processPendingPorts(ParmsProcessAcceptQueue parms, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IWorkspaceConnection wc = parms.workspace.getWorkspaceConnection((IProgressMonitor)monitor.newChild(5));
        ProcessAcceptQueueResultDTO result = FilesystemRestClientDTOpatchFactory.eINSTANCE.createProcessAcceptQueueResultDTO();
        ProcessAcceptQueueDilemmaHandler dilemmaHandler = PortsDTOUtil.getProcessPendingPortstDilemmaHandler(parms, result.getOutOfSyncShares(), result.getConfigurationsWithUncheckedInChanges(), result.getCommitDilemma(), result.getSandboxUpdateDilemma(), result.getUpdateDilemma(), monitor.newChild(5));
        IProcessAcceptQueueOperation op = IOperationFactory.instance.getProcessAcceptQueueOperation(dilemmaHandler);
        op.processAcceptQueue(wc, parms.getComponentHandle());
        op.setFlags(parms.getFlags());
        RefreshUtil.configureRefresh(parms.preoperationRefresh, op);
        CommitUtil.configureCommit(parms.pendingChangesDilemmaHandler, (ICheckinOptions)op);
        try {
            op.run((IProgressMonitor)monitor.newChild(90));
        }
        catch (OperationCanceledException operationCanceledException) {
            result.setCancelled(true);
        }
        ICurrentPatch currentPort = wc.getCurrentPatch(parms.getComponentHandle());
        if (currentPort != null) {
            result.setCurrentPatch(PortsDTOUtil.asCurrentPortDTO(currentPort));
        }
        try {
            result.setAcceptQueueSize(wc.getAcceptQueueSize(parms.getComponentHandle()));
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
        return result;
    }

    private static ProcessAcceptQueueDilemmaHandler getProcessPendingPortstDilemmaHandler(ParmsProcessAcceptQueue parms, List outOfSyncShares, final List configurationsWithUncheckedInChanges, CommitDilemmaDTO commitDilemma, SandboxUpdateDilemmaDTO sandboxUpdateDilemma, UpdateDilemmaDTO updateDilemma, SubMonitor progress) {
        final SandboxUpdateDilemmaUtil sandboxUpdateDilemmaUtil = new SandboxUpdateDilemmaUtil(parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma);
        final UpdateDilemmaUtil updateDilemmaUtil = new UpdateDilemmaUtil(parms.updateDilemmaHandler, updateDilemma);
        OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = VerifyOutOfSyncUtil.getOutOfSyncDilemmaHandler(parms.outOfSyncInstructions, outOfSyncShares, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, (IProgressMonitor)progress);
        final CommitDilemmaHandler commitDilemmaHandler = CommitUtil.getCommitDilemmaHandler(parms.pendingChangesDilemmaHandler, commitDilemma, parms.sandboxUpdateDilemmaHandler, sandboxUpdateDilemma, parms.updateDilemmaHandler, updateDilemma, outOfSyncDilemmaHandler);
        final int uncheckedInChangesInstruction = CommitUtil.getUncheckedInChangesInstruction(parms.pendingChangesDilemmaHandler);
        ProcessAcceptQueueDilemmaHandler dilemmaHandler = new ProcessAcceptQueueDilemmaHandler(){

            @Override
            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> configurationToChangesMap) {
                if (configurationsWithUncheckedInChanges != null) {
                    for (Map.Entry<ConfigurationFacade, Collection<ILocalChange>> entry : configurationToChangesMap.entrySet()) {
                        ConfigurationWithUncheckedInChangesDTO uncheckedInChanges = FilesystemRestClientDTOcoreFactory.eINSTANCE.createConfigurationWithUncheckedInChangesDTO();
                        uncheckedInChanges.setConfiguration(CoreUtil.translateConfigurationDescriptor(entry.getKey()));
                        uncheckedInChanges.setChangeCount(entry.getValue().size());
                        configurationsWithUncheckedInChanges.add(uncheckedInChanges);
                    }
                }
                return uncheckedInChangesInstruction;
            }

            @Override
            public CommitDilemmaHandler getCommitDilemmaHandler() {
                return commitDilemmaHandler;
            }

            @Override
            public BackupDilemmaHandler getBackupDilemmaHandler() {
                return sandboxUpdateDilemmaUtil.getBackupDilemmaHandler();
            }

            @Override
            public int deletedContent(Collection<IShareable> contentDeleted) {
                return sandboxUpdateDilemmaUtil.deletedContent(contentDeleted);
            }

            @Override
            public int inaccessibleForUpdate(Collection<IShareable> shareables) {
                return updateDilemmaUtil.inaccessibleForUpdate(shareables);
            }

            @Override
            public int siblingSharesToAdd(Collection<IShareable> shareables) {
                return updateDilemmaUtil.siblingSharesToAdd(shareables);
            }
        };
        return dilemmaHandler;
    }

    public static CloseChangeSetsDilemmaHandler getCompleteChangeSetsDilemmaHandler(ParmsCompleteChangeSets parms, final CompleteChangeSetsResultDTO result) {
        final int closeChangeSetsInstruction = PortsDTOUtil.getPortsCheckedInInstruction(parms.closeChangeSetsDilemmaHandler);
        return new CloseChangeSetsDilemmaHandler(){

            @Override
            public int portsInProgress(List<IChangeSet> targetChangeSets) {
                for (IChangeSet changeSet : targetChangeSets) {
                    ChangeSetDTO dto = FilesystemRestClientDTOcoreFactory.eINSTANCE.createChangeSetDTO();
                    dto.setItemId(changeSet.getItemId().getUuidValue());
                    dto.setComment(changeSet.getComment());
                    dto.setLastChangeDate(changeSet.getLastChangeDate().getTime());
                    result.getTargetChangeSets().add(dto);
                }
                return closeChangeSetsInstruction;
            }
        };
    }

    private static int getPortsCheckedInInstruction(ParmsCloseChangeSetsDilemmaHandler closeChangeSetsDilemmaHandler) {
        if (closeChangeSetsDilemmaHandler == null) {
            return 2;
        }
        String instruction = closeChangeSetsDilemmaHandler.portsInProgressInstruction;
        if (instruction == null || instruction.equals("fail")) {
            return 2;
        }
        if (instruction.equals("continue")) {
            return 0;
        }
        if (instruction.equals("cancel")) {
            return 1;
        }
        if (instruction.equals("no")) {
            return 3;
        }
        throw new IllegalArgumentException("The value of the instruction must be one of cancel, continue, no or fail");
    }
}

