/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.utils.IDaemonRegistry;
import com.ibm.team.filesystem.client.internal.utils.IFSDaemon;
import com.ibm.team.repository.common.LogFactory;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class SandboxClaimer
implements ICopyFileAreaListener {
    private static final Log log = LogFactory.getLog((String)SandboxClaimer.class.getName());
    private final IFSDaemon daemon;
    private final Job initialStorageJob;

    public SandboxClaimer(IFSDaemon fsDaemon) {
        this.daemon = fsDaemon;
        this.initialStorageJob = new Job("Storing Initial Sandbox List"){

            protected IStatus run(IProgressMonitor progress) {
                try {
                    SandboxClaimer.this.daemon.getDaemonRegistry().writeSandboxes(SandboxClaimer.this.daemon, SharingManager.getInstance().getRegisteredSandboxes(), progress);
                }
                catch (IDaemonRegistry.DaemonRegistryException e) {
                    return new Status(4, "com.ibm.team.filesystem.client", Messages.SandboxClaimer_WRITE_FAILURE, (Throwable)((Object)e));
                }
                return Status.OK_STATUS;
            }
        };
        this.initialStorageJob.setSystem(true);
    }

    @Override
    public void change(ICopyFileAreaEvent[] events) {
        ICopyFileAreaEvent[] iCopyFileAreaEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            ICopyFileAreaEvent event = iCopyFileAreaEventArray[n2];
            switch (event.getReason()) {
                case 9: 
                case 10: {
                    try {
                        this.daemon.getDaemonRegistry().writeSandboxes(this.daemon, SharingManager.getInstance().getRegisteredSandboxes(), null);
                    }
                    catch (IDaemonRegistry.DaemonRegistryException e) {
                        log.error((Object)Messages.SandboxClaimer_WRITE_FAILURE, (Throwable)((Object)e));
                    }
                    return;
                }
            }
            ++n2;
        }
    }

    public void storeKnownSandboxes() {
        this.initialStorageJob.schedule();
    }
}

