/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.rest.parameters;

import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.List;

public final class ParmsWorkspaceAcceptDetailed
implements IParameterWrapper {
    public ParmsWorkspace workspace;
    public ParmsWorkspace sourceWorkspace;
    public String[] baselineItemIds;
    public String[] changeSetItemIds;
    public String[] componentItemIds;
    public boolean hierarchicalAccept;
    public boolean sourceWorkspaceExplicit;

    public void validate(String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(this.workspace, requestName, parameterName, "workspace");
        this.workspace.validate(requestName, parameterName, "workspace");
        ParmValidation.requiredValue(this.sourceWorkspace, requestName, parameterName, "sourceWorkspace");
        this.sourceWorkspace.validate(requestName, parameterName, "sourceWorkspace");
        boolean changeSetsSupplied = ParmsWorkspaceAcceptDetailed.validateItemIds(this.changeSetItemIds, requestName, parameterName, "changeSetItemIds");
        boolean baselinesSupplied = ParmsWorkspaceAcceptDetailed.validateItemIds(this.baselineItemIds, requestName, parameterName, "baselineItemIds");
        boolean componentsSupplied = ParmsWorkspaceAcceptDetailed.validateItemIds(this.componentItemIds, requestName, parameterName, "componentItemIds");
        if (!(changeSetsSupplied || baselinesSupplied || componentsSupplied)) {
            throw new IllegalArgumentException("Atleast 1 change set, baseline or component must be supplied");
        }
    }

    private static boolean validateItemIds(String[] itemIds, String request, Object ... field) {
        if (itemIds == null || itemIds.length == 0) {
            return false;
        }
        int i = 0;
        while (i < itemIds.length) {
            ParmValidation.requiredValue(itemIds[i], request, field, i);
            ++i;
        }
        return true;
    }

    public List<IBaselineHandle> getBaselineHandles() {
        return CommonUtil.createHandles(IBaseline.ITEM_TYPE, this.sourceWorkspace.repositoryUrl, this.baselineItemIds);
    }

    public List<IChangeSetHandle> getChangeSetHandles() {
        return CommonUtil.createHandles(IChangeSet.ITEM_TYPE, this.sourceWorkspace.repositoryUrl, this.changeSetItemIds);
    }

    public List<IComponentHandle> getComponentHandles() {
        return CommonUtil.createHandles(IComponent.ITEM_TYPE, this.sourceWorkspace.repositoryUrl, this.componentItemIds);
    }
}

