/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.ILineTokenizer;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.Messages;
import com.ibm.team.fulltext.common.internal.analysis.QuoteAnalyzer;
import com.ibm.team.fulltext.common.internal.analysis.SplitLinesTokenizer;
import com.ibm.team.fulltext.common.internal.analysis.SplitTokenFilter;
import com.ibm.team.fulltext.common.internal.analysis.TokenizerPool;
import com.ibm.team.fulltext.common.internal.analysis.WordSpliter;
import com.ibm.team.fulltext.common.internal.index.IIndexingLanguage;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public final class DelegatingAnalyzer
extends Analyzer
implements ExtensionRegistryReaderListener<Object> {
    public static final String CONTENT_WILDCARD_AWARE = "com.ibm.team.fulltext.service.internal.analysis.DelegatingAnalyzer.ContentWildcardAware";
    private static final String TOKENIZER_EXTENSION_POINT = "tokenizer";
    private static final String TOKENIZER_PATTERN = "pattern";
    private static final String PATTERN_VALUE = "value";
    private final Map<String, IConfigurationElement> fTokenizers = new ConcurrentHashMap<String, IConfigurationElement>();
    private final Map<String, TokenizerPool> fResolvedTokenizersCache = new ConcurrentHashMap<String, TokenizerPool>();
    private final Map<String, Pattern> fPatternCache = new ConcurrentHashMap<String, Pattern>();
    private final Log fLog;
    private IIndexingLanguage indexingLanguage;
    private Analyzer cjkAnalyzer = null;
    private ThreadLocal<WordSpliter.Language> overridenLanguage = new ThreadLocal();
    private boolean isQueryAnalyser = false;
    private WordSpliter.Stemmer useLanguageStemmer = WordSpliter.Stemmer.LEGACY;

    public DelegatingAnalyzer() {
        this(false);
    }

    public DelegatingAnalyzer(boolean isQueryAnalyser) {
        this.isQueryAnalyser = isQueryAnalyser;
        this.fLog = LogFactory.getLog((String)"com.ibm.team.fulltext.common");
        this.indexingLanguage = new IIndexingLanguage(){

            @Override
            public String getLanguage() {
                return Locale.getDefault().getLanguage();
            }
        };
        ExtensionRegistryReader<Object> extensionReader = new ExtensionRegistryReader<Object>("com.ibm.team.fulltext.common", TOKENIZER_EXTENSION_POINT){};
        extensionReader.addListener((ExtensionRegistryReaderListener)this);
        extensionReader.start();
    }

    public void handleExtensionAdded(IConfigurationElement element, Object descriptor) throws Exception {
        IConfigurationElement[] patterns;
        IConfigurationElement[] iConfigurationElementArray = patterns = element.getChildren(TOKENIZER_PATTERN);
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pattern = iConfigurationElementArray[n2];
            String patternValue = pattern.getAttribute(PATTERN_VALUE);
            this.fTokenizers.put(patternValue, element);
            this.fPatternCache.put(patternValue, Pattern.compile(patternValue));
            ++n2;
        }
    }

    public void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
        IConfigurationElement[] patterns;
        IConfigurationElement[] iConfigurationElementArray = patterns = element.getChildren(TOKENIZER_PATTERN);
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement pattern = iConfigurationElementArray[n2];
            String patternValue = pattern.getAttribute(PATTERN_VALUE);
            this.fTokenizers.remove(patternValue);
            this.fPatternCache.remove(patternValue);
            ++n2;
        }
    }

    public void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    public void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptor) throws Exception {
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if ("_name".equals(fieldName)) {
            return this.createStandardStreamTokenizer(reader, false);
        }
        if ("_tags".equals(fieldName)) {
            return this.tokenizeTags(reader);
        }
        if ("_content".equals(fieldName)) {
            return this.createStandardStreamTokenizer(reader, false);
        }
        if (CONTENT_WILDCARD_AWARE.equals(fieldName)) {
            return this.createStandardStreamTokenizer(reader, true);
        }
        if ("_meta".equals(fieldName)) {
            return this.tokenizeMeta(reader);
        }
        throw new UnsupportedOperationException(NLS.bind((String)Messages.getString("DelegatingAnalyzer.ERROR_UNSUPPORTED_FIELD"), (Object)fieldName, (Object[])new Object[0]));
    }

    private TokenStream tokenizeTags(Reader reader) {
        SplitLinesTokenizer lineTokenizer = new SplitLinesTokenizer(reader);
        return WordSpliter.newWordSpliter((TokenStream)lineTokenizer, this.getOptions(false));
    }

    private TokenStream tokenizeMeta(Reader reader) {
        return new QuoteAnalyzer(this.getOptions(true)).tokenStream("_meta", reader);
    }

    private TokenStream createStandardStreamTokenizer(Reader reader, boolean wildcardAware) {
        SplitLinesTokenizer lineTokenizer = new SplitLinesTokenizer(reader);
        final Set<Map.Entry<String, Pattern>> patternEntries = this.fPatternCache.entrySet();
        SplitTokenFilter delegatingPatternTokenizer = new SplitTokenFilter((TokenStream)lineTokenizer){

            @Override
            protected void splitToken(ArtifactAttribute lineToken) {
                String lineStr = lineToken.term();
                boolean hasMatchingTokenizer = false;
                for (Map.Entry patternEntry : patternEntries) {
                    try {
                        ILineTokenizer tokenizer;
                        String patternValue = (String)patternEntry.getKey();
                        Pattern pattern = (Pattern)patternEntry.getValue();
                        boolean isMatching = false;
                        try {
                            isMatching = pattern.matcher(lineStr).find();
                        }
                        catch (StackOverflowError stackOverflowError) {
                            isMatching = true;
                        }
                        if (!isMatching) continue;
                        TokenizerPool tokenizerPool = (TokenizerPool)DelegatingAnalyzer.this.fResolvedTokenizersCache.get(patternValue);
                        if (tokenizerPool == null) {
                            IConfigurationElement configElement = (IConfigurationElement)DelegatingAnalyzer.this.fTokenizers.get(patternValue);
                            tokenizerPool = new TokenizerPool(configElement);
                            DelegatingAnalyzer.this.fResolvedTokenizersCache.put(patternValue, tokenizerPool);
                        }
                        if ((tokenizer = tokenizerPool.getTokenizer()) == null) continue;
                        try {
                            tokenizer.tokenize(lineToken.toToken());
                            ArtifactToken t = null;
                            while ((t = tokenizer.next()) != null) {
                                this.addToQueue((TermAttribute)t);
                            }
                            hasMatchingTokenizer = true;
                        }
                        finally {
                            tokenizerPool.returnTokenizer(tokenizer);
                        }
                    }
                    catch (CoreException e) {
                        DelegatingAnalyzer.this.fLog.error((Object)Messages.getString("DelegatingAnalyzer.ERROR_LOADING_TOKENIZER"), (Throwable)e);
                    }
                    catch (IOException e) {
                        DelegatingAnalyzer.this.fLog.error((Object)Messages.getString("DelegatingAnalyzer.ERROR_READING_TEXT_FROM_TOKENIZER"), (Throwable)e);
                    }
                }
                if (!hasMatchingTokenizer) {
                    this.addToQueue(lineToken);
                }
            }
        };
        WordSpliter.Options options = this.getOptions(true);
        WordSpliter.Language overriden = this.overridenLanguage.get();
        if (overriden != null) {
            options.setLanguage(overriden);
        }
        options.setWildcardAware(wildcardAware);
        options.setUseCamelCase(true);
        options.setExpandCamelCaseTokens(true);
        options.setIsQueryAnalyser(this.isQueryAnalyser);
        TokenStream wordFilter = WordSpliter.newWordSpliter((TokenStream)delegatingPatternTokenizer, options);
        return wordFilter;
    }

    public void setIndexingLanguage(IIndexingLanguage language) {
        this.indexingLanguage = language;
    }

    public void setOverridenLanguage(String language) {
        this.overridenLanguage.set(language == null ? null : WordSpliter.languageFrom(language));
    }

    public WordSpliter.Options getOptions(boolean stemming) {
        WordSpliter.Options options = new WordSpliter.Options();
        options.setLanguage(this.indexingLanguage.getLanguage());
        options.setCJKAnalyzer(this.cjkAnalyzer);
        if (stemming) {
            options.setUseLanguageStemmer(this.useLanguageStemmer);
        }
        return options;
    }

    public Analyzer getCJKAnalyzer() {
        return this.cjkAnalyzer;
    }

    public void setCJKAnalyzer(Analyzer cjkAnalyzer) {
        this.cjkAnalyzer = cjkAnalyzer;
    }

    public void setUseLanguageStemmer(WordSpliter.Stemmer useLanguageStemmer) {
        this.useLanguageStemmer = useLanguageStemmer;
    }
}

