/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.index;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;

public class RefCountIndexSearcher
extends IndexSearcher {
    private int refCount = 0;
    private boolean needClose = false;

    public RefCountIndexSearcher(Directory path, boolean readOnly) throws CorruptIndexException, IOException {
        super(path, readOnly);
    }

    public synchronized void close() throws IOException {
        if (this.refCount == 0) {
            super.close();
        } else {
            this.needClose = true;
        }
    }

    private synchronized void searchStopped() {
        if (--this.refCount == 0 && this.needClose) {
            try {
                super.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private synchronized void searchStarted() {
        ++this.refCount;
    }

    public int docFreq(Term term) throws IOException {
        try {
            this.searchStarted();
            int n = super.docFreq(term);
            return n;
        }
        finally {
            this.searchStopped();
        }
    }

    public Document doc(int docID) throws CorruptIndexException, IOException {
        try {
            this.searchStarted();
            Document document = super.doc(docID);
            return document;
        }
        finally {
            this.searchStopped();
        }
    }

    public Document doc(int docID, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        try {
            this.searchStarted();
            Document document = super.doc(docID, fieldSelector);
            return document;
        }
        finally {
            this.searchStopped();
        }
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, int n) throws IOException {
        try {
            this.searchStarted();
            TopDocs topDocs = super.searchAfter(after, query, n);
            return topDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public TopDocs searchAfter(ScoreDoc after, Query query, Filter filter, int n) throws IOException {
        try {
            this.searchStarted();
            TopDocs topDocs = super.searchAfter(after, query, filter, n);
            return topDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public TopDocs search(Query query, int n) throws IOException {
        try {
            this.searchStarted();
            TopDocs topDocs = super.search(query, n);
            return topDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        try {
            this.searchStarted();
            TopDocs topDocs = super.search(query, filter, n);
            return topDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public void search(Query query, Filter filter, Collector results) throws IOException {
        try {
            this.searchStarted();
            super.search(query, filter, results);
        }
        finally {
            this.searchStopped();
        }
    }

    public void search(Query query, Collector results) throws IOException {
        try {
            this.searchStarted();
            super.search(query, results);
        }
        finally {
            this.searchStopped();
        }
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        try {
            this.searchStarted();
            TopFieldDocs topFieldDocs = super.search(query, filter, n, sort);
            return topFieldDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public TopFieldDocs search(Query query, int n, Sort sort) throws IOException {
        try {
            this.searchStarted();
            TopFieldDocs topFieldDocs = super.search(query, n, sort);
            return topFieldDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        try {
            this.searchStarted();
            TopDocs topDocs = super.search(weight, filter, nDocs);
            return topDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        try {
            this.searchStarted();
            TopFieldDocs topFieldDocs = super.search(weight, filter, nDocs, sort);
            return topFieldDocs;
        }
        finally {
            this.searchStopped();
        }
    }

    public void search(Weight weight, Filter filter, Collector collector) throws IOException {
        try {
            this.searchStarted();
            super.search(weight, filter, collector);
        }
        finally {
            this.searchStopped();
        }
    }

    public int[] docFreqs(Term[] terms) throws IOException {
        try {
            this.searchStarted();
            int[] nArray = super.docFreqs(terms);
            return nArray;
        }
        finally {
            this.searchStopped();
        }
    }

    public Explanation explain(Query query, int doc) throws IOException {
        try {
            this.searchStarted();
            Explanation explanation = super.explain(query, doc);
            return explanation;
        }
        finally {
            this.searchStopped();
        }
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        try {
            this.searchStarted();
            Explanation explanation = super.explain(weight, doc);
            return explanation;
        }
        finally {
            this.searchStopped();
        }
    }
}

