/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IHelper;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtual;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.model.HelperType;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.impl.VirtualImpl;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.IStackAdjuster;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.AbstractDeserializer;
import com.ibm.team.repository.common.serialize.internal.IJSONDeserializationParticipant;
import com.ibm.team.repository.common.serialize.internal.nls.Messages;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.util.NLS;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JSONDeserializer
extends AbstractDeserializer {
    private static final String KEY_URI = "uri";
    private static final String KEY_ETAG = "etag";
    private IJSONDeserializationParticipant participant = new IJSONDeserializationParticipant(){

        @Override
        public Throwable deserializeErrorObj(JSONDeserializer d, JSONObject json, Throwable t) {
            return t;
        }
    };

    public JSONDeserializer(HttpUtil.MediaType type, IURISerializer uriSerializer) {
        super(type, uriSerializer);
    }

    public void setParticipant(IJSONDeserializationParticipant participant) {
        if (participant == null) {
            throw new IllegalArgumentException("Participant may not be null.");
        }
        this.participant = participant;
    }

    @Override
    public IItem deserializeNewItem(IItemType itemType, Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        JSONObject jsonObject = JSONDeserializer.getObject(reader);
        Item item = (Item)itemType.createItem();
        item.initNew();
        EObject itemObj = (EObject)item.getAdapter(EObject.class);
        this.deserializeObject(itemObj, jsonObject);
        return item;
    }

    @Override
    public IItem deserializeWorkingCopy(IItem item, Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (!item.isWorkingCopy()) {
            throw new IllegalArgumentException("referenced item must be a working copy");
        }
        JSONObject jsonObject = JSONDeserializer.getObject(reader);
        EObject itemObj = (EObject)item.getAdapter(EObject.class);
        this.deserializeObject(itemObj, jsonObject);
        return item;
    }

    @Override
    public IItem deserializeItem(Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        JSONObject jsonObject = JSONDeserializer.getObject(reader);
        IItem item = this.toItem(jsonObject);
        return item;
    }

    @Override
    public List<IItem> deserializeItems(Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        JSONArray jsonArray = null;
        try {
            jsonArray = JSONArray.parse((Reader)reader);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorArrayParse"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new SerializeException(msg, e);
        }
        ArrayList<IItem> items = new ArrayList<IItem>(jsonArray.size());
        for (Object obj : jsonArray) {
            if (!(obj instanceof JSONObject)) {
                String msg = Messages.getServerString("JSONDeserializer.ErrorInvalidArrayMembers");
                throw new SerializeException(msg);
            }
            JSONObject jsonObj = (JSONObject)obj;
            items.add(this.toItem(jsonObj));
        }
        return items;
    }

    @Override
    public IVirtual deserializeVirtual(Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        return this.deserializeVirtual(null, reader);
    }

    @Override
    public IVirtual deserializeVirtual(IVirtualType type, Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        JSONObject jsonObject = JSONDeserializer.getObject(reader);
        IVirtual item = this.toVirtual(type, jsonObject);
        return item;
    }

    @Override
    public List<IVirtual> deserializeVirtuals(Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        return this.deserializeVirtuals(null, reader);
    }

    @Override
    public List<IVirtual> deserializeVirtuals(IVirtualType type, Reader reader) throws SerializeException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        JSONArray jsonArray = null;
        try {
            jsonArray = JSONArray.parse((Reader)reader);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorParsingArray"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new SerializeException(msg, e);
        }
        ArrayList<IVirtual> items = new ArrayList<IVirtual>(jsonArray.size());
        for (Object obj : jsonArray) {
            if (!(obj instanceof JSONObject)) {
                String msg = Messages.getServerString("JSONDeserializer.ErrorInvalidArrayMembers");
                throw new SerializeException(msg);
            }
            JSONObject jsonObj = (JSONObject)obj;
            items.add(this.toVirtual(type, jsonObj));
        }
        return items;
    }

    @Override
    public Object deserialize(EObject object, Reader reader) throws SerializeException {
        JSONObject jsonObject = JSONDeserializer.getObject(reader);
        this.deserializeObject(object, jsonObject);
        return object;
    }

    private static JSONObject getObject(Reader reader) throws SerializeException {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parse((Reader)reader);
        }
        catch (Exception e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorObjectParsing"), (Object)e.getMessage(), (Object[])new Object[0]);
            throw new SerializeException(msg, e);
        }
        return jsonObject;
    }

    private IItem toItem(JSONObject jsonObject) throws SerializeException {
        Item item = this.getItem(jsonObject);
        EObject itemObj = (EObject)item.getAdapter(EObject.class);
        this.deserializeObject(itemObj, jsonObject);
        item.makeImmutable();
        item.protect();
        return item;
    }

    private IVirtual toVirtual(IVirtualType type, JSONObject jsonObject) throws SerializeException {
        if (type == null) {
            type = this.getVirtualType(jsonObject);
        }
        if (type == null) {
            String msg = Messages.getServerString("JSONDeserializer.ErrorMissingType");
            throw new SerializeException(msg);
        }
        IVirtual virtual = type.createVirtual();
        EObject virtualObj = (EObject)virtual.getAdapter(EObject.class);
        this.deserializeObject(virtualObj, jsonObject);
        VirtualImpl impl = (VirtualImpl)virtual.getAdapter(VirtualImpl.class);
        impl.setLocation((String)jsonObject.get((Object)KEY_URI));
        UUID etag = JSONDeserializer.getETag(jsonObject);
        if (etag != null) {
            impl.setEtag(etag.getUuidValue());
        }
        return virtual;
    }

    private Item getItem(JSONObject jsonObject) throws SerializeException {
        IItemHandle handle = this.getItemHandle(jsonObject);
        if (handle == null) {
            String msg = Messages.getServerString("JSONDeserializer.ErrorMissingHandle");
            throw new SerializeException(msg);
        }
        String namespaceURI = handle.getItemType().getNamespaceURI();
        String typeName = handle.getItemType().getName();
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(namespaceURI);
        EClass eClass = (EClass)ePackage.getEClassifier(typeName);
        EObject eObject = ePackage.getEFactoryInstance().create(eClass);
        Item item = (Item)eObject;
        item.setItemId(handle.getItemId());
        if (handle.getStateId() != null) {
            item.setStateId(handle.getStateId());
        } else {
            item.setStateId(JSONDeserializer.getETag(jsonObject));
        }
        return item;
    }

    private IItemHandle getItemHandle(JSONObject jsonObject) throws SerializeException {
        String locString = (String)jsonObject.get((Object)KEY_URI);
        if (locString == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(locString);
        }
        catch (URISyntaxException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.InvalidLocationString"), (Object)locString, (Object[])new Object[]{e.getMessage()});
            throw new SerializeException(msg, e);
        }
        return this._uriSerializer.getItemHandle(uri);
    }

    private IVirtualType getVirtualType(JSONObject jsonObject) throws SerializeException {
        IType type = this.getType(jsonObject);
        if (type != null && type instanceof IVirtualType) {
            return (IVirtualType)type;
        }
        return null;
    }

    private IType getType(JSONObject jsonObject) throws SerializeException {
        String locString = (String)jsonObject.get((Object)KEY_URI);
        if (locString == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(locString);
        }
        catch (URISyntaxException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.InvalidLocationString"), (Object)locString, (Object[])new Object[]{e.getMessage()});
            throw new SerializeException(msg, e);
        }
        return this._uriSerializer.getType(uri);
    }

    private IContent toContent(JSONObject jsonObject) throws SerializeException {
        String locString = (String)jsonObject.get((Object)KEY_URI);
        if (locString == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(locString);
        }
        catch (URISyntaxException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.InvalidLocationString"), (Object)locString, (Object[])new Object[]{e.getMessage()});
            throw new SerializeException(msg, e);
        }
        Location loc = null;
        try {
            loc = Location.location((URI)uri);
        }
        catch (TeamRepositoryException e) {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.InvalidLocationString"), (Object)uri, (Object[])new Object[]{e.getMessage()});
            throw new SerializeException(msg, e);
        }
        if (loc.isContent()) {
            return loc.getContent();
        }
        return null;
    }

    private static UUID getETag(JSONObject jsonObject) throws SerializeException {
        if (jsonObject == null) {
            throw new IllegalArgumentException("jsonObject must not be null");
        }
        UUID etagUuid = null;
        String etag = (String)jsonObject.get((Object)KEY_ETAG);
        if (etag != null) {
            try {
                etagUuid = UUID.valueOf((String)etag);
            }
            catch (RuntimeException e2) {
                String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.InvalidMemberSyntax"), (Object)KEY_ETAG, (Object[])new Object[]{e2.getMessage()});
                throw new SerializeException(msg, e2);
            }
        }
        return etagUuid;
    }

    private void deserializeObject(EObject eObject, JSONObject jsonObj) throws SerializeException {
        EClass eClass = eObject.eClass();
        EList sfs = eClass.getEAllStructuralFeatures();
        for (EStructuralFeature sf : sfs) {
            if (!jsonObj.containsKey((Object)sf.getName()) || ItemUtil.isImmutableFeature((EStructuralFeature)sf)) continue;
            Object jsonValue = jsonObj.get((Object)sf.getName());
            Object itemValue = this.deserializeFeature(sf, jsonValue);
            eObject.eSet(sf, itemValue);
        }
    }

    private EObject deserializeObject(JSONObject object) throws SerializeException {
        EObject eObject;
        if (object == null) {
            return null;
        }
        String ePackageName = (String)object.get((Object)"-hint-epackage-1");
        String eClassName = (String)object.get((Object)"-hint-eclass-1");
        if (ePackageName == null || eClassName == null) {
            throw new SerializeException();
        }
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ePackageName);
        if (ePackage == null) {
            throw new SerializeException(ePackageName);
        }
        EClass eClass = (EClass)ePackage.getEClassifier(eClassName);
        if (eClass == null) {
            throw new SerializeException(eClassName);
        }
        try {
            eObject = ePackage.getEFactoryInstance().create(eClass);
        }
        catch (IllegalArgumentException e) {
            throw new SerializeException(eClassName, e);
        }
        this.deserializeObject(eObject, object);
        return eObject;
    }

    private Object deserializeFeature(EStructuralFeature sf, Object jsonValue) throws SerializeException {
        if (sf == null) {
            throw new IllegalArgumentException("sf must not be null");
        }
        if (jsonValue == null) {
            return null;
        }
        String featureName = sf.getName();
        EClassifier featureType = sf.getEType();
        Object itemValue = null;
        if (sf instanceof EReference) {
            if (sf.isMany()) {
                if (!(jsonValue instanceof JSONArray)) {
                    String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorExpectedArray"), (Object)featureName, (Object[])new Object[0]);
                    throw new SerializeException(msg);
                }
                itemValue = this.deserializeReferenceList((JSONArray)jsonValue, (EClass)featureType);
            } else {
                if (!(jsonValue instanceof JSONObject)) {
                    String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorExpectedArray"), (Object)featureName, (Object[])new Object[0]);
                    throw new SerializeException(msg);
                }
                itemValue = this.deserializeReference((JSONObject)jsonValue, (EClass)featureType);
            }
        } else if (sf instanceof EAttribute) {
            if (jsonValue instanceof JSONObject) {
                String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.UnexpectedObjectValue"), (Object)featureName, (Object[])new Object[0]);
                throw new SerializeException(msg);
            }
            if (sf.isMany()) {
                if (!(jsonValue instanceof JSONArray)) {
                    String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.ErrorExpectedArray"), (Object)featureName, (Object[])new Object[0]);
                    throw new SerializeException(msg);
                }
                itemValue = this.deserializeAttributeList((JSONArray)jsonValue, featureType);
            } else {
                itemValue = this.deserializeAttribute(jsonValue, featureType);
            }
        } else {
            String msg = NLS.bind((String)Messages.getServerString("JSONDeserializer.UnrecognizedFeature"), (Object)featureName, (Object[])new Object[0]);
            throw new SerializeException(msg);
        }
        return itemValue;
    }

    private Object deserializeAttribute(Object object, EClassifier featureType) throws SerializeException {
        Class expectedType = featureType.getInstanceClass();
        if (object instanceof Boolean) {
            if (Boolean.class == expectedType || Boolean.TYPE == expectedType) {
                return object;
            }
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer.UnsupportedBoolean"), (Object)object, (Object[])new Object[0]));
        }
        if (object instanceof String) {
            if (String.class == expectedType) {
                return object;
            }
            if (Object.class == expectedType) {
                return object;
            }
            if (featureType instanceof EEnum) {
                EEnum eEnum = (EEnum)featureType;
                return eEnum.getEEnumLiteral((String)object).getInstance();
            }
            IPrimitiveHandler primHandler = IPrimitiveRegistry.INSTANCE.getHandler(expectedType);
            if (primHandler != null) {
                return primHandler.stringToObject((String)object);
            }
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer.UnsupportedPrimitive"), (Object)object, (Object[])new Object[0]));
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (Byte.class == expectedType || Byte.TYPE == expectedType) {
                return number.byteValue();
            }
            if (Short.class == expectedType || Short.TYPE == expectedType) {
                return number.shortValue();
            }
            if (Character.class == expectedType || Character.TYPE == expectedType) {
                return Character.valueOf((char)number.shortValue());
            }
            if (Integer.class == expectedType || Integer.TYPE == expectedType) {
                return number.intValue();
            }
            if (Long.class == expectedType || Long.TYPE == expectedType) {
                return number.longValue();
            }
            if (Float.class == expectedType || Float.TYPE == expectedType) {
                return new Float(number.floatValue());
            }
            if (Double.class == expectedType || Double.TYPE == expectedType) {
                return new Double(number.doubleValue());
            }
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer.UnsupportedNumber"), (Object)object, (Object[])new Object[0]));
        }
        throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer.UnexpectedPropertyValue"), (Object)object, (Object[])new Object[0]));
    }

    private List deserializeAttributeList(JSONArray attrList, EClassifier featureType) throws SerializeException {
        if (attrList == null) {
            throw new IllegalArgumentException("attrs must not be null");
        }
        if (featureType == null) {
            throw new IllegalArgumentException("featureType must not be null");
        }
        ArrayList<Object> retVal = new ArrayList<Object>(attrList.size());
        for (Object attr : attrList) {
            if (attr instanceof JSONObject || attr instanceof JSONArray) {
                throw new SerializeException(Messages.getServerString("JSONDeserializer.InvalidAttributeList"));
            }
            retVal.add(this.deserializeAttribute(attr, featureType));
        }
        return retVal;
    }

    private List deserializeReferenceList(JSONArray refList, EClass eClass) throws SerializeException {
        if (refList == null) {
            throw new IllegalArgumentException("refList must not be null");
        }
        if (eClass == null) {
            throw new IllegalArgumentException("eClass must not be null");
        }
        ArrayList<Object> refs = new ArrayList<Object>(refList.size());
        for (Object ref : refList) {
            if (!(ref instanceof JSONObject)) {
                throw new SerializeException(Messages.getServerString("JSONDeserializer.InvalidReferenceList"));
            }
            refs.add(this.deserializeReference((JSONObject)ref, eClass));
        }
        return refs;
    }

    private Object deserializeReference(JSONObject jsonObj, EClass eClass) throws SerializeException {
        if (jsonObj == null) {
            throw new IllegalArgumentException("jsonObj must not be null");
        }
        if (eClass == null) {
            throw new IllegalArgumentException("eClass must not be null");
        }
        IItemHandle handle = this.getItemHandle(jsonObj);
        if (handle != null) {
            return handle;
        }
        IVirtualType virtualType = this.getVirtualType(jsonObj);
        if (virtualType != null) {
            return this.toVirtual(virtualType, jsonObj);
        }
        IContent content = this.toContent(jsonObj);
        if (content != null) {
            return content;
        }
        EObject newObj = null;
        EClass newClass = null;
        if (RepositoryPackage.eINSTANCE.getHelper().isSuperTypeOf(eClass)) {
            HelperType helperType = ItemUtil.helperTypeFor((EClass)eClass);
            IHelper helper = helperType.createHelper();
            newObj = (EObject)helper.getAdapter(EObject.class);
            newClass = (EClass)helper.getAdapter(EClass.class);
        } else if (jsonObj.containsKey((Object)"-hint-eclass-1")) {
            String ePackageName = (String)jsonObj.get((Object)"-hint-epackage-1");
            String eClassName = (String)jsonObj.get((Object)"-hint-eclass-1");
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ePackageName);
            if (ePackage == null) {
                throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorMissingPackage"), (Object)ePackageName, (Object[])new Object[0]));
            }
            EClassifier eClassifier = ePackage.getEClassifier(eClassName);
            if (eClassifier == null) {
                throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorMissingClass"), (Object)eClassName, (Object[])new Object[0]));
            }
            if (!(eClassifier instanceof EClass)) {
                throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONDeserializer_03.ErrorWrongClassType"), (Object)eClassName, (Object[])new Object[0]));
            }
            newClass = (EClass)eClassifier;
            newObj = ePackage.getEFactoryInstance().create(newClass);
        } else {
            newObj = eClass.getEPackage().getEFactoryInstance().create(eClass);
            newClass = eClass;
        }
        EList features = newClass.getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            Object jsonValue;
            if (!jsonObj.containsKey((Object)feature.getName()) || (jsonValue = jsonObj.get((Object)feature.getName())) == null) continue;
            Object itemValue = this.deserializeFeature(feature, jsonValue);
            newObj.eSet(feature, itemValue);
        }
        return newObj;
    }

    @Override
    public Throwable deserializeException(Reader r, ClassLoader loader, IStackAdjuster adj) throws SerializeException {
        return this.deserializeErrorObj(JSONDeserializer.getObject(r), loader, adj);
    }

    protected Throwable deserializeErrorObj(JSONObject jsonObject, ClassLoader loader, IStackAdjuster adj) throws SerializeException {
        StringWriter result = new StringWriter(1000);
        PrintWriter output = new PrintWriter((Writer)result, true);
        String marker = UUID.generate().getUuidValue();
        output.println(marker);
        JSONDeserializer.deserializeErrorObjException(marker, jsonObject, output);
        output.flush();
        result.flush();
        output.close();
        Throwable toReturn = MarshallerUtil.decodeExceptions(result.toString(), loader, adj);
        if (toReturn instanceof TeamRepositoryException) {
            TeamRepositoryException tre = (TeamRepositoryException)toReturn;
            Object allData = jsonObject.get((Object)"errorAllData");
            if (allData != null && allData instanceof Map) {
                JSONObject fromJSON = (JSONObject)allData;
                HashMap<String, EObject> toSet = new HashMap<String, EObject>(fromJSON.size());
                for (Map.Entry entry : fromJSON.entrySet()) {
                    EObject value;
                    try {
                        value = this.deserializeObject((JSONObject)entry.getValue());
                    }
                    catch (SerializeException serializeException) {
                        continue;
                    }
                    toSet.put((String)entry.getKey(), value);
                }
                tre.setSerializedData(toSet);
            }
        }
        return this.participant.deserializeErrorObj(this, jsonObject, toReturn);
    }

    private static void deserializeErrorObjException(String marker, JSONObject obj, PrintWriter out) {
        String className = JSONDeserializer.getString(obj, "errorClass", RuntimeException.class.getName());
        out.println(className);
        String msg = JSONDeserializer.getString(obj, "errorMessage", null);
        if (msg != null) {
            out.print('>');
            out.print(msg);
        }
        out.println(marker);
        JSONArray trace = JSONDeserializer.getArray(obj, "errorTraceMarshall");
        out.println(trace.size());
        for (Object elem : trace) {
            JSONObject frame = elem instanceof JSONObject ? (JSONObject)elem : new JSONObject();
            out.print(JSONDeserializer.getString(frame, "errorTraceClassName", "UnknownClassName"));
            out.print(",");
            out.print(JSONDeserializer.getString(frame, "errorTraceMethodName", "UnknownMethodName"));
            out.print(",");
            out.print(JSONDeserializer.getString(frame, "errorTraceFileName", "UnknownFileName"));
            out.print(",");
            out.print(JSONDeserializer.getInteger(frame, "errorTraceLineNumber", 0L));
            out.println();
        }
        Object child = obj.get((Object)"nestedError");
        if (child != null && child instanceof JSONObject) {
            out.println("cause:");
            JSONDeserializer.deserializeErrorObjException(marker, (JSONObject)child, out);
        }
    }

    private static String getString(JSONObject obj, String key, String defaultValue) {
        Object value = obj.get((Object)key);
        if (value == null) {
            if (obj.containsKey((Object)key)) {
                return null;
            }
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    private static Long getInteger(JSONObject obj, String key, long defaultValue) {
        Object value = obj.get((Object)key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.getLong((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private static JSONArray getArray(JSONObject obj, String key) {
        Object value = obj.get((Object)key);
        if (value instanceof JSONArray) {
            return (JSONArray)value;
        }
        return new JSONArray();
    }
}

