/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.id;

import org.hibernate.Query;

public class QueryParameterData {
    private String flatEntityPropertyName;
    private Object value;

    public QueryParameterData(String flatEntityPropertyName, Object value) {
        this.flatEntityPropertyName = flatEntityPropertyName;
        this.value = value;
    }

    public String getProperty(String prefix) {
        if (prefix != null) {
            return prefix + "." + this.flatEntityPropertyName;
        }
        return this.flatEntityPropertyName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setParameterValue(Query query) {
        query.setParameter(this.flatEntityPropertyName, this.value);
    }

    public String getQueryParameterName() {
        return this.flatEntityPropertyName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryParameterData)) {
            return false;
        }
        QueryParameterData that = (QueryParameterData)o;
        return !(this.flatEntityPropertyName != null ? !this.flatEntityPropertyName.equals(that.flatEntityPropertyName) : that.flatEntityPropertyName != null);
    }

    public int hashCode() {
        return this.flatEntityPropertyName != null ? this.flatEntityPropertyName.hashCode() : 0;
    }
}

