/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.ISerializer2;
import com.ibm.team.repository.common.serialize.IURISerializer;
import com.ibm.team.repository.common.transport.HttpUtil;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractSerializer
implements ISerializer2 {
    protected static final IPrimitiveRegistry PrimitiveReg = IPrimitiveRegistry.INSTANCE;
    private final HttpUtil.MediaType _mType;
    private final boolean _format;
    protected final IURISerializer _uriSerializer;

    AbstractSerializer(HttpUtil.MediaType mType, boolean format, IURISerializer uriSerializer) {
        if (mType == null) {
            throw new IllegalArgumentException("MediaType must not be null");
        }
        if (uriSerializer == null) {
            throw new IllegalArgumentException("URI Serializer must not be null");
        }
        this._mType = mType;
        this._format = format;
        this._uriSerializer = uriSerializer;
    }

    @Override
    public HttpUtil.MediaType getMediaType() {
        return this._mType;
    }

    @Override
    public boolean format() {
        return this._format;
    }

    protected boolean shouldMorphItemToHandle(EObject eObject, Class expectedType) {
        if (eObject == null) {
            return false;
        }
        if (!(eObject instanceof IItem)) {
            return false;
        }
        return !IItem.class.isAssignableFrom(expectedType);
    }

    public EObject morphItemToHandle(EObject item) {
        if (item == null) {
            return null;
        }
        return (EObject)((IItem)item).getItemHandle();
    }
}

