/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.utils.DateUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class PrimitiveRegistry
implements IPrimitiveRegistry {
    private final Map primitives = Collections.synchronizedMap(new WeakHashMap());
    private final Map nsPrimitives = Collections.synchronizedMap(new HashMap());

    public PrimitiveRegistry() {
        this.addInstrinsicHandlers();
    }

    private void addInstrinsicHandlers() {
        this.register(Byte.TYPE, PrimitiveHandlerByte.BYTE_INSTANCE);
        this.register(Byte.class, PrimitiveHandlerByte.BYTE_INSTANCE);
        this.register(Short.TYPE, PrimitiveHandlerShort.SHORT_INSTANCE);
        this.register(Short.class, PrimitiveHandlerShort.SHORT_INSTANCE);
        this.register(Integer.TYPE, PrimitiveHandlerInteger.INTEGER_INSTANCE);
        this.register(Integer.class, PrimitiveHandlerInteger.INTEGER_INSTANCE);
        this.register(Long.TYPE, PrimitiveHandlerLong.LONG_INSTANCE);
        this.register(Long.class, PrimitiveHandlerLong.LONG_INSTANCE);
        this.register(Float.TYPE, PrimitiveHandlerFloat.FLOAT_INSTANCE);
        this.register(Float.class, PrimitiveHandlerFloat.FLOAT_INSTANCE);
        this.register(Double.TYPE, PrimitiveHandlerDouble.DOUBLE_INSTANCE);
        this.register(Double.class, PrimitiveHandlerDouble.DOUBLE_INSTANCE);
        this.register(Boolean.TYPE, PrimitiveHandlerBoolean.BOOLEAN_INSTANCE);
        this.register(Boolean.class, PrimitiveHandlerBoolean.BOOLEAN_INSTANCE);
        this.register(Character.TYPE, PrimitiveHandlerCharacter.CHARACTER_INSTANCE);
        this.register(Character.class, PrimitiveHandlerCharacter.CHARACTER_INSTANCE);
        this.register(Void.TYPE, PrimitiveHandlerVoid.VOID_INSTANCE);
        this.register(String.class, PrimitiveHandlerString.STRING_INSTANCE);
        this.register(Date.class, PrimitiveHandlerDate.DATE_INSTANCE);
        this.register(Timestamp.class, PrimitiveHandlerTimestamp.TIMESTAMP_INSTANCE);
        this.register(UUID.class, PrimitiveHandlerRepoUUID.UUID_INSTANCE);
    }

    @Override
    public IPrimitiveHandler getHandler(Class clazz) {
        return (IPrimitiveHandler)this.primitives.get(clazz);
    }

    @Override
    public IPrimitiveHandler getHandler(String[] xsiType) {
        String nsKey = String.valueOf(xsiType[0]) + ' ' + xsiType[1];
        return (IPrimitiveHandler)this.nsPrimitives.get(nsKey);
    }

    @Override
    public void register(Class clazz, IPrimitiveHandler handler) {
        this.primitives.put(clazz, handler);
        String[] xsiType = handler.getXsiType();
        String nsKey = String.valueOf(xsiType[0]) + ' ' + xsiType[1];
        this.nsPrimitives.put(nsKey, handler);
    }

    @Override
    public boolean isPrimitive(Class clazz) {
        return this.primitives.containsKey(clazz);
    }

    static class PrimitiveHandlerBoolean
    implements IPrimitiveHandler {
        static final IPrimitiveHandler BOOLEAN_INSTANCE = new PrimitiveHandlerBoolean();

        PrimitiveHandlerBoolean() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Boolean)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Boolean.valueOf(string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "boolean"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerByte
    implements IPrimitiveHandler {
        static final IPrimitiveHandler BYTE_INSTANCE = new PrimitiveHandlerByte();

        PrimitiveHandlerByte() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Byte)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Byte.decode(string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "unsignedByte"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerCharacter
    implements IPrimitiveHandler {
        static final IPrimitiveHandler CHARACTER_INSTANCE = new PrimitiveHandlerCharacter();

        PrimitiveHandlerCharacter() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Character)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Character.valueOf(string.charAt(0));
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerDate
    implements IPrimitiveHandler {
        static final IPrimitiveHandler DATE_INSTANCE = new PrimitiveHandlerDate();

        PrimitiveHandlerDate() {
        }

        @Override
        public String objectToString(Object object) {
            return DateUtils.formatTimeRFC3339((Date)((Date)object));
        }

        @Override
        public Object stringToObject(String string) throws SerializeException {
            try {
                Timestamp time = DateUtils.parseTimeRFC3339((String)string);
                return new Date(time.getTime());
            }
            catch (ParseException e) {
                throw SerializeException.from(e);
            }
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "dateTime"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerDouble
    implements IPrimitiveHandler {
        static final IPrimitiveHandler DOUBLE_INSTANCE = new PrimitiveHandlerDouble();

        PrimitiveHandlerDouble() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Double)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Double.valueOf(string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "double"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerFloat
    implements IPrimitiveHandler {
        static final IPrimitiveHandler FLOAT_INSTANCE = new PrimitiveHandlerFloat();

        PrimitiveHandlerFloat() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Float)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Float.valueOf(string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "float"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerInteger
    implements IPrimitiveHandler {
        static final IPrimitiveHandler INTEGER_INSTANCE = new PrimitiveHandlerInteger();

        PrimitiveHandlerInteger() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Integer)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Integer.decode(string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "int"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerLong
    implements IPrimitiveHandler {
        static final IPrimitiveHandler LONG_INSTANCE = new PrimitiveHandlerLong();

        PrimitiveHandlerLong() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Long)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Long.decode(string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "long"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerRepoUUID
    implements IPrimitiveHandler {
        static final IPrimitiveHandler UUID_INSTANCE = new PrimitiveHandlerRepoUUID();

        PrimitiveHandlerRepoUUID() {
        }

        @Override
        public String objectToString(Object object) {
            return ((UUID)object).getUuidValue();
        }

        @Override
        public Object stringToObject(String string) {
            return UUID.valueOf((String)string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerShort
    implements IPrimitiveHandler {
        static final IPrimitiveHandler SHORT_INSTANCE = new PrimitiveHandlerShort();

        PrimitiveHandlerShort() {
        }

        @Override
        public String objectToString(Object object) {
            return ((Short)object).toString();
        }

        @Override
        public Object stringToObject(String string) {
            return Short.decode(string);
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "short"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerString
    implements IPrimitiveHandler {
        static final IPrimitiveHandler STRING_INSTANCE = new PrimitiveHandlerString();

        PrimitiveHandlerString() {
        }

        @Override
        public String objectToString(Object object) {
            return (String)object;
        }

        @Override
        public Object stringToObject(String string) {
            return string;
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        @Override
        public boolean isEmptyValid() {
            return true;
        }
    }

    static class PrimitiveHandlerTimestamp
    implements IPrimitiveHandler {
        static final IPrimitiveHandler TIMESTAMP_INSTANCE = new PrimitiveHandlerTimestamp();

        PrimitiveHandlerTimestamp() {
        }

        @Override
        public String objectToString(Object object) {
            return DateUtils.formatTimeRFC3339((Date)((Date)object));
        }

        @Override
        public Object stringToObject(String string) throws SerializeException {
            try {
                return DateUtils.parseTimeRFC3339((String)string);
            }
            catch (ParseException e) {
                throw SerializeException.from(e);
            }
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "dateTime"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }

    static class PrimitiveHandlerVoid
    implements IPrimitiveHandler {
        static final IPrimitiveHandler VOID_INSTANCE = new PrimitiveHandlerVoid();

        PrimitiveHandlerVoid() {
        }

        @Override
        public String objectToString(Object object) {
            return null;
        }

        @Override
        public Object stringToObject(String string) {
            return null;
        }

        @Override
        public String[] getXsiType() {
            return new String[]{"http://www.w3.org/2001/XMLSchema", "string"};
        }

        @Override
        public boolean isEmptyValid() {
            return false;
        }
    }
}

