/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.login;

import com.ibm.team.repository.client.SavedPasswordNotObtainedException;
import com.ibm.team.repository.client.internal.login.KerberosLoginUtils;
import com.ibm.team.repository.client.login.AbstractLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ITeamServer;
import java.util.Properties;

public class KerberosLoginInfo
extends AbstractLoginInfo {
    @Override
    public void successfulLogin() {
        KerberosLoginUtils.successfulLogin();
    }

    @Override
    public boolean hasPassword() {
        return false;
    }

    @Override
    public void handleCredentials(ITeamServer teamServer) throws TeamRepositoryException, SavedPasswordNotObtainedException {
        if (KerberosLoginInfo.isKerberosPossible()) {
            teamServer.setCredentials();
        }
    }

    @Override
    public Properties getLoginProperties() {
        Properties properties = super.getLoginProperties();
        KerberosLoginUtils.transferInternalPropertiesToProperties(properties);
        return properties;
    }

    @Override
    public void setLoginProperties(Properties properties) {
        if (!KerberosLoginInfo.isKerberosPossible()) {
            return;
        }
        KerberosLoginUtils.transferInternalPropertiesFromProperties(properties);
    }

    @Override
    public void initialize() throws TeamRepositoryException {
        super.initialize();
        this.setLoginProperties(null);
    }

    @Override
    public boolean validateLoggedInUser(String name, String userid) {
        return true;
    }
}

