/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.internal.linking;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.ibm.team.calm.foundation.common.CustomNamespaceContext;
import com.ibm.team.calm.foundation.common.internal.RDFUtils;
import com.ibm.team.calm.foundation.common.internal.linking.CoreVersion2ResourceUpdater;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.oslc.OSLCCoreIdentifiers;
import com.ibm.team.calm.foundation.common.oslc.RDFIdentifiers;
import com.ibm.team.repository.common.transport.UriUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PartialCoreVersion2ResourceUpdater
extends CoreVersion2ResourceUpdater {
    @Override
    protected void prepareResource(Resource source) {
        Property rdfTypeProperty = RDFUtils.toJena(RDFIdentifiers.TYPE, source.getModel());
        List rdfTypes = source.listProperties(rdfTypeProperty).toList();
        source.removeProperties();
        if (rdfTypes != null) {
            for (Statement rdfType : rdfTypes) {
                source.addProperty(rdfTypeProperty, rdfType.getObject());
            }
        }
    }

    @Override
    protected String writeToString(Model document) {
        StringWriter result = new StringWriter();
        RDFWriter writer = document.getWriter("RDF/XML-ABBREV");
        writer.setProperty("allowBadURIs", (Object)Boolean.TRUE);
        writer.write(document, (Writer)result, null);
        return result.getBuffer().toString();
    }

    @Override
    protected String evaluateWriteParameter(Set<OSLCResourceDescription.ResourcePropertyDescription> properties) {
        Resource source = this.getDocument().getResource(this.getResourceURL());
        return this.createParameters(source, properties);
    }

    private String createParameters(Resource source, Set<OSLCResourceDescription.ResourcePropertyDescription> resourceProperties) {
        CustomNamespaceContext context = this.getNamespaceContext();
        StringBuilder properties = new StringBuilder();
        StringBuilder prefixBuilder = new StringBuilder();
        HashSet<String> namespacesDeclared = new HashSet<String>();
        for (OSLCResourceDescription.ResourcePropertyDescription resourceProperty : resourceProperties) {
            if (properties.length() > 0) {
                properties.append(',');
            }
            properties.append(context.qualify(resourceProperty.getProperty()));
            String namespace = resourceProperty.getProperty().getNamespaceURI();
            if (!namespacesDeclared.add(namespace)) continue;
            if (prefixBuilder.length() > 0) {
                prefixBuilder.append(',');
            }
            prefixBuilder.append(context.getPrefix(namespace));
            prefixBuilder.append("=<");
            prefixBuilder.append(namespace);
            prefixBuilder.append('>');
        }
        StringBuilder parameterBuilder = new StringBuilder();
        parameterBuilder.append(OSLCCoreIdentifiers.PARAM_PROPERTIES);
        parameterBuilder.append('=');
        parameterBuilder.append(UriUtil.encode((String)properties.toString()));
        parameterBuilder.append('&');
        parameterBuilder.append(OSLCCoreIdentifiers.PARAM_PREFIX);
        parameterBuilder.append('=');
        parameterBuilder.append(UriUtil.encode((String)prefixBuilder.toString()));
        return parameterBuilder.toString();
    }
}

