/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.internal;

import com.ibm.team.interop.client.admin.IItemConnectorAdminClient;
import com.ibm.team.interop.client.internal.InteropManager;
import com.ibm.team.interop.client.internal.Messages;
import com.ibm.team.interop.common.IExternalRepositoryConnection;
import com.ibm.team.interop.common.IExternalRepositoryConnectionHandle;
import com.ibm.team.interop.common.ISyncRuleHandle;
import com.ibm.team.interop.common.dto.IManagerInfoDTO;
import com.ibm.team.interop.common.dto.ITransformerInfoDTO;
import com.ibm.team.interop.common.dto.ITypeInfoDTO;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.advice.IItemsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

public class ItemConnectorAdminClient
extends InteropManager
implements IItemConnectorAdminClient {
    public ItemConnectorAdminClient(IClientLibraryContext context) {
        super(context);
    }

    @Override
    public IManagerInfoDTO[] getItemManagerInfo(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_GET_ITEM_MANAGER_INFO_TASK_NAME, 100);
            IManagerInfoDTO[] iManagerInfoDTOArray = this.getService().getItemManagerInfo();
            return iManagerInfoDTOArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ITypeInfoDTO[] getItemManagerTypeInfo(IManagerInfoDTO managerInfo, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        if (managerInfo == null) {
            throw new IllegalArgumentException("managerInfo must not be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_GET_ITEM_MANAGER_TYPE_INFO_TASK_NAME, 100);
            ITypeInfoDTO[] iTypeInfoDTOArray = this.getService().getItemManagerTypeInfo(managerInfo, processArea);
            return iTypeInfoDTOArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IManagerInfoDTO[] getExternalManagerInfo(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_GET_EXTERNAL_MANAGER_INFO_TASK_NAME, 100);
            IManagerInfoDTO[] iManagerInfoDTOArray = this.getService().getExternalManagerInfo();
            return iManagerInfoDTOArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ITypeInfoDTO[] getExternalManagerTypeInfo(IManagerInfoDTO managerInfo, IExternalRepositoryConnection externalConnection, IProgressMonitor monitor) throws TeamRepositoryException {
        if (managerInfo == null) {
            throw new IllegalArgumentException("managerInfo must not be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_GET_EXTERNAL_MAANGER_TYPE_INFO_TASK_NAME, 100);
            ITypeInfoDTO[] iTypeInfoDTOArray = this.getService().getExternalManagerTypeInfo(managerInfo, externalConnection);
            return iTypeInfoDTOArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ITransformerInfoDTO[] getValueTransformerInfo(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_GET_VALUE_TRANSFORMER_INFO_TASK_NAME, 100);
            ITransformerInfoDTO[] iTransformerInfoDTOArray = this.getService().getValueTransformerInfo();
            return iTransformerInfoDTOArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalRepositoryConnection saveExternalRepositoryConnection(IExternalRepositoryConnection externalConnection, IProgressMonitor monitor) throws TeamRepositoryException {
        if (externalConnection == null) {
            throw new IllegalArgumentException("externalConnection cannot be null");
        }
        if (!externalConnection.isWorkingCopy()) {
            throw new IllegalArgumentException("externalConnection must be a working copy");
        }
        SaveExternalRepositoryConnectionRunnable runnable = new SaveExternalRepositoryConnectionRunnable(externalConnection);
        monitor = this.getMonitor(monitor);
        try {
            IExternalRepositoryConnection savedItem;
            monitor.beginTask(Messages.InteropManager_SAVE_SYNCRULE_TASK_NAME, 100);
            this.processClient().execute((ProcessRunnable)runnable, Messages.ItemConnectorAdminClient_SAVE_EXTERNAL_CONNECTION_TASK_NAME, monitor);
            IExternalRepositoryConnection iExternalRepositoryConnection = savedItem = runnable.getSavedItem();
            return iExternalRepositoryConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteExternalRepositoryConnection(IExternalRepositoryConnectionHandle externalConnectionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (externalConnectionHandle == null) {
            throw new IllegalArgumentException("externalConnectionHandle cannot be null");
        }
        DeleteExternalRepositoryConnectionRunnable runnable = new DeleteExternalRepositoryConnectionRunnable(externalConnectionHandle);
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_DELETE_EXTERNAL_CONNECTION_TASK_NAME, 100);
            this.processClient().execute((ProcessRunnable)runnable, Messages.ItemConnectorAdminClient_DELETE_EXTERNAL_CONNECTION_TASK_NAME, monitor);
            this.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(externalConnectionHandle));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalRepositoryConnection findExternalRepositoryConnection(String name, IProgressMonitor monitor) throws TeamRepositoryException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_FIND_EXTERNAL_CONNECTION_TASK_NAME, 100);
            IExternalRepositoryConnection foundItem = this.getService().findExternalRepositoryConnection(name);
            if (foundItem == null) {
                return null;
            }
            IExternalRepositoryConnection iExternalRepositoryConnection = foundItem;
            return iExternalRepositoryConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IExternalRepositoryConnection[] getAllExternalRepositoryConnections(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_GET_ALL_EXTERNAL_CONNECTIONS_TASK_NAME, 100);
            IExternalRepositoryConnection[] iExternalRepositoryConnectionArray = this.getService().getAllExternalRepositoryConnections();
            return iExternalRepositoryConnectionArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public ISyncRuleHandle[] findSyncRulesByExternalRepository(IExternalRepositoryConnectionHandle externalConnectionHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (externalConnectionHandle == null) {
            throw new IllegalArgumentException("externalConnectionHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_FIND_SYNCRULES_FOR_EXTERNAL_CONNECTION_TASK_NAME, 100);
            ISyncRuleHandle[] iSyncRuleHandleArray = this.getService().findSyncRulesByExternalRepository(externalConnectionHandle);
            return iSyncRuleHandleArray;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void synchronizeOutgoingAllItems(ISyncRuleHandle syncRuleHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (syncRuleHandle == null) {
            throw new IllegalArgumentException("syncRuleHandle cannot be null");
        }
        monitor = this.getMonitor(monitor);
        try {
            monitor.beginTask(Messages.ItemConnectorAdminClient_SYNC_OUT_TASK_NAME, 100);
            this.getService().synchronizeOutgoingAllItems(syncRuleHandle);
        }
        finally {
            monitor.done();
        }
    }

    private class DeleteExternalRepositoryConnectionRunnable
    extends ProcessRunnable {
        private final IExternalRepositoryConnectionHandle fExternalConnectionHandle;

        public DeleteExternalRepositoryConnectionRunnable(IExternalRepositoryConnectionHandle externalConnectionHandle) {
            this.fExternalConnectionHandle = externalConnectionHandle;
        }

        public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
            IOperationReport report = null;
            try {
                ItemConnectorAdminClient.this.getService().deleteExternalRepositoryConnection(this.fExternalConnectionHandle);
            }
            catch (TeamOperationCanceledException e) {
                report = e.getReport();
            }
            return report;
        }
    }

    private class SaveExternalRepositoryConnectionRunnable
    extends ProcessRunnable {
        private IExternalRepositoryConnection fSavedItem;
        private final IExternalRepositoryConnection fWorkingCopy;

        public SaveExternalRepositoryConnectionRunnable(IExternalRepositoryConnection workingCopy) {
            this.fWorkingCopy = workingCopy;
        }

        public IExternalRepositoryConnection getSavedItem() {
            return this.fSavedItem;
        }

        public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
            IItemsResponse response = ItemConnectorAdminClient.this.getService().saveExternalRepositoryConnection(this.fWorkingCopy);
            this.fSavedItem = (IExternalRepositoryConnection)response.getFirstClientItem();
            return response.getOperationReport();
        }
    }
}

