/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.lyo.oslc4j.core.annotation.OslcCreationFactory;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDialog;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDialogs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcQueryCapability;
import org.eclipse.lyo.oslc4j.core.annotation.OslcService;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingAnnotationException;
import org.eclipse.lyo.oslc4j.core.model.CreationFactory;
import org.eclipse.lyo.oslc4j.core.model.Dialog;
import org.eclipse.lyo.oslc4j.core.model.Publisher;
import org.eclipse.lyo.oslc4j.core.model.QueryCapability;
import org.eclipse.lyo.oslc4j.core.model.Service;
import org.eclipse.lyo.oslc4j.core.model.ServiceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceProviderFactory {
    private static final Logger logger = Logger.getLogger(ServiceProviderFactory.class.getName());

    private ServiceProviderFactory() {
    }

    public static ServiceProvider createServiceProvider(String baseURI, String genericBaseURI, String title, String description, Publisher publisher, Class<?>[] resourceClasses) throws OslcCoreApplicationException, URISyntaxException {
        return ServiceProviderFactory.initServiceProvider(new ServiceProvider(), baseURI, genericBaseURI, title, description, publisher, resourceClasses, null);
    }

    public static ServiceProvider createServiceProvider(String baseURI, String genericBaseURI, String title, String description, Publisher publisher, Class<?>[] resourceClasses, Map<String, Object> pathParameterValues) throws OslcCoreApplicationException, URISyntaxException {
        return ServiceProviderFactory.initServiceProvider(new ServiceProvider(), baseURI, genericBaseURI, title, description, publisher, resourceClasses, pathParameterValues);
    }

    public static ServiceProvider initServiceProvider(ServiceProvider serviceProvider, String baseURI, String genericBaseURI, String title, String description, Publisher publisher, Class<?>[] resourceClasses, Map<String, Object> pathParameterValues) throws OslcCoreApplicationException, URISyntaxException {
        serviceProvider.setTitle(title);
        serviceProvider.setDescription(description);
        serviceProvider.setPublisher(publisher);
        HashMap<String, Service> serviceMap = new HashMap<String, Service>();
        for (Class<?> resourceClass : resourceClasses) {
            OslcService serviceAnnotation = resourceClass.getAnnotation(OslcService.class);
            if (serviceAnnotation == null) {
                throw new OslcCoreMissingAnnotationException(resourceClass, OslcService.class);
            }
            String domain = serviceAnnotation.value();
            Service service = (Service)serviceMap.get(domain);
            if (service == null) {
                service = new Service(new URI(domain));
                serviceMap.put(domain, service);
            }
            ServiceProviderFactory.handleResourceClass(baseURI, genericBaseURI, resourceClass, service, pathParameterValues);
        }
        for (Service service : serviceMap.values()) {
            serviceProvider.addService(service);
        }
        return serviceProvider;
    }

    private static void handleResourceClass(String baseURI, String genericBaseURI, Class<?> resourceClass, Service service, Map<String, Object> pathParameterValues) throws URISyntaxException {
        for (Method method : resourceClass.getMethods()) {
            OslcDialogs dialogsAnnotation;
            GET getAnnotation = method.getAnnotation(GET.class);
            if (getAnnotation != null) {
                OslcDialogs dialogsAnnotation2;
                OslcQueryCapability queryCapabilityAnnotation = method.getAnnotation(OslcQueryCapability.class);
                String[] resourceShapes = null;
                if (queryCapabilityAnnotation != null) {
                    service.addQueryCapability(ServiceProviderFactory.createQueryCapability(baseURI, method, pathParameterValues));
                    String resourceShape = queryCapabilityAnnotation.resourceShape();
                    if (resourceShape != null && resourceShape.length() > 0) {
                        resourceShapes = new String[]{resourceShape};
                    }
                }
                if ((dialogsAnnotation2 = method.getAnnotation(OslcDialogs.class)) != null) {
                    OslcDialog[] dialogs;
                    for (OslcDialog dialog : dialogs = dialogsAnnotation2.value()) {
                        if (dialog == null) continue;
                        service.addSelectionDialog(ServiceProviderFactory.createSelectionDialog(baseURI, genericBaseURI, method, dialog, resourceShapes, pathParameterValues));
                    }
                    continue;
                }
                OslcDialog dialogAnnotation = method.getAnnotation(OslcDialog.class);
                if (dialogAnnotation == null) continue;
                service.addSelectionDialog(ServiceProviderFactory.createSelectionDialog(baseURI, genericBaseURI, method, dialogAnnotation, resourceShapes, pathParameterValues));
                continue;
            }
            POST postAnnotation = method.getAnnotation(POST.class);
            if (postAnnotation == null) continue;
            OslcCreationFactory creationFactoryAnnotation = method.getAnnotation(OslcCreationFactory.class);
            String[] resourceShapes = null;
            if (creationFactoryAnnotation != null) {
                service.addCreationFactory(ServiceProviderFactory.createCreationFactory(baseURI, method, pathParameterValues));
                resourceShapes = creationFactoryAnnotation.resourceShapes();
            }
            if ((dialogsAnnotation = method.getAnnotation(OslcDialogs.class)) != null) {
                OslcDialog[] dialogs;
                for (OslcDialog dialog : dialogs = dialogsAnnotation.value()) {
                    if (dialog == null) continue;
                    service.addCreationDialog(ServiceProviderFactory.createCreationDialog(baseURI, genericBaseURI, method, dialog, resourceShapes, pathParameterValues));
                }
                continue;
            }
            OslcDialog dialogAnnotation = method.getAnnotation(OslcDialog.class);
            if (dialogAnnotation == null) continue;
            service.addCreationDialog(ServiceProviderFactory.createCreationDialog(baseURI, genericBaseURI, method, dialogAnnotation, resourceShapes, pathParameterValues));
        }
    }

    private static CreationFactory createCreationFactory(String baseURI, Method method, Map<String, Object> pathParameterValues) throws URISyntaxException {
        OslcCreationFactory creationFactoryAnnotation = method.getAnnotation(OslcCreationFactory.class);
        String title = creationFactoryAnnotation.title();
        String label = creationFactoryAnnotation.label();
        String[] resourceShapes = creationFactoryAnnotation.resourceShapes();
        String[] resourceTypes = creationFactoryAnnotation.resourceTypes();
        String[] usages = creationFactoryAnnotation.usages();
        String basePath = baseURI + "/";
        Path classPathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        String creation = ServiceProviderFactory.resolvePathParameters(basePath, classPathAnnotation.value(), pathParameterValues);
        Path methodPathAnnotation = method.getAnnotation(Path.class);
        if (methodPathAnnotation != null) {
            creation = creation + '/' + methodPathAnnotation.value();
        }
        CreationFactory creationFactory = null;
        creationFactory = new CreationFactory(title, new URI(creation).normalize());
        if (label != null && label.length() > 0) {
            creationFactory.setLabel(label);
        }
        for (String resourceShape : resourceShapes) {
            creationFactory.addResourceShape(new URI(basePath + resourceShape).normalize());
        }
        for (String resourceType : resourceTypes) {
            creationFactory.addResourceType(new URI(resourceType));
        }
        for (String usage : usages) {
            creationFactory.addUsage(new URI(usage));
        }
        return creationFactory;
    }

    private static QueryCapability createQueryCapability(String baseURI, Method method, Map<String, Object> pathParameterValues) throws URISyntaxException {
        OslcQueryCapability queryCapabilityAnnotation = method.getAnnotation(OslcQueryCapability.class);
        String title = queryCapabilityAnnotation.title();
        String label = queryCapabilityAnnotation.label();
        String resourceShape = queryCapabilityAnnotation.resourceShape();
        String[] resourceTypes = queryCapabilityAnnotation.resourceTypes();
        String[] usages = queryCapabilityAnnotation.usages();
        String basePath = baseURI + "/";
        Path classPathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        String creation = ServiceProviderFactory.resolvePathParameters(basePath, classPathAnnotation.value(), pathParameterValues);
        Path methodPathAnnotation = method.getAnnotation(Path.class);
        if (methodPathAnnotation != null) {
            creation = creation + '/' + methodPathAnnotation.value();
        }
        QueryCapability queryCapability = null;
        queryCapability = new QueryCapability(title, new URI(creation).normalize());
        if (label != null && label.length() > 0) {
            queryCapability.setLabel(label);
        }
        if (resourceShape != null && resourceShape.length() > 0) {
            queryCapability.setResourceShape(new URI(basePath + resourceShape).normalize());
        }
        for (String resourceType : resourceTypes) {
            queryCapability.addResourceType(new URI(resourceType));
        }
        for (String usage : usages) {
            queryCapability.addUsage(new URI(usage));
        }
        return queryCapability;
    }

    private static Dialog createCreationDialog(String baseURI, String genericBaseURI, Method method, OslcDialog dialogAnnotation, String[] resourceShapes, Map<String, Object> pathParameterValues) throws URISyntaxException {
        return ServiceProviderFactory.createDialog(baseURI, genericBaseURI, "Creation", "creation", method, dialogAnnotation, resourceShapes, pathParameterValues);
    }

    private static Dialog createSelectionDialog(String baseURI, String genericBaseURI, Method method, OslcDialog dialogAnnotation, String[] resourceShapes, Map<String, Object> pathParameterValues) throws URISyntaxException {
        return ServiceProviderFactory.createDialog(baseURI, genericBaseURI, "Selection", "queryBase", method, dialogAnnotation, resourceShapes, pathParameterValues);
    }

    private static Dialog createDialog(String baseURI, String genericBaseURI, String dialogType, String parameterName, Method method, OslcDialog dialogAnnotation, String[] resourceShapes, Map<String, Object> pathParameterValues) throws URISyntaxException {
        String title = dialogAnnotation.title();
        String label = dialogAnnotation.label();
        String dialogURI = dialogAnnotation.uri();
        String hintWidth = dialogAnnotation.hintWidth();
        String hintHeight = dialogAnnotation.hintHeight();
        String[] resourceTypes = dialogAnnotation.resourceTypes();
        String[] usages = dialogAnnotation.usages();
        String uri = "";
        Path classPathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        String classPathAnnotationValue = classPathAnnotation.value();
        if (dialogURI.length() > 0) {
            uri = ServiceProviderFactory.resolvePathParameters(baseURI, dialogURI, pathParameterValues);
        } else {
            uri = genericBaseURI + "/generic/generic" + dialogType + ".html";
            Path methodPathAnnotation = method.getAnnotation(Path.class);
            String parameter = ServiceProviderFactory.resolvePathParameters(baseURI, classPathAnnotationValue, pathParameterValues);
            if (methodPathAnnotation != null) {
                parameter = parameter + '/' + methodPathAnnotation.value();
            }
            try {
                String encodedParameter = URLEncoder.encode(parameter, "UTF-8");
                uri = uri + "?" + parameterName + "=" + encodedParameter;
            }
            catch (UnsupportedEncodingException exception) {
                logger.log(Level.WARNING, "Error encoding URI [" + parameter + "]", exception);
            }
            String resourceShapeParameters = "";
            if (resourceShapes != null) {
                int numResourceShapes = resourceShapes.length;
                for (int index = 0; index < numResourceShapes; ++index) {
                    String resourceShapeURI = baseURI + '/' + resourceShapes[index];
                    try {
                        String encodedResourceShape = URLEncoder.encode(resourceShapeURI, "UTF-8");
                        resourceShapeParameters = resourceShapeParameters + "&resourceShape=" + encodedResourceShape;
                        continue;
                    }
                    catch (UnsupportedEncodingException exception) {
                        logger.log(Level.WARNING, "Error encoding URI [" + resourceShapeURI + "]", exception);
                    }
                }
            }
            uri = uri + resourceShapeParameters;
        }
        Dialog dialog = null;
        dialog = new Dialog(title, new URI(uri).normalize());
        if (label != null && label.length() > 0) {
            dialog.setLabel(label);
        }
        if (hintWidth != null && hintWidth.length() > 0) {
            dialog.setHintWidth(hintWidth);
        }
        if (hintHeight != null && hintHeight.length() > 0) {
            dialog.setHintHeight(hintHeight);
        }
        for (String resourceType : resourceTypes) {
            dialog.addResourceType(new URI(resourceType));
        }
        for (String usage : usages) {
            dialog.addUsage(new URI(usage));
        }
        return dialog;
    }

    private static String resolvePathParameters(String basePath, String pathAnnotation, Map<String, Object> pathParameterValues) {
        String returnUri = null;
        if (pathParameterValues != null && pathParameterValues.size() > 0) {
            UriBuilder builder = UriBuilder.fromUri(basePath);
            URI resolvedUri = builder.path(pathAnnotation).buildFromMap(pathParameterValues);
            if (resolvedUri != null) {
                returnUri = resolvedUri.toString();
            }
        } else {
            returnUri = basePath + "/" + pathAnnotation;
        }
        return returnUri;
    }
}

