/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ErrorHandler
implements RDFErrorHandler {
    private static final Logger logger = Logger.getLogger(ErrorHandler.class.getName());
    private static final String JENA_RELATIVE_URI_WARNING_ID = "W130";

    public void error(Exception exception) {
        ErrorHandler.handleException(exception);
    }

    public void fatalError(Exception exception) {
        ErrorHandler.handleException(exception);
    }

    public void warning(Exception exception) {
        Level level = Level.WARNING;
        String msg = exception.getMessage();
        if (msg != null && msg.indexOf(JENA_RELATIVE_URI_WARNING_ID) >= 0) {
            level = Level.FINE;
        }
        logger.log(level, "Warning in Jena handling", exception);
    }

    private static void handleException(Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new JenaException(exception);
    }
}

