/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence;

import com.urbancode.persistence.IDGenerator;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class IDGeneratorCryptoRandom
extends IDGenerator {
    private static final String KEY_ALGO = "AES";
    private static final String CIPHER_ALGO = "AES/ECB/NoPadding";
    private static final long COUNTER_PREFIX = 6325086362282927577L;
    private final Cipher cipher;
    private long counter;

    static byte[] getRandomSeed() {
        byte[] seed = new byte[16];
        new SecureRandom().nextBytes(seed);
        return seed;
    }

    public IDGeneratorCryptoRandom() {
        this(IDGeneratorCryptoRandom.getRandomSeed());
    }

    public IDGeneratorCryptoRandom(byte[] seed) {
        try {
            SecretKeySpec key = new SecretKeySpec(seed, KEY_ALGO);
            this.cipher = Cipher.getInstance(CIPHER_ALGO);
            this.cipher.init(1, key);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized UUID newID() {
        long n = this.counter++;
        byte[] input = IDGeneratorCryptoRandom.toBytes(6325086362282927577L, n);
        byte[] output = this.cipher.update(input);
        return IDGeneratorCryptoRandom.randomUUID(output);
    }
}

