/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common;

public class Size {
    private static final int EM_IN_PX = 12;
    private final int fWidth;
    private final int fHeight;
    private final SizeUnit fWidthUnit;
    private final SizeUnit fHeightUnit;

    public Size(int width, int height, SizeUnit unit) {
        this.fWidth = width;
        this.fHeight = height;
        this.fWidthUnit = unit;
        this.fHeightUnit = unit;
    }

    public Size(int width, SizeUnit widthUnit, int height, SizeUnit heightUnit) {
        this.fWidth = width;
        this.fHeight = height;
        this.fWidthUnit = widthUnit;
        this.fHeightUnit = heightUnit;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public int getHeight() {
        return this.fHeight;
    }

    public SizeUnit getWidthUnit() {
        return this.fWidthUnit;
    }

    public SizeUnit getHeightUnit() {
        return this.fHeightUnit;
    }

    public int getWidth(SizeUnit unit) {
        return Size.convert(this.fWidth, this.fWidthUnit, unit);
    }

    public int getHeight(SizeUnit unit) {
        return Size.convert(this.fHeight, this.fHeightUnit, unit);
    }

    public String getWidthString(SizeUnit unit) {
        return String.valueOf(Size.convert(this.fWidth, this.fWidthUnit, unit)) + unit.name();
    }

    public String getHeightString(SizeUnit unit) {
        return String.valueOf(Size.convert(this.fHeight, this.fHeightUnit, unit)) + unit.name();
    }

    public String getOriginalWidthString() {
        return String.valueOf(this.fWidth) + this.fWidthUnit.name();
    }

    public String getOriginalHeightString() {
        return String.valueOf(this.fHeight) + this.fHeightUnit.name();
    }

    private static int convert(int size, SizeUnit sizeUnit, SizeUnit newUnit) {
        if (sizeUnit == newUnit) {
            return size;
        }
        if (sizeUnit == SizeUnit.px && newUnit == SizeUnit.em) {
            return size / 12;
        }
        if (sizeUnit == SizeUnit.em && newUnit == SizeUnit.px) {
            return size * 12;
        }
        throw new IllegalStateException();
    }

    private static SizeUnit getSizeUnit(String str) {
        if (str.endsWith(SizeUnit.px.toString())) {
            return SizeUnit.px;
        }
        if (str.endsWith(SizeUnit.em.toString())) {
            return SizeUnit.em;
        }
        return null;
    }

    public static Size parse(String widthString, String heightString, Size defaultSize) {
        try {
            if (widthString.length() > 2 && heightString.length() > 2) {
                int width = Integer.parseInt(widthString.substring(0, widthString.length() - 2));
                SizeUnit widthUnit = Size.getSizeUnit(widthString);
                int height = Integer.parseInt(heightString.substring(0, heightString.length() - 2));
                SizeUnit heightUnit = Size.getSizeUnit(heightString);
                if (widthUnit != null && heightUnit != null) {
                    return new Size(width, widthUnit, height, heightUnit);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return defaultSize;
    }

    public static enum SizeUnit {
        px,
        em;

    }
}

