/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence;

import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.IDGeneratorSeeded;
import java.util.UUID;

public class IDGeneratorSeededCounter
extends IDGenerator
implements IDGeneratorSeeded {
    private static final int MASK = 0xFFFFFF;
    private final ThreadLocal<State> state = new ThreadLocal<State>(){

        @Override
        protected State initialValue() {
            return new State();
        }
    };

    public void setSeed(UUID seed) {
        this.state.set(new State(seed));
    }

    public void reset() {
        this.state.remove();
    }

    public UUID newID() {
        return this.state.get().newId();
    }

    static class State {
        final long seedHi;
        final long seedLo;
        int counter;

        State() {
            this.seedHi = 0L;
            this.seedLo = 0L;
            this.counter = -1;
        }

        State(UUID seed) {
            this.seedHi = seed.getMostSignificantBits();
            this.seedLo = seed.getLeastSignificantBits();
        }

        UUID newId() {
            int n;
            if (this.counter < 0) {
                return UUID.randomUUID();
            }
            if ((n = this.counter++) > 0xFFFFFF) {
                throw new RuntimeException("generated too many IDs: " + n);
            }
            long lo = this.seedLo & 0xFFFFFFFFFF000000L | (long)(n & 0xFFFFFF);
            return new UUID(this.seedHi, lo);
        }
    }
}

