/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate.audit.event;

import com.urbancode.persistence.hibernate.AbstractEntity;
import com.urbancode.persistence.hibernate.audit.event.AuditEventType;
import com.urbancode.persistence.hibernate.audit.event.Change;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuditEvent {
    private final AuditEventType type;
    private final Object agent;
    private final AbstractEntity<Serializable> entity;
    private final List<Change> changes = new ArrayList<Change>();
    private final Date eventTime;

    protected AbstractAuditEvent(AuditEventType type, Object agent, AbstractEntity<Serializable> entity, Collection<Change> changes) {
        this.type = type;
        this.agent = agent;
        this.entity = entity;
        if (changes != null) {
            this.changes.addAll(changes);
        }
        this.eventTime = new Date();
    }

    public AuditEventType getType() {
        return this.type;
    }

    public AbstractEntity<Serializable> getEntity() {
        return this.entity;
    }

    protected List<Change> getChanges() {
        return this.changes;
    }

    public Date getEventTime() {
        return this.eventTime == null ? null : (Date)this.eventTime.clone();
    }

    public Object getAgent() {
        return this.agent;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (type: " + (Object)((Object)this.getType()) + ", entity: " + this.getEntity() + "):\n" + this.changes;
    }

    public boolean equals(Object obj) {
        AbstractAuditEvent event;
        boolean result = false;
        if (obj instanceof AbstractAuditEvent && (event = (AbstractAuditEvent)obj).getEntity().getClass().equals(this.getEntity().getClass()) && event.getEntity().getId().equals(this.getEntity().getId()) && event.getType().equals((Object)this.getType())) {
            result = CollectionUtils.isEqualCollection(event.getChanges(), this.getChanges());
        }
        return result;
    }
}

