/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.AuthenticationDetails;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class ProxyAuthenticator
extends Authenticator {
    private static final boolean TRACE_PROXY = System.getenv("trace_scm_proxy_auth") != null;
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private Map<Host, AuthenticationDetails> hosts = new HashMap<Host, AuthenticationDetails>();

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        String hostName = this.getHostName();
        if (hostName == null) {
            return null;
        }
        if (this.getRequestorType() != Authenticator.RequestorType.PROXY) {
            if (TRACE_PROXY) {
                System.err.print("Authentication requested but not provided for non-proxy host: ");
                System.err.println(hostName);
            }
            return null;
        }
        int port = this.getRequestingPort();
        AuthenticationDetails auth = this.getAuthenticationDetails(hostName, port);
        if (auth != null) {
            if (TRACE_PROXY) {
                System.err.print("Authentication provided for proxy host: ");
                System.err.println(hostName);
            }
            return new PasswordAuthentication(auth.getUser(), auth.getPassword().toCharArray());
        }
        if (TRACE_PROXY) {
            System.err.print("Authentication requested but not provided for proxy host: ");
            System.err.println(hostName);
        }
        return null;
    }

    private String getHostName() {
        String hostString = this.getRequestingHost();
        if (hostString == null) {
            InetAddress address = this.getRequestingSite();
            if (address != null) {
                hostString = address.getHostName();
            }
            if (hostString == null) {
                return null;
            }
        }
        return hostString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationDetails getAuthenticationDetails(String hostString, int port) {
        Map<Host, AuthenticationDetails> map = this.hosts;
        synchronized (map) {
            return this.hosts.get(new Host(hostString, port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyDetails(String proxyHost, int proxyPort, String proxyUserName, String proxyPassword) {
        AuthenticationDetails ad = new AuthenticationDetails(proxyUserName, proxyPassword);
        Map<Host, AuthenticationDetails> map = this.hosts;
        synchronized (map) {
            this.hosts.put(new Host(proxyHost, proxyPort), ad);
        }
    }

    public void addProxyData(String url, String proxyHost, int proxyPort, String proxyUserName, String proxyPassword) {
        block13: {
            if (proxyUserName != null) {
                Authenticator.setDefault(this);
                this.addProxyDetails(proxyHost, proxyPort, proxyUserName, proxyPassword);
            }
            try {
                String scheme = ProxyAuthenticator.getProxyScheme(url);
                if (scheme != null && (scheme.equals(HTTPS_SCHEME) || scheme.equals(HTTP_SCHEME))) {
                    if (TRACE_PROXY) {
                        System.err.print("Setting java system properties for proxy: ");
                        System.err.print(scheme);
                        System.err.print("://");
                        if (proxyUserName != null) {
                            System.err.print(proxyUserName);
                            if (proxyPassword != null) {
                                System.err.print(":");
                                int i = 0;
                                while (i < proxyPassword.length()) {
                                    System.err.print("*");
                                    ++i;
                                }
                            }
                            System.err.print("@");
                        }
                        System.err.print(proxyHost);
                        if (proxyPort != -1) {
                            System.err.print(":");
                            System.err.print(proxyPort);
                        }
                        System.err.println();
                    }
                    Properties sysProps = System.getProperties();
                    sysProps.put(String.valueOf(scheme) + ".proxySet", "true");
                    sysProps.put(String.valueOf(scheme) + ".proxyHost", proxyHost);
                    if (proxyPort == -1) {
                        sysProps.remove(String.valueOf(scheme) + ".proxyPort");
                    } else {
                        sysProps.put(String.valueOf(scheme) + ".proxyPort", String.valueOf(proxyPort));
                    }
                    if (proxyUserName == null || proxyPassword == null || proxyUserName.length() == 0 || proxyPassword.length() == 0) {
                        sysProps.remove(String.valueOf(scheme) + ".proxyUser");
                        sysProps.remove(String.valueOf(scheme) + ".proxyUserName");
                        sysProps.remove(String.valueOf(scheme) + ".proxyPassword");
                    } else {
                        sysProps.put(String.valueOf(scheme) + ".proxyUser", proxyUserName);
                        sysProps.put(String.valueOf(scheme) + ".proxyUserName", proxyUserName);
                        sysProps.put(String.valueOf(scheme) + ".proxyPassword", proxyPassword);
                    }
                }
            }
            catch (Throwable e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
                if (!TRACE_PROXY) break block13;
                System.err.print("Error setting up proxy: ");
                System.err.println(e.getMessage());
            }
        }
    }

    private static String getProxyScheme(String url) {
        if (url.toLowerCase(Locale.ENGLISH).startsWith("https:")) {
            return HTTPS_SCHEME;
        }
        if (url.toLowerCase(Locale.ENGLISH).startsWith("http:")) {
            return HTTP_SCHEME;
        }
        return null;
    }

    private static class Host {
        final String name;
        final int port;

        Host(String name, int port) {
            this.name = name;
            this.port = port;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Host other = (Host)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.port == other.port;
        }
    }
}

