/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load.loadRules;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.loadRules.RelativeLoadLocation;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.LoadRuleSerializationDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class LoadRequest {
    private final IConnection connection;
    private final RelativeLoadLocation relativeLoadLocation;
    private final IComponent component;
    protected static final String EOL = System.getProperty("line.separator");

    public LoadRequest(IConnection connection, IComponent component, RelativeLoadLocation relativeLoadLocation) {
        this.connection = connection;
        this.relativeLoadLocation = relativeLoadLocation;
        this.component = component;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public String getComponentName() {
        return this.component.getName();
    }

    public RelativeLoadLocation getRelativeLoadLocation() {
        return this.relativeLoadLocation;
    }

    protected final IConnection getConnection() {
        return this.connection;
    }

    protected final IConfiguration getConfiguration() throws TeamRepositoryException {
        IConfiguration config;
        IConnection connection = this.getConnection();
        if (connection instanceof IWorkspaceConnection) {
            config = ((IWorkspaceConnection)connection).configuration((IComponentHandle)this.getComponent());
        } else {
            config = ((IBaselineConnection)connection).configuration();
            if (!config.component().sameItemId((IItemHandle)this.getComponent())) {
                throw new ComponentNotInWorkspaceException(NLS.bind((String)Messages.ItemLoadRequest_0, (Object)this.getComponentName(), (Object[])new Object[]{((IBaselineConnection)connection).getId(), ((IBaselineConnection)connection).getName()}));
            }
        }
        return config;
    }

    protected final String getNiceRepoPath(String[] repositoryPath) {
        String repoPath = "";
        repoPath = repositoryPath == null ? Messages.LoadRequest_0 : (repositoryPath.length == 0 ? "/" : PathUtils.getString(repositoryPath));
        return repoPath;
    }

    protected void addComponentToRule(Document document, Element parent, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) {
        Element element = document.createElement("component");
        parent.appendChild(element);
        if (preferences.useComponentName()) {
            element.setAttribute("name", this.component.getName());
            Comment comment = document.createComment(" <component itemId=\"" + this.component.getItemId().getUuidValue() + "\" /> ");
            parent.appendChild(comment);
        } else {
            element.setAttribute("itemId", this.component.getItemId().getUuidValue());
            Comment comment = document.createComment(" <component name=\"" + this.component.getName() + "\" /> ");
            parent.appendChild(comment);
        }
    }

    protected void addVersionableToRule(String[] repoPath, IVersionableHandle versionableHandle, Document document, Element parent, String elementType, LoadRuleSerializationDilemmaHandler preferences, IProgressMonitor progress) {
        Element element = document.createElement(elementType);
        parent.appendChild(element);
        if (preferences.useRepositoryPath()) {
            element.setAttribute("repositoryPath", this.getNiceRepoPath(repoPath));
            Comment comment = document.createComment(" <" + elementType + " " + "itemType" + "=\"" + this.getRuleItemType(versionableHandle) + "\" " + "itemId" + "=\"" + versionableHandle.getItemId().getUuidValue() + "\" /> ");
            parent.appendChild(comment);
        } else {
            element.setAttribute("itemType", this.getRuleItemType(versionableHandle));
            element.setAttribute("itemId", versionableHandle.getItemId().getUuidValue());
            Comment comment = document.createComment(" <" + elementType + " " + "repositoryPath" + "=\"" + this.getNiceRepoPath(repoPath) + "\" /> ");
            parent.appendChild(comment);
        }
    }

    private String getRuleItemType(IVersionableHandle versionableHandle) {
        if (versionableHandle instanceof IFolderHandle) {
            return "folder";
        }
        if (versionableHandle instanceof IFileItemHandle) {
            return "file";
        }
        if (versionableHandle instanceof ISymbolicLinkHandle) {
            return "link";
        }
        throw new IllegalStateException();
    }

    public abstract IVersionableHandle requireRepoPath();

    public abstract void setRepoPath(IAncestorReport var1) throws FileSystemException;

    public abstract void toRule(Document var1, Element var2, LoadRuleSerializationDilemmaHandler var3, IProgressMonitor var4) throws TeamRepositoryException;

    public abstract IStatus configureLoad(ILoadOperation var1, ISandbox var2, IProgressMonitor var3);

    public abstract IStatus configureLoad(ILoadOperation var1, ISandbox var2, boolean var3, IProgressMonitor var4);
}

