/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.client.internal.localchanges.LocalAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalModification;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class LocalChangeTracker {
    public static final Object CHANGES_COMPUTER_JOB_FAMILY = Messages.LocalChangeTracker_0;
    private static final long DELAY = 200000000L;
    private static final long DELAY_MS = 200L;
    private LocalChangeNotifier notifier;
    LocalChangeContext context;
    private LocalChangeNode changeTree = new LocalChangeNode(null, null);
    private LocalChangesComputer computeChangesjob;
    private Map<UUID, LocalChange> localChanges = new HashMap<UUID, LocalChange>();
    private HashMap<DateRecord, Long> needDates = new HashMap();

    private static void setCounterpart(LocalMoveFrom moveFrom, LocalMoveTo moveTo) {
        moveFrom.setCounterpart(moveTo);
        moveTo.setCounterpart(moveFrom);
    }

    private static void setNode(LocalChangeNode node, LocalChange change) {
        change.setNode(node);
        node.addChange(change);
    }

    public LocalChangeTracker(LocalChangeNotifier notifier, LocalChangeContext context, ISchedulingRule schedulingRule) {
        this.notifier = notifier;
        this.context = context;
        if (schedulingRule == null) {
            schedulingRule = new DefaultSchedulingRule();
        }
        this.computeChangesjob = new LocalChangesComputer(schedulingRule);
        this.computeChangesjob.requestRefresh();
    }

    public synchronized void cancelChanges(ILocalChange[] canceled) {
        ILocalChange[] allCanceled = this.forgetChanges(canceled);
        this.notifier.changesCanceled(this.context, allCanceled);
    }

    public synchronized void cancelChanges(IShareable root) {
        ILocalChange[] allCanceled = this.forgetChanges(root);
        this.notifier.changesCanceled(this.context, allCanceled);
    }

    public synchronized void cancelAllChanges() {
        if (!this.localChanges.isEmpty()) {
            this.cancelChanges(this.localChanges.values().toArray(new ILocalChange[this.localChanges.size()]));
        }
    }

    private void changeCanceled(LocalChange change) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeCanceled(this.context, change);
        }
    }

    private void changeOccurred(LocalChange change) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeOccurred(this.context, change);
        }
    }

    public synchronized void confirmChanges(ILocalChange[] confirmed) {
        ILocalChange[] allConfirmed = this.forgetChanges(confirmed);
        this.notifier.changesConfirmed(this.context, allConfirmed);
    }

    private ILocalChange[] forgetChanges(ILocalChange[] toForget) {
        ArrayList<LocalChange> closure = new ArrayList<LocalChange>();
        int i = 0;
        while (i < toForget.length) {
            if (!toForget[i].isCanceled()) {
                LocalChange c = (LocalChange)toForget[i];
                closure.add(c);
                c.cancel();
                c.getNode().removeChange(c);
                this.localChanges.remove(c.getItemId());
            }
            ++i;
        }
        return closure.toArray(new ILocalChange[closure.size()]);
    }

    private ILocalChange[] forgetChanges(IShareable shareable) {
        LocalChangeNode startingPoint = this.changeTree.getNode(shareable.getLocalPath(), false);
        if (startingPoint == null) {
            return new ILocalChange[0];
        }
        ArrayList closure = new ArrayList();
        startingPoint.collect(closure);
        for (LocalChange c : closure) {
            c.cancel();
            this.localChanges.remove(c.getItemId());
        }
        this.clear(startingPoint);
        return closure.toArray(new ILocalChange[closure.size()]);
    }

    public synchronized ILocalChange getPendingChange(IVersionableHandle item) {
        if (item == null) {
            return NoOpChange.NO_OP;
        }
        LocalChange c = this.localChanges.get(item.getItemId());
        if (c == null) {
            return NoOpChange.NO_OP;
        }
        c.setWild();
        return c;
    }

    public ILocalChange[] getPendingChanges() {
        return this.getPendingChanges(false);
    }

    public synchronized ILocalChange[] getPendingChanges(boolean consume) {
        ILocalChange[] changes;
        ILocalChange[] iLocalChangeArray = changes = this.getPendingChanges(this.changeTree, consume);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            ((LocalChange)change).setWild();
            ++n2;
        }
        return changes;
    }

    public synchronized ILocalChange[] getPendingChanges(IRelativeLocation root, boolean consume) {
        ILocalChange[] changes;
        LocalChangeNode rootNode = this.changeTree.getNode(root, false);
        if (rootNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray = changes = this.getPendingChanges(rootNode, consume);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            ((LocalChange)change).setWild();
            ++n2;
        }
        return changes;
    }

    public synchronized ILocalChange[] getPendingChangesAt(IRelativeLocation root) {
        ILocalChange[] changes;
        LocalChangeNode rootNode = this.changeTree.getNode(root, false);
        if (rootNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray = changes = rootNode.getChanges().toArray(new LocalChange[rootNode.getChanges().size()]);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            ((LocalChange)c).setWild();
            ++n2;
        }
        return changes;
    }

    private ILocalChange[] getPendingChanges(LocalChangeNode startingPoint, boolean consume) {
        Assert.isNotNull((Object)startingPoint);
        ArrayList result = new ArrayList();
        startingPoint.collect(result);
        if (consume) {
            for (LocalChange change : result) {
                this.localChanges.remove(change.getItemId());
                change.cancel();
            }
            this.clear(startingPoint);
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    private void clear(LocalChangeNode startingPoint) {
        startingPoint.prune();
    }

    public void syncChanges(IProgressMonitor monitor) {
        this.syncChanges(null, monitor);
    }

    public void syncChanges(AbstractLock rule, IProgressMonitor monitor) {
        this.computeChangesjob.rejoin(rule, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPendingChanges(IProgressMonitor monitor) throws FileSystemException {
        Object pair;
        SharingManager shareManager = SharingManager.getInstance();
        HashMap<DateRecord, Long> modifiedInFuture = new HashMap<DateRecord, Long>();
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.context.getRoot());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SubMonitor subProgress = progress.newChild(1);
        while (true) {
            int size;
            HashMap<DateRecord, Long> hashMap = this.needDates;
            synchronized (hashMap) {
                size = this.needDates.size();
                if (size == 0) {
                    break;
                }
                Iterator<Map.Entry<DateRecord, Long>> it = this.needDates.entrySet().iterator();
                pair = it.next();
                it.remove();
            }
            subProgress.setWorkRemaining(size + 1);
            DateRecord rec = (DateRecord)pair.getKey();
            long hashedAt = (Long)pair.getValue();
            IShareable shareable = shareManager.findShareable(this.context.getRoot(), rec.connection, rec.component, rec.versionable, null);
            if (shareable == null) continue;
            long stamp = ((Shareable)shareable).getFileStorage().getLocalTimeStamp();
            if (stamp != hashedAt) {
                if (stamp >= hashedAt) continue;
                modifiedInFuture.put(rec, hashedAt);
                continue;
            }
            FileItemInfo oldInfo = ((Shareable)shareable).getFileItemInfo((IProgressMonitor)subProgress.newChild(1));
            Assert.isNotNull((Object)oldInfo);
            Assert.isNotNull((Object)oldInfo.getHash());
            long modStamp = ((Shareable)shareable).getFileStorage().getModificationStamp();
            if (modStamp == oldInfo.getLastContentChangeCheckStamp()) continue;
            FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), oldInfo.isContentChanged(), modStamp, oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getContentType(), oldInfo.getStoredPredecessorHintHash(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredHash(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isExecutable(), oldInfo.isOriginalExecutable(), oldInfo.isDirectoryLink(), oldInfo.isOriginalDirectoryLink());
            cfa.setItemMetaData(shareable.getLocalPath(), newInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, null);
        }
        subProgress.done();
        pair = this.needDates;
        synchronized (pair) {
            this.needDates.putAll(modifiedInFuture);
        }
        List<IMetadataChangeTracker.IChangeType> changes = cfa.internalGetMetadata().getMetadataChangeTracker().getLocalChanges(this.context.getComponent(), this.context.getConnection(), (IProgressMonitor)progress.newChild(1));
        ArrayList<LocalChange> localChanges = new ArrayList<LocalChange>(changes.size());
        HashSet<UUID> modifiedItems = new HashSet<UUID>();
        block13: for (IMetadataChangeTracker.IChangeType ct : changes) {
            switch (ct.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    localChanges.add(new LocalDeletion(this.context, ct.getCurrentPath(), ct.getOriginalPath(), ct.getItem(), ct.getPreviousParent()));
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                case 3: {
                    int type = 0;
                    if (ct.isContentChange()) {
                        type = 1;
                    }
                    if (ct.isFlagChange()) {
                        type |= 0x20;
                    }
                    LocalMoveFrom moveFrom = new LocalMoveFrom(this.context, ct.getCurrentMovedFromPath(), ct.getOriginalPath(), ct.getItem(), ct.getPreviousParent(), type);
                    LocalMoveTo moveTo = new LocalMoveTo(this.context, ct.getCurrentPath(), ct.getItem(), ct.getCurrentParent(), type);
                    LocalChangeTracker.setCounterpart(moveFrom, moveTo);
                    localChanges.add(moveTo);
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                case 4: {
                    localChanges.add(new LocalAddition(this.context, ct.getCurrentPath(), ct.getItem(), ct.getCurrentParent()));
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                default: {
                    int type = 0;
                    if (ct.isContentChange()) {
                        type = 1;
                    }
                    if (ct.isFlagChange()) {
                        type |= 0x20;
                    }
                    if (type == 0) continue block13;
                    localChanges.add(new LocalModification(this.context, ct.getCurrentPath(), ct.getOriginalPath(), ct.getItem(), type));
                    modifiedItems.add(ct.getItem().getItemId());
                }
            }
        }
        Iterator<Map.Entry<UUID, LocalChange>> i = this.localChanges.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<UUID, LocalChange> e = i.next();
            if (modifiedItems.contains(e.getKey())) continue;
            e.getValue().cancel();
            e.getValue().getNode().removeChange(e.getValue());
            this.changeCanceled(e.getValue());
            i.remove();
        }
        for (LocalChange c : localChanges) {
            LocalChange oldChange = this.localChanges.get(c.getItemId());
            if (oldChange != null) {
                if (c.equals(oldChange)) continue;
                oldChange.cancel();
                oldChange.getNode().removeChange(oldChange);
                this.changeCanceled(oldChange);
            }
            LocalChangeNode node = this.changeTree.getNode(c.getPath(), true);
            LocalChangeTracker.setNode(node, c);
            this.localChanges.put(c.getItemId(), c);
            this.changeOccurred(c);
        }
    }

    public static void computePendingChanges(IShareable root, ILocalChangeManager.RefreshType traversalType, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<FileSystemException> exceptions = new ArrayList<FileSystemException>();
        LocalChangeTracker tracker = null;
        ICopyFileAreasLock lock = ICopyFileAreaManager.instance.lock(Collections.singleton(ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(root))), (IProgressMonitor)progress.newChild(1));
        try {
            Share share = (Share)root.getShare((IProgressMonitor)progress.newChild(1));
            IComponentHandle component = share.getSharingDescriptor().getComponent();
            if (share == null || !CFALockUtil.isLockedForUpdate(share.getSandbox().getRoot(), component, share.getSharingDescriptor().getConnectionHandle())) {
                return;
            }
            tracker = share.getTracker();
            CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(root.getSandbox().getRoot());
            ArrayList<IShareable> toVisit = new ArrayList<IShareable>();
            toVisit.add(root);
            do {
                progress.setWorkRemaining(98);
                ArrayList<IShareable> toDelete = new ArrayList<IShareable>();
                Shareable next = (Shareable)toVisit.remove(toVisit.size() - 1);
                next.accept(new LocalChangeVisitor(share, exceptions, traversalType, toDelete, toVisit, root, cfa, component), Integer.MAX_VALUE, true, true, (IProgressMonitor)progress.newChild(68));
                SubMonitor subProgress = progress.newChild(10);
                subProgress.setWorkRemaining(toDelete.size());
                for (IShareable shareable : toDelete) {
                    try {
                        IRelativeLocation shareablePath = shareable.getLocalPath();
                        FileItemInfo info = cfa.getItemInfo(shareablePath);
                        if (info != null) {
                            if (info.getParent() == null) {
                                ((Shareable)shareable).forget((IProgressMonitor)subProgress.newChild(1));
                                continue;
                            }
                            cfa.deleteTreeInfo(shareable.getLocalPath(), false, (IProgressMonitor)subProgress.newChild(1));
                            continue;
                        }
                        cfa.deleteTreeInfo(shareable.getLocalPath(), false, (IProgressMonitor)subProgress.newChild(1));
                    }
                    catch (FileSystemException e) {
                        exceptions.add(e);
                    }
                }
                subProgress.done();
            } while (!toVisit.isEmpty());
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.LocalChangeTracker_11, null);
                for (FileSystemException ex : exceptions) {
                    multi.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)ex)));
                }
                throw new FileSystemStatusException((IStatus)multi);
            }
        }
        finally {
            lock.release((IProgressMonitor)progress.newChild(1));
            if (tracker != null) {
                tracker.computeChangesjob.requestRefresh();
            }
            progress.done();
        }
    }

    public LocalChangeContext getContext() {
        return this.context;
    }

    public void metadataChanged() {
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatelessVersionable(long hashedAt, IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            DateRecord rec = new DateRecord(handle, component, connection);
            this.needDates.remove(rec);
            this.needDates.put(rec, hashedAt);
        }
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDatelessVersionable(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            DateRecord rec = new DateRecord(handle, component, connection);
            this.needDates.remove(rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatelessVersionable(long hashedAt, IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        Long oldDate;
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            oldDate = this.needDates.get(new DateRecord(handle, component, connection));
        }
        return oldDate != null && oldDate == hashedAt;
    }

    public void shutdown() {
        this.computeChangesjob.cancel();
    }

    private static class DateRecord {
        IVersionableHandle versionable;
        IComponentHandle component;
        IContextHandle connection;

        DateRecord(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
            this.versionable = handle;
            this.component = component;
            this.connection = connection;
        }

        public int hashCode() {
            return this.versionable.getItemId().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof DateRecord)) {
                return false;
            }
            DateRecord other = (DateRecord)o;
            return this.versionable.sameItemId((IItemHandle)other.versionable) && this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
        }

        public String toString() {
            return "DateRecord(" + this.versionable.toString() + ")";
        }
    }

    private static final class DefaultSchedulingRule
    implements ISchedulingRule {
        private DefaultSchedulingRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof DefaultSchedulingRule;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof DefaultSchedulingRule;
        }
    }

    public static class LocalChangeVisitor
    implements IShareableVisitor {
        private final List<IShareable> toDelete;
        private final IShareable root;
        private final List<IShareable> toVisit;
        private final ILocalChangeManager.RefreshType traversalType;
        private final Share share;
        private final List<FileSystemException> exceptions;
        private final CopyFileArea cfa;
        private final IComponentHandle component;

        public LocalChangeVisitor(Share share, List<FileSystemException> exceptions, ILocalChangeManager.RefreshType traversalType, List<IShareable> toDelete, List<IShareable> toVisit, IShareable root, CopyFileArea cfa, IComponentHandle component) {
            this.toDelete = toDelete;
            this.root = root;
            this.toVisit = toVisit;
            this.traversalType = traversalType;
            this.share = share;
            this.exceptions = exceptions;
            this.cfa = cfa;
            this.component = component;
        }

        @Override
        public IComponentHandle getComponent() {
            return this.component;
        }

        @Override
        public boolean visit(IShareable shareable, IProgressMonitor progress) {
            ResourceType type;
            FileItemInfo parentInfo;
            IFileStorage parent;
            IFileStorage fileStorage;
            SubMonitor monitor;
            block53: {
                block54: {
                    monitor = SubMonitor.convert((IProgressMonitor)progress, (int)6);
                    try {
                        if (shareable.shouldBeIgnored((IProgressMonitor)monitor.newChild(1))) {
                            return false;
                        }
                    }
                    catch (FileSystemException e) {
                        this.exceptions.add(e);
                    }
                    try {
                        if (!shareable.getShare((IProgressMonitor)monitor.newChild(1)).getSharingDescriptor().getComponent().sameItemId((IItemHandle)this.component)) {
                            return false;
                        }
                    }
                    catch (FileSystemException e) {
                        this.exceptions.add(e);
                    }
                    fileStorage = ((Shareable)shareable).getFileStorage();
                    if (!fileStorage.isRepositoryProviderRegistered((IProgressMonitor)monitor.newChild(1))) break block53;
                    if (this.traversalType != ILocalChangeManager.RefreshType.OPTIMIZED_TRAVERSAL) break block54;
                    return false;
                }
                try {
                    if (this.traversalType == ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN && (this.root.equals(shareable) || fileStorage.getIDEPath().segmentCount() == 1)) {
                        SharingManager.getInstance().doSilentChange(new SharingManager.FileSystemAccessor(){

                            @Override
                            public void run() throws FileSystemException {
                                fileStorage.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
                            }
                        });
                    }
                }
                catch (FileSystemException e) {
                    this.exceptions.add(e);
                }
            }
            monitor.subTask(NLS.bind((String)Messages.LocalChangeTracker_RecomputeChangesForPath, (Object)shareable.getLocalPath().toString()));
            Shareable parentShareable = (Shareable)((Shareable)shareable).getParent();
            if (parentShareable != null) {
                parent = parentShareable.getFileStorage();
                parentInfo = this.cfa.getItemInfo(parentShareable.getLocalPath());
                if (parentInfo == null) {
                    try {
                        ManagedFileStore.createFolderHierarchyUpToParentOf(shareable.getLocalPath(), this.share, this.cfa, false, (IProgressMonitor)monitor.newChild(1));
                        parentInfo = this.cfa.getItemInfo(parentShareable.getLocalPath());
                    }
                    catch (CoreException e) {
                        this.exceptions.add(FileSystemStatusException.fromCoreException(e.getMessage(), e));
                    }
                    catch (FileSystemException e) {
                        this.exceptions.add(e);
                    }
                }
            } else {
                parent = null;
                parentInfo = null;
            }
            try {
                type = shareable.getResourceType((IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemException e) {
                this.exceptions.add(e);
                return false;
            }
            if (parent == null && type == ResourceType.FOLDER) {
                return true;
            }
            if (type == null) {
                this.toDelete.add(shareable);
                return false;
            }
            FileItemInfo info = this.cfa.getItemInfo(shareable.getLocalPath());
            if (parent != null && info != null && (type == ResourceType.SYMBOLIC_LINK != info.isSymbolicLink() || !info.isSymbolicLink() && info.isFolder() != (type == ResourceType.FOLDER))) {
                this.toDelete.add(shareable);
                this.toVisit.add(shareable);
                return false;
            }
            if (parent != null && info == null && parentInfo != null && !(parentInfo.getVersionableHandle() instanceof ISymbolicLinkHandle)) {
                try {
                    if (type == ResourceType.SYMBOLIC_LINK) {
                        this.cfa.trackSymbolicLinkAddition((IFolderHandle)parentInfo.getVersionableHandle(), shareable, (IProgressMonitor)monitor.newChild(1));
                    } else if (type == ResourceType.FOLDER) {
                        this.cfa.trackFolderAddition((IFolderHandle)parentInfo.getVersionableHandle(), shareable, (IProgressMonitor)monitor.newChild(1));
                    } else if (type == ResourceType.FILE) {
                        this.cfa.trackFileAddition((IFolderHandle)parentInfo.getVersionableHandle(), shareable, (IProgressMonitor)monitor.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    this.exceptions.add(e);
                }
            } else if (info != null && info.isFile() && info.getHash() != null) {
                long modStamp;
                SubMonitor folderMon = monitor.newChild(1).setWorkRemaining(100);
                boolean contentChange = info.isContentChanged();
                boolean isExecutable = info.isExecutable();
                try {
                    try {
                        SharingManager.getInstance().disableChangeMonitoring();
                        modStamp = fileStorage.getModificationStamp();
                        if (fileStorage.supportsExecBit()) {
                            isExecutable = fileStorage.isExecutable((IProgressMonitor)folderMon.newChild(25));
                            folderMon.setWorkRemaining(100);
                        }
                        ISharingDescriptor desc = this.share.getSharingDescriptor();
                        InverseFileItemInfo itemInfo = this.cfa.getItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), true);
                        contentChange = fileStorage.isContentChangedFrom(info, new MetadataProperties(itemInfo.getOriginalProperties(), itemInfo.getChangedProperties(), itemInfo.getRemovedProperties()).getCurrentProperties(), (IProgressMonitor)folderMon.newChild(50));
                    }
                    catch (ContentRetrievalFailure contentRetrievalFailure) {
                        SharingManager.getInstance().enableChangeMonitoring();
                        return true;
                    }
                    catch (FileSystemException e) {
                        this.exceptions.add(e);
                        SharingManager.getInstance().enableChangeMonitoring();
                        return true;
                    }
                }
                finally {
                    SharingManager.getInstance().enableChangeMonitoring();
                }
                boolean nameChange = false;
                if (!this.cfa.isCaseSensitive()) {
                    ISharingDescriptor desc = this.share.getSharingDescriptor();
                    InverseFileItemInfo itemInfo = this.cfa.getItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), true);
                    boolean bl = nameChange = !itemInfo.getLocalName().equals(shareable.getLocalPath().getName());
                }
                if (info.getLastContentChangeCheckStamp() != modStamp || contentChange != info.isContentChanged() || isExecutable != info.isExecutable() || nameChange) {
                    FileItemInfo touchedInfo = new FileItemInfo(info.getVersionableHandle(), contentChange, modStamp, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), isExecutable, info.isOriginalExecutable(), false, false);
                    folderMon.setWorkRemaining(100);
                    try {
                        this.cfa.setItemMetaData(shareable.getLocalPath(), touchedInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)folderMon.newChild(100));
                    }
                    catch (FileSystemException e) {
                        this.exceptions.add(e);
                    }
                }
                progress.done();
            } else if (info != null && info.isSymbolicLink() && info.getHash() != null) {
                try {
                    LinkInfo diskInfo = fileStorage.getLinkInfo((IProgressMonitor)monitor.newChild(1));
                    boolean directoryLink = LinkType.NONE == diskInfo.getType() ? info.isDirectoryLink() : LinkType.DIRECTORY == diskInfo.getType();
                    boolean contentChanged = CopyFileArea.contentChanged(info, diskInfo, (IProgressMonitor)monitor.newChild(1));
                    if (contentChanged != info.isContentChanged() || directoryLink != info.isDirectoryLink()) {
                        FileItemInfo touchedInfo = new FileItemInfo((ISymbolicLinkHandle)info.getVersionableHandle(), contentChanged, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getStoredHash(), directoryLink, info.isOriginalDirectoryLink());
                        this.cfa.setItemMetaData(shareable.getLocalPath(), touchedInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)monitor.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    this.exceptions.add(e);
                }
            } else if (info != null && info.isFolder() && !this.cfa.isCaseSensitive()) {
                ISharingDescriptor desc = this.share.getSharingDescriptor();
                InverseFileItemInfo itemInfo = this.cfa.getItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), true);
                if (!itemInfo.getLocalName().equals(shareable.getLocalPath().getName())) {
                    FileItemInfo touchedInfo = new FileItemInfo((IFolderHandle)info.getVersionableHandle(), info.getParent(), info.getName(), info.isLoadedWithAnotherName());
                    try {
                        this.cfa.setItemMetaData(shareable.getLocalPath(), touchedInfo, ICopyFileArea.PropertyUpdate.PRESERVE, null, (IProgressMonitor)monitor.newChild(1));
                    }
                    catch (FileSystemException e) {
                        this.exceptions.add(e);
                    }
                }
            }
            return true;
        }
    }

    class LocalChangesComputer
    extends Job {
        volatile long lastRecompute;
        volatile long lastRequest;

        public LocalChangesComputer(ISchedulingRule rule) {
            super(Messages.LocalChangeTracker_1);
            this.setPriority(30);
            this.setRule(rule);
            this.setSystem(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AbstractLock rule = CFALockUtil.lockExistingForUpdate(LocalChangeTracker.this.context.getRoot(), LocalChangeTracker.this.context.getConnection(), LocalChangeTracker.this.context.getComponent(), (IProgressMonitor)progress.newChild(1));
                try {
                    long time = System.nanoTime();
                    long lastReq = this.lastRequest;
                    long remaining = (lastReq + 200000000L - time) / 1000000L;
                    if (remaining > 5L) {
                        this.schedule(remaining);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (rule == null) return Status.OK_STATUS;
                    this.runRecompute((IProgressMonitor)progress.newChild(98));
                    return Status.OK_STATUS;
                }
                finally {
                    if (rule != null) {
                        CFALockUtil.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                    }
                    progress.done();
                }
            }
            catch (FileSystemException e) {
                return FileSystemStatusUtil.getStatusFor((Throwable)((Object)e));
            }
        }

        public boolean belongsTo(Object family) {
            return family == CHANGES_COMPUTER_JOB_FAMILY;
        }

        public void requestRefresh() {
            this.lastRequest = System.nanoTime();
            if (this.getState() == 4) {
                this.cancel();
            }
            this.schedule(200L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRecompute(IProgressMonitor monitor) throws FileSystemException {
            this.lastRecompute = System.nanoTime();
            try {
                LocalChangeTracker localChangeTracker = LocalChangeTracker.this;
                synchronized (localChangeTracker) {
                    LocalChangeTracker.this.refreshPendingChanges(monitor);
                }
            }
            catch (FileSystemException e) {
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(LocalChangeTracker.this.context.getRoot());
                if (cfa.isCorrupted()) {
                    return;
                }
                throw e;
            }
            catch (RuntimeException e) {
                CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(LocalChangeTracker.this.context.getRoot());
                if (cfa.isCorrupted()) {
                    return;
                }
                throw e;
            }
        }

        public void rejoin(AbstractLock rule, IProgressMonitor monitor) {
            if (CFALockUtil.isLockedForUpdate(LocalChangeTracker.this.context.getRoot(), LocalChangeTracker.this.context.getComponent(), LocalChangeTracker.this.context.getConnection())) {
                this.cancel();
                if (this.lastRequest <= this.lastRecompute) {
                    return;
                }
                try {
                    this.runRecompute(monitor);
                }
                catch (FileSystemException e) {
                    LoggingHelper.log("com.ibm.team.filesystem.client", e);
                }
            } else {
                if (rule != null) {
                    throw new IllegalStateException("Caller indicated (" + rule.toString() + ") is locked but current context found no lock (" + LocalChangeTracker.this.context.toString() + ")");
                }
                while (true) {
                    if (this.getState() == 0) {
                        if (this.lastRequest <= this.lastRecompute) {
                            return;
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

