/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CreateBaselineDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICreateBaselineOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class CreateBaselineOperation
extends ChangeHistoryChangeSetsOperation
implements ICreateBaselineOperation {
    private Map<ConfigurationFacade, CreateBaselineRequest> requests = new HashMap<ConfigurationFacade, CreateBaselineRequest>();
    private List<IBaselineConnection> baselines = new ArrayList<IBaselineConnection>();
    private CreateBaselineDilemmaHandler problemHandler;

    public CreateBaselineOperation(CreateBaselineDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? CreateBaselineDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    public void createBaselineRequest(IWorkspaceConnection workspace, IComponentHandle componentHandle, String name, String comment) {
        if (workspace == null) {
            throw new IllegalArgumentException("missing workspace");
        }
        if (componentHandle == null) {
            throw new IllegalArgumentException("missing component");
        }
        CreateBaselineRequest request = new CreateBaselineRequest();
        request.workspace = workspace;
        request.componentHandle = componentHandle;
        request.name = name;
        request.comment = comment;
        this.requests.put(new ConfigurationFacade((IConnection)workspace, componentHandle), request);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreateBaselineOperation_0, (int)(20 + 30 * this.requests.size()));
        ArrayList determinants = new ArrayList();
        HashSet<ConfigurationFacade> affectedConfigurations = new HashSet<ConfigurationFacade>();
        affectedConfigurations.addAll(this.requests.keySet());
        HashSet<ConfigurationFacade> affectedSubcomponents = new HashSet<ConfigurationFacade>();
        HashSet<ConfigurationFacade> inaccessibleSubcomponents = new HashSet<ConfigurationFacade>();
        HashSet<ConfigurationFacade> subcomponentsNotInWorkspace = new HashSet<ConfigurationFacade>();
        this.getConfigurationsForSubcomponents(affectedConfigurations, affectedSubcomponents, inaccessibleSubcomponents, subcomponentsNotInWorkspace, (IProgressMonitor)progress.newChild(10));
        HashSet<ConfigurationFacade> lockedConfigurations = new HashSet<ConfigurationFacade>();
        lockedConfigurations.addAll(affectedConfigurations);
        lockedConfigurations.addAll(affectedSubcomponents);
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(lockedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            this.runPreConditions(affectedConfigurations, affectedSubcomponents, inaccessibleSubcomponents, subcomponentsNotInWorkspace, (IProgressMonitor)progress.newChild(9));
            Map<BatchGroup, Collection<IComponentHandle>> batchedRequests = this.calculateBatchGroups(this.requests.values());
            for (Map.Entry<BatchGroup, Collection<IComponentHandle>> entry : batchedRequests.entrySet()) {
                BatchGroup batchGroup = entry.getKey();
                if (entry.getValue().size() == 1) {
                    IComponentHandle component = entry.getValue().iterator().next();
                    this.baselines.add(batchGroup.getWorkspaceConnection().createBaseline(component, batchGroup.getName(), batchGroup.getComment(), (IProgressMonitor)progress.newChild(30)));
                } else if (entry.getValue().size() > 1) {
                    this.baselines.addAll(batchGroup.getWorkspaceConnection().createMultipleBaselines(entry.getValue(), batchGroup.getName(), batchGroup.getComment(), (IProgressMonitor)progress.newChild(30)));
                }
                this.checkCancelled((IProgressMonitor)progress);
            }
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
            progress.done();
        }
    }

    private Map<BatchGroup, Collection<IComponentHandle>> calculateBatchGroups(Collection<CreateBaselineRequest> baselineRequests) {
        HashMap<BatchGroup, Collection<IComponentHandle>> batchedRequests = new HashMap<BatchGroup, Collection<IComponentHandle>>();
        if (baselineRequests != null) {
            for (CreateBaselineRequest request : baselineRequests) {
                BatchGroup batchGroup = new BatchGroup(request.workspace, request.name, request.comment);
                ArrayList<IComponentHandle> components = (ArrayList<IComponentHandle>)batchedRequests.get(batchGroup);
                if (components == null) {
                    components = new ArrayList<IComponentHandle>();
                }
                components.add(request.componentHandle);
                batchedRequests.put(batchGroup, components);
            }
        }
        return batchedRequests;
    }

    private void runPreConditions(Set<ConfigurationFacade> affectedConfigurations, Set<ConfigurationFacade> affectedSubcomponents, Set<ConfigurationFacade> inaccessibleSubcomponents, Set<ConfigurationFacade> subcomponentsNotInWorkspace, IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + (affectedSubcomponents.isEmpty() ? 0 : 50) + (inaccessibleSubcomponents.isEmpty() ? 0 : 10) + (subcomponentsNotInWorkspace.isEmpty() ? 0 : 10)));
        try {
            if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
                IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
                for (ConfigurationFacade configuration : affectedConfigurations) {
                    verifyOp.addToVerify(configuration.getConnection((IProgressMonitor)progress.newChild(10)), configuration.getComponentHandle());
                }
                for (ConfigurationFacade configuration : affectedSubcomponents) {
                    verifyOp.addToVerify(configuration.getConnection((IProgressMonitor)progress.newChild(10)), configuration.getComponentHandle());
                }
                verifyOp.run((IProgressMonitor)progress.newChild(30));
            }
            progress.setWorkRemaining(50 + (affectedSubcomponents.isEmpty() ? 0 : 50) + (inaccessibleSubcomponents.isEmpty() ? 0 : 10) + (subcomponentsNotInWorkspace.isEmpty() ? 0 : 10));
            this.checkinPendingChanges(affectedConfigurations, this.problemHandler, false, (IProgressMonitor)progress.newChild(45));
            this.checkingConflicts((IProgressMonitor)progress.newChild(5));
            if (!(affectedSubcomponents.isEmpty() && inaccessibleSubcomponents.isEmpty() && subcomponentsNotInWorkspace.isEmpty())) {
                this.checkingConflictsInSubcomponents(affectedSubcomponents, (IProgressMonitor)progress.newChild(5));
                if (!inaccessibleSubcomponents.isEmpty()) {
                    int direction = this.problemHandler.inaccessibleSubcomponents(inaccessibleSubcomponents, (IProgressMonitor)progress.newChild(10));
                    if (direction == 1) {
                        throw new OperationCanceledException();
                    }
                    if (direction != 0) {
                        throw new FileSystemException(Messages.CreateBaselineOperation_4);
                    }
                }
                if (!subcomponentsNotInWorkspace.isEmpty()) {
                    int direction = this.problemHandler.subcomponentsNotInWorkspace(subcomponentsNotInWorkspace, (IProgressMonitor)progress.newChild(10));
                    if (direction == 1) {
                        throw new OperationCanceledException();
                    }
                    if (direction != 0) {
                        throw new FileSystemException(Messages.CreateBaselineOperation_5);
                    }
                }
                this.checkingActiveChangeSetsInSubcomponents(affectedSubcomponents, (IProgressMonitor)progress.newChild(5));
                this.checkinPendingChanges(affectedSubcomponents, this.problemHandler, false, true, (IProgressMonitor)progress.newChild(40));
            }
        }
        finally {
            progress.done();
        }
    }

    private void checkingActiveChangeSetsInSubcomponents(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws FileSystemException {
        HashMap<ConfigurationFacade, Collection<IChangeSetHandle>> handles = new HashMap<ConfigurationFacade, Collection<IChangeSetHandle>>();
        for (ConfigurationFacade configuration : affectedConfigurations) {
            IWorkspaceConnection connection;
            List activeChangeSets;
            IConnection cachedConnection = configuration.getCachedConnection();
            if (!(cachedConnection instanceof IWorkspaceConnection) || (activeChangeSets = (connection = (IWorkspaceConnection)cachedConnection).activeChangeSets(configuration.getComponentHandle())).isEmpty()) continue;
            handles.put(configuration, activeChangeSets);
        }
        if (!handles.isEmpty()) {
            int direction = this.problemHandler.activeChangeSetsInSubcomponents(handles, monitor);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction != 0) {
                throw new FileSystemException(Messages.CreateBaselineOperation_2);
            }
        }
    }

    private void checkingConflicts(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        HashSet<ConfigurationFacade> conflictedConfigurations = new HashSet<ConfigurationFacade>();
        for (Map.Entry<ConfigurationFacade, CreateBaselineRequest> entry : this.requests.entrySet()) {
            CreateBaselineRequest request = entry.getValue();
            if (request.workspace.conflictReport(request.componentHandle).conflicts().isEmpty()) continue;
            conflictedConfigurations.add(entry.getKey());
        }
        if (!conflictedConfigurations.isEmpty()) {
            int direction = this.problemHandler.conflictedConfigurations(conflictedConfigurations, monitor);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            if (direction == 0) {
                for (ConfigurationFacade configurationToSkip : conflictedConfigurations) {
                    this.requests.remove((Object)configurationToSkip);
                }
            } else {
                throw new FileSystemException(Messages.CreateBaselineOperation_1);
            }
        }
    }

    private void checkingConflictsInSubcomponents(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        HashSet<ConfigurationFacade> conflictedConfigurations = new HashSet<ConfigurationFacade>();
        for (ConfigurationFacade configuration : affectedConfigurations) {
            IWorkspaceConnection connection;
            IConnection cachedConnection = configuration.getCachedConnection();
            if (!(cachedConnection instanceof IWorkspaceConnection) || (connection = (IWorkspaceConnection)cachedConnection).conflictReport(configuration.getComponentHandle()).conflicts().isEmpty()) continue;
            conflictedConfigurations.add(configuration);
        }
        if (!conflictedConfigurations.isEmpty()) {
            int direction = this.problemHandler.conflictedConfigurationsInSubcomponents(conflictedConfigurations, monitor);
            if (direction == 1) {
                throw new OperationCanceledException();
            }
            throw new FileSystemException(Messages.CreateBaselineOperation_3);
        }
    }

    @Override
    public Collection<IBaselineConnection> getBaselinesCreated() {
        return this.baselines;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CreateBaselineOperation_REFRESHING_LOCAL_FILESYSTEM, (int)affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationFacade>> entry : affectedAreas.entrySet()) {
            IShare[] iShareArray = entry.getKey().allShares((IProgressMonitor)progress);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                refresher.addToRefresh(share.getShareable());
                ++n2;
            }
        }
    }

    protected void getConfigurationsForSubcomponents(Set<ConfigurationFacade> affectedConfigurations, Set<ConfigurationFacade> configurationsForSubComponents, Set<ConfigurationFacade> inaccessibleSubcomponents, Set<ConfigurationFacade> subcomponentsNotInWorkspace, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceConnection connection;
        HashMap<IWorkspaceConnection, HashMap<UUID, IComponentHandle>> requests = new HashMap<IWorkspaceConnection, HashMap<UUID, IComponentHandle>>();
        for (ConfigurationFacade facade : affectedConfigurations) {
            IConnection cachedConnection = facade.getCachedConnection();
            if (!(cachedConnection instanceof IWorkspaceConnection)) continue;
            connection = (IWorkspaceConnection)cachedConnection;
            HashMap<UUID, IComponentHandle> components = (HashMap<UUID, IComponentHandle>)requests.get(connection);
            if (components == null) {
                components = new HashMap<UUID, IComponentHandle>();
                requests.put(connection, components);
            }
            components.put(facade.getComponentHandle().getItemId(), facade.getComponentHandle());
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(requests.size() * 2));
        for (Map.Entry entry : requests.entrySet()) {
            connection = (IWorkspaceConnection)entry.getKey();
            HashSet<UUID> componentsInWorkspace = new HashSet<UUID>();
            for (Object o : connection.getComponents()) {
                if (!(o instanceof IComponentHandle)) continue;
                componentsInWorkspace.add(((IComponentHandle)o).getItemId());
            }
            IComponentHierarchyResult hierarchyResult = connection.getComponentHierarchy(((Map)entry.getValue()).values());
            Map subcomponentsToFetch = hierarchyResult.getFlattenedElementsMap();
            if (!subcomponentsToFetch.isEmpty()) {
                IComponent subcomponent;
                ConfigurationFacade facade;
                IItemManager itemManager = connection.teamRepository().itemManager();
                IFetchResult fetchResult = itemManager.fetchCompleteItemsPermissionAware(new ArrayList(subcomponentsToFetch.values()), 0, (IProgressMonitor)progress.newChild(1));
                for (Object retrievedItem : fetchResult.getRetrievedItems()) {
                    if (!(retrievedItem instanceof IComponent) || affectedConfigurations.contains((Object)(facade = new ConfigurationFacade((IConnection)connection, (IComponentHandle)(subcomponent = (IComponent)retrievedItem))))) continue;
                    if (componentsInWorkspace.contains(subcomponent.getItemId())) {
                        configurationsForSubComponents.add(facade);
                        continue;
                    }
                    subcomponentsNotInWorkspace.add(facade);
                }
                for (Object missingItem : fetchResult.getMissingItems()) {
                    if (!(missingItem instanceof IComponentHandle) || affectedConfigurations.contains((Object)(facade = new ConfigurationFacade((IConnection)connection, (IComponentHandle)(subcomponent = (IComponentHandle)missingItem))))) continue;
                    inaccessibleSubcomponents.add(facade);
                }
                continue;
            }
            progress.worked(1);
        }
    }

    private static class BatchGroup {
        private IWorkspaceConnection wc;
        private String name;
        private String comment;

        public BatchGroup(IWorkspaceConnection wc, String name, String comment) {
            this.wc = wc;
            this.name = name;
            this.comment = comment;
        }

        public IWorkspaceConnection getWorkspaceConnection() {
            return this.wc;
        }

        public String getName() {
            return this.name;
        }

        public String getComment() {
            return this.comment;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.wc == null ? 0 : this.wc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BatchGroup other = (BatchGroup)obj;
            if (this.comment == null ? other.comment != null : !this.comment.equals(other.comment)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.wc == null ? other.wc != null : !this.wc.equals((Object)other.wc));
        }
    }

    private static class CreateBaselineRequest {
        IWorkspaceConnection workspace;
        IComponentHandle componentHandle;
        public String name;
        public String comment;

        private CreateBaselineRequest() {
        }
    }
}

