/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.internal.operations.UnlockOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.client.internal.FlowUtils;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import com.ibm.team.scm.common.internal.dto.impl.ComponentReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ExclusiveFileLockPatternUtil {
    public static final String patternDelimiter = ",";

    public static IWorkspaceConnection getDefaultFlowConnection(IWorkspaceConnection workspaceConnection, IProgressMonitor progress) throws TeamRepositoryException {
        IFlowTable flowTable = workspaceConnection.getFlowTable();
        IFlowEntry flowEntry = flowTable.getDefaultAcceptFlow();
        if (flowEntry == null) {
            return null;
        }
        ITeamRepository targetRepo = workspaceConnection.teamRepository();
        String targetRepoUri = flowEntry.getRemoteRepositoryURI();
        if (targetRepoUri != null) {
            targetRepo = TeamPlatform.getTeamRepositoryService().getTeamRepository(targetRepoUri);
        }
        IFlowNodeHandle flowNodeHandle = flowEntry.getFlowNode();
        IWorkspaceConnection flowConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)targetRepo).getWorkspaceConnection((IWorkspaceHandle)flowNodeHandle, progress);
        return flowConnection;
    }

    public static List<StringMatcher> getPatternsToMatch(IConnection connection, IProgressMonitor progress) {
        String patterns;
        ArrayList<StringMatcher> matchers = new ArrayList<StringMatcher>();
        IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)connection;
        IWorkspaceConnection flowConnection = null;
        try {
            flowConnection = ExclusiveFileLockPatternUtil.getDefaultFlowConnection(workspaceConnection, progress);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (flowConnection != null && (patterns = flowConnection.getExclusiveFileLockPatterns()) != null && patterns.length() > 0) {
            String[] patternList;
            String[] stringArray = patternList = patterns.split(patternDelimiter);
            int n = patternList.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                StringMatcher matcher = new StringMatcher(pattern.trim(), true, false);
                matchers.add(matcher);
                ++n2;
            }
        }
        return matchers;
    }

    public static void makeFileReadOnly(IShareable shareable, List<StringMatcher> matchers) throws FileSystemException {
        File file = (File)shareable.getAdapter(File.class);
        ExclusiveFileLockPatternUtil.makeFileReadOnly(file, matchers, true);
    }

    public static void makeFileWriteable(IShareable shareable, List<StringMatcher> matchers) throws FileSystemException {
        File file = (File)shareable.getAdapter(File.class);
        ExclusiveFileLockPatternUtil.makeFileReadOnly(file, matchers, false);
    }

    private static void makeFileReadOnly(File file, List<StringMatcher> matchers, boolean readonly) throws FileSystemException {
        if (ExclusiveFileLockPatternUtil.patternMatches(file, matchers)) {
            if (readonly) {
                file.setWritable(false, false);
            } else {
                file.setWritable(true);
            }
        }
    }

    private static boolean patternMatches(File file, List<StringMatcher> matchers) {
        if (!file.exists() || file.isDirectory()) {
            return false;
        }
        return ExclusiveFileLockPatternUtil.patternMatches(file.getName(), matchers);
    }

    private static boolean patternMatches(String fileName, List<StringMatcher> matchers) {
        boolean match = false;
        for (StringMatcher matcher : matchers) {
            if (!matcher.match(fileName)) continue;
            match = true;
            break;
        }
        return match;
    }

    public static List<IComponentLockReport> updateComponentLocks(List<IComponentLockReport> componentLocks, ITeamRepository repository, List<IChangeSetHandle> outgoingChangeSetHandles, SubMonitor subMonitor) throws TeamRepositoryException {
        IItemManager itemManager = repository.itemManager();
        List outgoingChangeSets = null;
        try {
            outgoingChangeSets = itemManager.fetchCompleteItems(outgoingChangeSetHandles, 0, (IProgressMonitor)subMonitor);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (outgoingChangeSets == null) {
            return componentLocks;
        }
        HashMap<UUID, ArrayList<UUID>> compToOutgoingVersionables = new HashMap<UUID, ArrayList<UUID>>();
        for (IChangeSet outgoingChangeSet : outgoingChangeSets) {
            for (IChange change : outgoingChangeSet.changes()) {
                UUID compId = outgoingChangeSet.getComponent().getItemId();
                ArrayList<UUID> outgoingVersionables = (ArrayList<UUID>)compToOutgoingVersionables.get(compId);
                if (outgoingVersionables == null) {
                    outgoingVersionables = new ArrayList<UUID>(outgoingChangeSet.changes().size());
                    compToOutgoingVersionables.put(compId, outgoingVersionables);
                }
                outgoingVersionables.add(change.item().getItemId());
            }
        }
        ArrayList<IComponentLockReport> updatedComponentLockReports = new ArrayList<IComponentLockReport>();
        for (IComponentLockReport componentLockReport : componentLocks) {
            List outgoingCompVersionables = (List)compToOutgoingVersionables.get(componentLockReport.getComponent().getItemId());
            ArrayList<IVersionableLock> updatedVersionableLocks = new ArrayList<IVersionableLock>();
            for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                if (outgoingCompVersionables != null && outgoingCompVersionables.contains(versionableLock.getVersionable().getItemId())) continue;
                updatedVersionableLocks.add(versionableLock);
            }
            if (updatedVersionableLocks.size() <= 0) continue;
            updatedComponentLockReports.add((IComponentLockReport)new ComponentReport(componentLockReport.getComponent(), updatedVersionableLocks));
        }
        return updatedComponentLockReports;
    }

    public static Map<IStreamLockReport, IWorkspaceConnection> updateComponentLocks(IWorkspaceConnection workspaceConnection, Map<IStreamLockReport, IWorkspaceConnection> lockReport, SubMonitor monitor) throws TeamRepositoryException {
        if (lockReport.size() == 0) {
            return lockReport;
        }
        IStreamLockReport streamLockReport = lockReport.keySet().iterator().next();
        IWorkspaceConnection targetWorkspaceConnection = lockReport.values().iterator().next();
        HashMap<UUID, IComponentHandle> componentHandles = new HashMap<UUID, IComponentHandle>();
        for (IComponentLockReport componentLockReport : streamLockReport.getComponentLocks()) {
            componentHandles.put(componentLockReport.getComponent().getItemId(), componentLockReport.getComponent());
        }
        if (componentHandles.size() == 0) {
            return lockReport;
        }
        HashMap<UUID, IWorkspaceConnection> targetConnections = new HashMap<UUID, IWorkspaceConnection>();
        HashMap<IWorkspaceConnection, ArrayList<IComponentHandle>> componentTargetConnections = new HashMap<IWorkspaceConnection, ArrayList<IComponentHandle>>();
        for (IComponentHandle componentHandle : componentHandles.values()) {
            IWorkspaceHandle acceptFlowHandle;
            IWorkspaceConnection targetConnection;
            IFlowEntry flowEntry = workspaceConnection.getFlowTable().getCurrentAcceptFlow(componentHandle);
            if (flowEntry == null) {
                flowEntry = workspaceConnection.getFlowTable().getCurrentAcceptFlow();
            }
            if (flowEntry == null || (targetConnection = (IWorkspaceConnection)targetConnections.get((acceptFlowHandle = (IWorkspaceHandle)flowEntry.getFlowNode()).getItemId())) != null) continue;
            String remoteRepoUri = flowEntry.getRemoteRepositoryURI();
            ITeamRepository componentTargetRepo = remoteRepoUri != null ? TeamPlatform.getTeamRepositoryService().getTeamRepository(remoteRepoUri) : workspaceConnection.teamRepository();
            IWorkspaceConnection componentTargetConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)componentTargetRepo).getWorkspaceConnection(acceptFlowHandle, (IProgressMonitor)monitor.newChild(1));
            targetConnections.put(acceptFlowHandle.getItemId(), componentTargetConnection);
            ArrayList<IComponentHandle> targetComponentHandles = (ArrayList<IComponentHandle>)componentTargetConnections.get(componentTargetConnection);
            if (targetComponentHandles == null) {
                targetComponentHandles = new ArrayList<IComponentHandle>();
                componentTargetConnections.put(componentTargetConnection, targetComponentHandles);
            }
            targetComponentHandles.add(componentHandle);
        }
        ArrayList<IChangeSetHandle> outgoingChangeSetHandles = new ArrayList<IChangeSetHandle>();
        List workspaceComponentHandles = workspaceConnection.getComponents();
        for (Map.Entry entry : componentTargetConnections.entrySet()) {
            ArrayList toExclude = new ArrayList(workspaceComponentHandles);
            block3: for (IComponentHandle componentHandle : (List)entry.getValue()) {
                Iterator iterator = toExclude.iterator();
                while (iterator.hasNext()) {
                    IComponentHandle componentToMatch = (IComponentHandle)iterator.next();
                    if (!componentToMatch.getItemId().equals((Object)componentHandle.getItemId())) continue;
                    iterator.remove();
                    continue block3;
                }
            }
            if (workspaceComponentHandles.size() == toExclude.size()) continue;
            IChangeHistorySyncReport syncReport = workspaceConnection.compareTo((IFlowNodeConnection)entry.getKey(), 0, toExclude, (IProgressMonitor)monitor.newChild(5));
            outgoingChangeSetHandles.addAll(syncReport.outgoingChangeSets());
        }
        if (outgoingChangeSetHandles.size() == 0) {
            return lockReport;
        }
        List<IComponentLockReport> componentLocks = ExclusiveFileLockPatternUtil.updateComponentLocks(new ArrayList<IComponentLockReport>(streamLockReport.getComponentLocks()), workspaceConnection.teamRepository(), outgoingChangeSetHandles, monitor.newChild(10));
        if (componentLocks.size() == 0) {
            return null;
        }
        HashMap<IStreamLockReport, IWorkspaceConnection> updatedLockReport = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        updatedLockReport.put(IStreamLockReport.FACTORY.createInstance((IWorkspaceHandle)targetWorkspaceConnection.getResolvedWorkspace(), componentLocks), targetWorkspaceConnection);
        return updatedLockReport;
    }

    public static void refreshFileAttributes(Collection<ConfigurationFacade> affectedConfigurations, Map<IWorkspaceConnection, List<IChangeSet>> workspaceToDeliveredChangeSets, Map<IWorkspaceConnection, List<IFlowNodeConnection.IComponentOp>> workspaceComponentOps, boolean readonly, SubMonitor progress) throws TeamRepositoryException {
        List<StringMatcher> matchers;
        ISandbox sandbox;
        Map<ISandbox, Set<ConfigurationFacade>> affectedAreas = ExclusiveFileLockPatternUtil.getCopyFileAreasAffected((Set)affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        if (affectedAreas == null || affectedAreas.size() == 0) {
            return;
        }
        HashMap<IWorkspaceConnection, List<StringMatcher>> workspaceFileMatchers = new HashMap<IWorkspaceConnection, List<StringMatcher>>();
        if (workspaceComponentOps.size() > 0) {
            for (Map.Entry<IWorkspaceConnection, List<IFlowNodeConnection.IComponentOp>> entry : workspaceComponentOps.entrySet()) {
                sandbox = ExclusiveFileLockPatternUtil.getSandbox(affectedAreas, entry.getKey(), progress);
                if (sandbox == null) continue;
                matchers = (List<StringMatcher>)workspaceFileMatchers.get(entry.getKey());
                if (matchers == null) {
                    matchers = ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)entry.getKey(), (IProgressMonitor)progress);
                    if (matchers.size() == 0) continue;
                    workspaceFileMatchers.put(entry.getKey(), matchers);
                }
                IShare[] shares = sandbox.allShares((IProgressMonitor)progress);
                for (IFlowNodeConnection.IComponentOp componentOp : entry.getValue()) {
                    if (!(componentOp instanceof IFlowNodeConnection.IComponentAdditionOp) && !(componentOp instanceof IFlowNodeConnection.IComponentReplacementOp)) continue;
                    IShare[] iShareArray = shares;
                    int n = shares.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IShare share = iShareArray[n2];
                        ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                        if (sharingDescriptor != null && sharingDescriptor.getComponent().getItemId().equals((Object)componentOp.getComponent().getItemId())) {
                            ExclusiveFileLockPatternUtil.refreshFileAttributes(new File(share.getShareable().getFullPath().toString()), matchers, readonly);
                        }
                        ++n2;
                    }
                }
            }
        }
        if (workspaceToDeliveredChangeSets.size() > 0) {
            for (Map.Entry<IWorkspaceConnection, List<IFlowNodeConnection.IComponentOp>> entry : workspaceToDeliveredChangeSets.entrySet()) {
                sandbox = ExclusiveFileLockPatternUtil.getSandbox(affectedAreas, entry.getKey(), progress);
                if (sandbox == null) continue;
                matchers = (List<StringMatcher>)workspaceFileMatchers.get(entry.getKey());
                if (matchers == null) {
                    matchers = ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)entry.getKey(), (IProgressMonitor)progress);
                    if (matchers.size() == 0) continue;
                    workspaceFileMatchers.put(entry.getKey(), matchers);
                }
                ExclusiveFileLockPatternUtil.refreshFileAttributes(sandbox, entry.getKey(), entry.getValue(), matchers, readonly, progress);
            }
        }
    }

    public static ISandbox getSandbox(Map<ISandbox, Set<ConfigurationFacade>> affectedAreas, IWorkspaceConnection workspaceConnection, SubMonitor progress) throws TeamRepositoryException {
        ISandbox sandbox = null;
        for (ISandbox sb : affectedAreas.keySet()) {
            for (ConfigurationFacade configFacade : affectedAreas.get(sb)) {
                IWorkspaceConnection connection = configFacade.getWorkspaceConnection((IProgressMonitor)progress.newChild(1));
                if (connection == null || !connection.equals((Object)workspaceConnection)) continue;
                sandbox = sb;
            }
        }
        return sandbox;
    }

    public static void refreshFileAttributes(File file, List<StringMatcher> matchers, boolean readonly) throws FileSystemException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                ExclusiveFileLockPatternUtil.refreshFileAttributes(child, matchers, readonly);
                ++n2;
            }
        } else {
            ExclusiveFileLockPatternUtil.makeFileReadOnly(file, matchers, readonly);
        }
    }

    public static void refreshFileAttributes(ISandbox sandbox, IWorkspaceConnection workspaceConnection, List<IChangeSet> changeSets, List<StringMatcher> matchers, boolean readonly, SubMonitor progress) throws TeamRepositoryException {
        Map<UUID, Set<UUID>> componentToVersionableLocks = ExclusiveFileLockPatternUtil.getLocksHeldByUser(workspaceConnection, (IProgressMonitor)progress.newChild(10));
        ArrayList<UUID> processedVersionables = new ArrayList<UUID>();
        for (IChangeSet changeSet : changeSets) {
            Set<UUID> versionableLocks = componentToVersionableLocks.get(changeSet.getComponent().getItemId());
            for (IChange change : changeSet.changes()) {
                UUID versionableId = change.item().getItemId();
                if (processedVersionables.contains(versionableId) || versionableLocks != null && versionableLocks.contains(versionableId)) continue;
                processedVersionables.add(versionableId);
                IShareable shareable = sandbox.findShareable(workspaceConnection.getContextHandle(), changeSet.getComponent(), change.item(), (IProgressMonitor)progress.newChild(1));
                if (shareable == null) continue;
                if (readonly) {
                    ExclusiveFileLockPatternUtil.makeFileReadOnly(shareable, matchers);
                    continue;
                }
                ExclusiveFileLockPatternUtil.makeFileWriteable(shareable, matchers);
            }
        }
    }

    public static Map<UUID, Set<UUID>> getLocksHeldByUser(IWorkspaceConnection workspaceConnection, IProgressMonitor monitor) throws TeamRepositoryException {
        HashMap<UUID, Set<UUID>> componentToVersionableLocks = new HashMap<UUID, Set<UUID>>();
        ConnectionDescriptor defaultCollaboration = FlowUtils.getDefaultFlowTargetDescriptor((IWorkspaceConnection)workspaceConnection);
        if (defaultCollaboration == null) {
            return componentToVersionableLocks;
        }
        IWorkspaceHandle defaultFlowHandle = (IWorkspaceHandle)defaultCollaboration.connectionHandle;
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)workspaceConnection.teamRepository());
        ILockSearchCriteria criteria = ILockSearchCriteria.FACTORY.newInstance();
        criteria.getStreams().add(defaultFlowHandle);
        criteria.setContributor((IContributorHandle)workspaceConnection.teamRepository().loggedInContributor());
        ILockSearchResult searchResult = manager.findLocks(criteria, Integer.MAX_VALUE, monitor);
        for (IStreamLockReport lockReport : searchResult.getReports()) {
            for (IComponentLockReport componentLockReport : lockReport.getComponentLocks()) {
                HashSet<UUID> versionableLocks = (HashSet<UUID>)componentToVersionableLocks.get(componentLockReport.getComponent().getItemId());
                if (versionableLocks == null) {
                    versionableLocks = new HashSet<UUID>();
                    componentToVersionableLocks.put(componentLockReport.getComponent().getItemId(), versionableLocks);
                }
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    versionableLocks.add(versionableLock.getVersionable().getItemId());
                }
            }
        }
        return componentToVersionableLocks;
    }

    public static final Map<ISandbox, Set<ConfigurationFacade>> getCopyFileAreasAffected(Set<ConfigurationFacade> affectedConfigurations, IProgressMonitor progress) throws FileSystemException {
        HashMap<ISandbox, Set<ConfigurationFacade>> result = new HashMap<ISandbox, Set<ConfigurationFacade>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationFacade configuration : affectedConfigurations) {
            Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
            for (ICopyFileArea cfa : copyFileAreas) {
                Sandbox sandbox = new Sandbox(cfa);
                HashSet<ConfigurationFacade> configurations = (HashSet<ConfigurationFacade>)result.get(sandbox);
                if (configurations == null) {
                    configurations = new HashSet<ConfigurationFacade>();
                    result.put(sandbox, configurations);
                }
                configurations.add(configuration);
            }
        }
        return result;
    }

    private static Map<IStreamLockReport, IWorkspaceConnection> getLocksHeldByUsers(IWorkspaceConnection streamConnection, Map<UUID, IVersionableHandle> versionableHandles, SubMonitor progress) throws TeamRepositoryException {
        return ExclusiveFileLockPatternUtil.getLocksHeldByUser(streamConnection, versionableHandles, null, progress);
    }

    private static Map<IStreamLockReport, IWorkspaceConnection> getLocksHeldByUser(IWorkspaceConnection streamConnection, Map<UUID, IVersionableHandle> versionableHandles, IContributorHandle contributorHandle, SubMonitor progress) throws TeamRepositoryException {
        IWorkspaceManager workspaceManager;
        ILockSearchResult searchResult;
        Collection streamLockReports;
        if (versionableHandles.isEmpty()) {
            return null;
        }
        ILockSearchCriteria criteria = ILockSearchCriteria.FACTORY.newInstance();
        criteria.getStreams().add(streamConnection.getResolvedWorkspace());
        criteria.getVersionables().addAll(versionableHandles.values());
        if (contributorHandle != null) {
            criteria.setContributor(contributorHandle);
        }
        if ((streamLockReports = (searchResult = (workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)streamConnection.teamRepository())).findLocks(criteria, versionableHandles.size(), (IProgressMonitor)progress.newChild(1))).getReports()).isEmpty()) {
            return null;
        }
        HashMap<IStreamLockReport, IWorkspaceConnection> locksHeld = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        locksHeld.put((IStreamLockReport)streamLockReports.iterator().next(), streamConnection);
        return locksHeld;
    }

    public static Map<IStreamLockReport, IWorkspaceConnection> getLocksHeldByUser(IWorkspaceConnection workspaceConnection, Map<UUID, IVersionableHandle> versionableHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection flowConnection = null;
        try {
            flowConnection = ExclusiveFileLockPatternUtil.getDefaultFlowConnection(workspaceConnection, (IProgressMonitor)progress);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (flowConnection == null) {
            return null;
        }
        IContributor loggedInContributor = workspaceConnection.teamRepository().loggedInContributor();
        return ExclusiveFileLockPatternUtil.getLocksHeldByUser(flowConnection, versionableHandles, (IContributorHandle)loggedInContributor, progress.newChild(1));
    }

    public static Map<IStreamLockReport, IWorkspaceConnection> getLocksHeldByUser(IWorkspaceConnection workspaceConnection, Collection<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection flowConnection = null;
        try {
            flowConnection = ExclusiveFileLockPatternUtil.getDefaultFlowConnection(workspaceConnection, (IProgressMonitor)progress);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (flowConnection == null) {
            return null;
        }
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(new ArrayList<IChangeSetHandle>(changeSetHandles), 0, (IProgressMonitor)progress.newChild(10));
        if (changeSets == null || changeSets.size() == 0) {
            return null;
        }
        HashMap<UUID, IVersionableHandle> versionableHandles = new HashMap<UUID, IVersionableHandle>();
        for (IChangeSet changeSet : changeSets) {
            for (IChange change : changeSet.changes()) {
                versionableHandles.put(change.item().getItemId(), change.item());
            }
        }
        IContributor loggedInContributor = workspaceConnection.teamRepository().loggedInContributor();
        return ExclusiveFileLockPatternUtil.getLocksHeldByUser(flowConnection, versionableHandles, (IContributorHandle)loggedInContributor, progress.newChild(1));
    }

    public static Map<IStreamLockReport, IWorkspaceConnection> getLocksHeldByOtherUsers(IWorkspaceConnection workspaceConnection, Collection<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection flowConnection = null;
        try {
            flowConnection = ExclusiveFileLockPatternUtil.getDefaultFlowConnection(workspaceConnection, (IProgressMonitor)progress);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (flowConnection == null) {
            return null;
        }
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(new ArrayList<IChangeSetHandle>(changeSetHandles), 0, (IProgressMonitor)progress.newChild(10));
        if (changeSets == null || changeSets.size() == 0) {
            return null;
        }
        HashMap<UUID, IVersionableHandle> versionableHandles = new HashMap<UUID, IVersionableHandle>();
        for (IChangeSet changeSet : changeSets) {
            for (IChange change : changeSet.changes()) {
                versionableHandles.put(change.item().getItemId(), change.item());
            }
        }
        IContributor loggedInContributor = workspaceConnection.teamRepository().loggedInContributor();
        Map<IStreamLockReport, IWorkspaceConnection> locksHeld = ExclusiveFileLockPatternUtil.getLocksHeldByUsers(flowConnection, versionableHandles, progress.newChild(1));
        ArrayList<ComponentReport> componentLockReports = new ArrayList<ComponentReport>();
        if (locksHeld != null && !locksHeld.isEmpty()) {
            IStreamLockReport report = locksHeld.keySet().iterator().next();
            for (IComponentLockReport componentLockReport : report.getComponentLocks()) {
                HashSet<IVersionableLock> versionablesHeld = new HashSet<IVersionableLock>();
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    if (versionableLock.getContributor().getItemId().equals((Object)loggedInContributor.getItemId())) continue;
                    versionablesHeld.add(versionableLock);
                }
                if (versionablesHeld.size() <= 0) continue;
                componentLockReports.add(new ComponentReport(componentLockReport.getComponent(), versionablesHeld));
            }
        }
        if (componentLockReports.size() == 0) {
            return null;
        }
        HashMap<IStreamLockReport, IWorkspaceConnection> locksHeldByOtherUsers = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        locksHeldByOtherUsers.put(IStreamLockReport.FACTORY.createInstance((IWorkspaceHandle)flowConnection.getResolvedWorkspace(), componentLockReports), flowConnection);
        return locksHeldByOtherUsers;
    }

    public static Map<IStreamLockReport, IWorkspaceConnection> getLocksNotHeldByUser(IWorkspaceConnection workspaceConnection, Collection<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection flowConnection = null;
        try {
            flowConnection = ExclusiveFileLockPatternUtil.getDefaultFlowConnection(workspaceConnection, (IProgressMonitor)progress);
        }
        catch (TeamRepositoryException teamRepositoryException) {}
        if (flowConnection == null) {
            return null;
        }
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(new ArrayList<IChangeSetHandle>(changeSetHandles), 0, (IProgressMonitor)progress.newChild(10));
        if (changeSets == null || changeSets.size() == 0) {
            return null;
        }
        Map<Object, Object> versionableHandles = new HashMap<UUID, IVersionableHandle>();
        for (IChangeSet changeSet : changeSets) {
            for (IChange change : changeSet.changes()) {
                versionableHandles.put(change.item().getItemId(), change.item());
            }
        }
        Map<IStreamLockReport, IWorkspaceConnection> locksHeld = ExclusiveFileLockPatternUtil.getLocksHeldByUsers(flowConnection, versionableHandles, progress.newChild(1));
        HashMap<UUID, IVersionableHandle> versionablesHeld = new HashMap<UUID, IVersionableHandle>();
        if (locksHeld != null && !locksHeld.isEmpty()) {
            IStreamLockReport report = locksHeld.keySet().iterator().next();
            for (IComponentLockReport componentLockReport : report.getComponentLocks()) {
                for (IVersionableLock iVersionableLock : componentLockReport.getLocks()) {
                    versionablesHeld.put(iVersionableLock.getVersionable().getItemId(), iVersionableLock.getVersionable());
                }
            }
        }
        HashMap<IComponentHandle, HashMap<UUID, IVersionableHandle>> versionablesToLock = new HashMap<IComponentHandle, HashMap<UUID, IVersionableHandle>>();
        for (IChangeSet changeSet : changeSets) {
            for (IChange iChange : changeSet.changes()) {
                boolean found = false;
                for (IVersionableHandle versionableHeld : versionablesHeld.values()) {
                    if (!iChange.item().getItemId().equals((Object)versionableHeld.getItemId())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                versionableHandles = (Map)versionablesToLock.get(changeSet.getComponent());
                if (versionableHandles == null) {
                    versionableHandles = new HashMap();
                    versionablesToLock.put(changeSet.getComponent(), (HashMap<UUID, IVersionableHandle>)versionableHandles);
                }
                versionableHandles.put(iChange.item().getItemId(), iChange.item());
            }
        }
        if (versionablesToLock.size() == 0) {
            return null;
        }
        List<StringMatcher> matchers = ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)workspaceConnection, (IProgressMonitor)progress.newChild(1));
        ArrayList<ComponentReport> componentLockReports = new ArrayList<ComponentReport>();
        for (Map.Entry entry : versionablesToLock.entrySet()) {
            List versionables = null;
            try {
                IConfiguration configuration = workspaceConnection.configuration((IComponentHandle)entry.getKey());
                Collection versionableHandles2 = ((Map)entry.getValue()).values();
                versionables = configuration.fetchCompleteItems(new ArrayList(versionableHandles2), (IProgressMonitor)progress.newChild(versionableHandles2.size()));
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log("com.ibm.team.filesystem.client", e);
            }
            if (versionables == null) continue;
            IContributor loggedInContributor = workspaceConnection.teamRepository().loggedInContributor();
            ArrayList<IVersionableLock> versionablesToLock2 = new ArrayList<IVersionableLock>();
            for (IVersionable versionable : versionables) {
                if (versionable == null || !ExclusiveFileLockPatternUtil.patternMatches(versionable.getName(), matchers)) continue;
                IVersionableLock versionableLock = IVersionableLock.FACTORY.createInstance((IContributorHandle)loggedInContributor, (IVersionableHandle)versionable);
                versionablesToLock2.add(versionableLock);
            }
            if (versionablesToLock2.size() <= 0) continue;
            componentLockReports.add(new ComponentReport((IComponentHandle)entry.getKey(), versionablesToLock2));
        }
        if (componentLockReports.size() == 0) {
            return null;
        }
        HashMap<IStreamLockReport, IWorkspaceConnection> hashMap = new HashMap<IStreamLockReport, IWorkspaceConnection>();
        hashMap.put(IStreamLockReport.FACTORY.createInstance((IWorkspaceHandle)flowConnection.getResolvedWorkspace(), componentLockReports), flowConnection);
        return hashMap;
    }

    public static void releaseLocks(Map<IStreamLockReport, IWorkspaceConnection> locksHeld, LockDilemmaHandler lockDilemmaHandler, SubMonitor subMonitor) throws FileSystemException, TeamRepositoryException {
        ExclusiveFileLockPatternUtil.releaseLocks(locksHeld, null, lockDilemmaHandler, subMonitor);
    }

    public static void releaseLocks(Map<IStreamLockReport, IWorkspaceConnection> locksHeld, IWorkspaceConnection workspaceConnection, LockDilemmaHandler lockDilemmaHandler, SubMonitor subMonitor) throws FileSystemException, TeamRepositoryException {
        UnlockOperation unlockOperation = new UnlockOperation(lockDilemmaHandler);
        for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locksHeld.entrySet()) {
            for (IComponentLockReport componentLockReport : entry.getKey().getComponentLocks()) {
                IComponentHandle componentHandle = componentLockReport.getComponent();
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    unlockOperation.unlock(workspaceConnection, entry.getValue(), componentHandle, versionableLock.getVersionable(), versionableLock.getContributor());
                }
            }
            unlockOperation.run((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static void acquireLocks(Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire, LockDilemmaHandler lockDilemmaHandler, SubMonitor subMonitor) throws FileSystemException, TeamRepositoryException {
        ExclusiveFileLockPatternUtil.acquireLocks(locksToAcquire, null, lockDilemmaHandler, subMonitor);
    }

    public static void acquireLocks(Map<IStreamLockReport, IWorkspaceConnection> locksToAcquire, IWorkspaceConnection workspaceConnection, LockDilemmaHandler lockDilemmaHandler, SubMonitor subMonitor) throws FileSystemException, TeamRepositoryException {
        LockOperation lockOperation = new LockOperation(lockDilemmaHandler);
        for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locksToAcquire.entrySet()) {
            for (IComponentLockReport componentLockReport : entry.getKey().getComponentLocks()) {
                IComponentHandle componentHandle = componentLockReport.getComponent();
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    lockOperation.lock(workspaceConnection, entry.getValue(), componentHandle, versionableLock.getVersionable());
                }
            }
            lockOperation.run((IProgressMonitor)subMonitor.newChild(1));
        }
    }

    public static void refreshFileAttributes(Map<IStreamLockReport, IWorkspaceConnection> locks, Set<ConfigurationFacade> affectedConfigurations, IWorkspaceConnection workspaceConnection, List<StringMatcher> matchers, boolean readonly, SubMonitor subMonitor) throws TeamRepositoryException {
        Map<ISandbox, Set<ConfigurationFacade>> affectedAreas = ExclusiveFileLockPatternUtil.getCopyFileAreasAffected(affectedConfigurations, (IProgressMonitor)subMonitor.newChild(1));
        if (affectedAreas == null || affectedAreas.size() == 0) {
            return;
        }
        for (Map.Entry<IStreamLockReport, IWorkspaceConnection> entry : locks.entrySet()) {
            ISandbox sb = ExclusiveFileLockPatternUtil.getSandbox(affectedAreas, workspaceConnection, subMonitor);
            if (sb == null) continue;
            for (IComponentLockReport componentLockReport : entry.getKey().getComponentLocks()) {
                IComponentHandle componentHandle = componentLockReport.getComponent();
                for (IVersionableLock versionableLock : componentLockReport.getLocks()) {
                    IShareable shareable = sb.findShareable(workspaceConnection.getContextHandle(), componentHandle, versionableLock.getVersionable(), (IProgressMonitor)subMonitor.newChild(1));
                    if (shareable == null) continue;
                    if (readonly) {
                        ExclusiveFileLockPatternUtil.makeFileReadOnly(shareable, matchers);
                        continue;
                    }
                    ExclusiveFileLockPatternUtil.makeFileWriteable(shareable, matchers);
                }
            }
        }
    }
}

