/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import com.urbancode.winapi.LockableResource;
import com.urbancode.winapi.WinApi;
import com.urbancode.winapi.WindowsException;

public class Handle
extends LockableResource {
    private volatile long value;
    volatile Object finalizerGuardian;

    public Handle() {
        this.initFinalizerGuardian();
    }

    public String toString() {
        return "0x" + Long.toHexString(this.value);
    }

    public boolean isOpen() {
        return this.value != 0L;
    }

    public void closeNoError() {
        try {
            this.close();
        }
        catch (WindowsException windowsException) {
            // empty catch block
        }
    }

    public void close() throws WindowsException {
        WinApi.CloseHandle(this);
    }

    void initFinalizerGuardian() {
        this.finalizerGuardian = new Object(){

            protected void finalize() throws Throwable {
                if (Handle.this.isOpen()) {
                    WinApi.closeInFinalizer(Handle.this);
                }
            }
        };
    }
}

