/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.notification;

import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.ProgressNotificationParm;
import com.ibm.team.repository.common.LogFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;

public class HttpProgressReporter
implements IProgressMonitorWithBlocking {
    public static final long DELAY_MS = 100L;
    protected HttpResponse response;
    protected IStatus blockedStatus;
    protected String taskName;
    protected String subTask;
    protected double totalWork;
    protected double worked;
    protected long lastNotifyTime;
    protected boolean cancelled;
    protected boolean finished;
    protected final String key;
    protected final IServerNotificationChannel notifier;

    public HttpProgressReporter(String key, IServerNotificationChannel notifier, HttpResponse resp) {
        this.key = key;
        this.notifier = notifier;
        this.response = resp;
        this.lastNotifyTime = -100L;
    }

    public synchronized void finish() {
        this.finished = true;
    }

    public synchronized void clearBlocked() {
        this.blockedStatus = null;
        this.notifyClient();
    }

    public synchronized void setBlocked(IStatus reason) {
        this.blockedStatus = reason;
        this.notifyClient();
    }

    public synchronized void beginTask(String name, int totalWork) {
        this.taskName = name;
        this.totalWork = totalWork < 0 ? 0.0 : (double)totalWork;
        this.notifyClient();
    }

    public synchronized void done() {
        this.worked = this.totalWork;
    }

    public synchronized void internalWorked(double work) {
        this.worked += work;
        if (this.worked < 0.0) {
            this.worked = 0.0;
        } else if (this.worked > this.totalWork) {
            this.worked = this.totalWork;
        }
        this.notifyClient();
    }

    public synchronized boolean isCanceled() {
        if (!this.cancelled && !this.finished) {
            this.cancelled = !this.response.isClientConnected();
        }
        this.notifyClient();
        return this.cancelled;
    }

    public synchronized void setCanceled(boolean value) {
        this.cancelled = true;
        this.notifyClient();
    }

    public synchronized void setTaskName(String name) {
        this.taskName = name;
        this.notifyClient();
    }

    public synchronized void subTask(String name) {
        this.subTask = name;
        this.notifyClient();
    }

    public synchronized void worked(int work) {
        this.internalWorked(work);
    }

    protected void notifyClient() {
        if (this.finished) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.lastNotifyTime + 100L > currentTime) {
            return;
        }
        try {
            this.marshalProgress();
            this.lastNotifyTime = currentTime;
        }
        catch (IOException e) {
            LogFactory.getLog((String)HttpProgressReporter.class.getName()).error((Object)"Failed to update status", (Throwable)e);
        }
    }

    protected void marshalProgress() throws UnsupportedEncodingException {
        double progress = this.totalWork == 0.0 ? 100.0 : this.worked * 100.0 / this.totalWork;
        this.notifier.queueNotification(this.key, ProgressNotificationParm.TYPE, new ProgressNotificationParm(this.taskName, this.subTask, progress, this.cancelled));
    }

    public void resetDelay() {
        this.lastNotifyTime = 0L;
    }
}

