/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IDetailedStatus;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public abstract class WorkItemOperation {
    private String fName;
    private ItemProfile fProfile;

    public WorkItemOperation(String name) {
        this(name, null);
    }

    public WorkItemOperation(String name, ItemProfile profile) {
        this.fName = name;
        this.fProfile = profile;
    }

    protected void execute(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkItemWorkingCopy[] workItemWorkingCopyArray = workingCopies;
        int n = workingCopies.length;
        int n2 = 0;
        while (n2 < n) {
            WorkItemWorkingCopy workingCopy = workItemWorkingCopyArray[n2];
            this.execute(workingCopy, monitor);
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
    }

    protected void execute(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
    }

    protected void commit(WorkItemWorkingCopy[] workingCopies, IProgressMonitor monitor) throws TeamRepositoryException {
        if (workingCopies.length == 0) {
            return;
        }
        ITeamRepository teamRepository = workingCopies[0].getTeamRepository();
        IWorkItemWorkingCopyManager workingCopyManager = this.getWorkingCopyManager(teamRepository);
        IDetailedStatus status = workingCopyManager.save(workingCopies, monitor);
        if (status.getSeverity() == 4) {
            if (status.getException() instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)status.getException();
            }
            throw new TeamRepositoryException((Object)teamRepository, status.getMessage(), status.getException());
        }
    }

    public final void run(IWorkItemHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.run(new IWorkItemHandle[]{handle}, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public final void run(IWorkItemHandle[] handles, IProgressMonitor monitor) throws TeamRepositoryException {
        block7: {
            profile = this.getRequiredProfile();
            Assert.isNotNull((Object)profile);
            if (handles.length == 0) {
                return;
            }
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            connected = new ArrayList<IWorkItemHandle>();
            workingCopyManager = this.getWorkingCopyManager((IItemHandle)handles[0]);
            try {
                subMonitor = progress.newChild(20);
                i = 0;
                while (i < handles.length) {
                    workingCopyManager.connect(handles[i], (ItemProfile<IWorkItem>)profile, (IProgressMonitor)subMonitor);
                    connected.add(handles[i]);
                    ++i;
                }
                break block7;
            }
            catch (TeamRepositoryException x) {
                iterator = connected.iterator();
                ** while (iterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                workingCopyManager.disconnect((IWorkItemHandle)iterator.next());
                continue;
            }
lbl23:
            // 1 sources

            throw x;
            catch (RuntimeException x) {
                iterator = connected.iterator();
                ** while (iterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                workingCopyManager.disconnect((IWorkItemHandle)iterator.next());
                continue;
            }
lbl29:
            // 1 sources

            throw x;
        }
        this.doRun(handles, (IProgressMonitor)progress.newChild(80));
    }

    public final IWorkItemHandle run(IWorkItemType workItemType, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkItemHandle)this.run(Collections.singletonList(workItemType), monitor).get(0);
    }

    public final IWorkItemHandle run(IProjectAreaHandle projectArea, String workItemTypeIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        IWorkItemType workItemType = workItemClient.findWorkItemType(projectArea, workItemTypeIdentifier, monitor);
        Assert.isNotNull((Object)workItemType);
        return this.run(workItemType, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public final List run(List workItemTypes, IProgressMonitor monitor) throws TeamRepositoryException {
        block8: {
            if (workItemTypes.size() == 0) {
                return Collections.EMPTY_LIST;
            }
            if (monitor != null) {
                monitor.beginTask(this.getName(), 3);
            }
            handles = new ArrayList<IWorkItemHandle>();
            workingCopyManager = this.getWorkingCopyManager((IItemHandle)((IWorkItemType)workItemTypes.get(0)).getProjectArea());
            try {
                for (IWorkItemType workItemType : workItemTypes) {
                    handles.add(workingCopyManager.connectNew(workItemType, monitor));
                }
                break block8;
            }
            catch (TeamRepositoryException x) {
                iterator = handles.iterator();
                ** while (iterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                workingCopyManager.disconnect((IWorkItemHandle)iterator.next());
                continue;
            }
lbl18:
            // 1 sources

            throw x;
            catch (RuntimeException x) {
                iterator = handles.iterator();
                ** while (iterator.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                workingCopyManager.disconnect((IWorkItemHandle)iterator.next());
                continue;
            }
lbl24:
            // 1 sources

            throw x;
        }
        this.doRun(handles.toArray(new IWorkItemHandle[handles.size()]), monitor);
        return handles;
    }

    /*
     * Unable to fully structure code
     */
    private void doRun(IWorkItemHandle[] handles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handles.length == 0) {
            return;
        }
        workingCopyManager = this.getWorkingCopyManager((IItemHandle)handles[0]);
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            workingCopies = new ArrayList<WorkItemWorkingCopy>();
            commitCandidates = new ArrayList<WorkItemWorkingCopy>();
            i = 0;
            while (i < handles.length) {
                workingCopyManager.beginCompoundWorkItemChange(handles[i]);
                workingCopy = workingCopyManager.getWorkingCopy(handles[i]);
                workingCopies.add(workingCopy);
                if (!workingCopy.isDirty()) {
                    commitCandidates.add(workingCopy);
                }
                ++i;
            }
            progress.worked(10);
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.execute(workingCopies.toArray(new WorkItemWorkingCopy[workingCopies.size()]), (IProgressMonitor)progress.newChild(10));
            this.commit(commitCandidates.toArray(new WorkItemWorkingCopy[commitCandidates.size()]), (IProgressMonitor)progress.newChild(70));
        }
        finally {
            i = 0;
            ** while (i < handles.length)
        }
lbl-1000:
        // 1 sources

        {
            workingCopyManager.endCompoundWorkItemChange(handles[i]);
            workingCopyManager.disconnect(handles[i]);
            ++i;
            continue;
        }
lbl32:
        // 1 sources

        progress.worked(10);
        if (monitor != null) {
            monitor.done();
        }
    }

    public final Job runInJob(IWorkItemHandle handle) {
        return this.runInJob(new IWorkItemHandle[]{handle});
    }

    public final Job runInJob(final IWorkItemHandle[] handles) {
        FoundationJob job = new FoundationJob(this.getName()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                WorkItemOperation.this.run(handles, monitor);
                return null;
            }
        };
        job.schedule();
        return job;
    }

    public final Job runInSystemJob(IWorkItemHandle handle) {
        return this.runInSystemJob(new IWorkItemHandle[]{handle});
    }

    public final Job runInSystemJob(final IWorkItemHandle[] handles) {
        FoundationJob job = new FoundationJob(this.getName()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                WorkItemOperation.this.run(handles, monitor);
                return null;
            }
        };
        job.setSystem(true);
        job.schedule();
        return job;
    }

    public final Job runInJob(IWorkItemType workItemType) {
        return this.runInJob(Collections.singletonList(workItemType));
    }

    public final Job runInJob(final Object projectArea, final String workItemTypeIdentifier) {
        FoundationJob job = new FoundationJob(this.getName()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                WorkItemOperation.this.run((IProjectAreaHandle)projectArea, workItemTypeIdentifier, monitor);
                return null;
            }
        };
        job.schedule();
        return job;
    }

    public final Job runInJob(final List workItemTypes) {
        FoundationJob job = new FoundationJob(this.getName()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                WorkItemOperation.this.run(workItemTypes, monitor);
                return null;
            }
        };
        job.schedule();
        return job;
    }

    public final String getName() {
        return this.fName;
    }

    private ItemProfile getRequiredProfile() {
        return this.fProfile;
    }

    private IWorkItemWorkingCopyManager getWorkingCopyManager(IItemHandle handle) {
        return this.getWorkingCopyManager((ITeamRepository)handle.getOrigin());
    }

    private IWorkItemWorkingCopyManager getWorkingCopyManager(ITeamRepository teamRepository) {
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        return workItemClient.getWorkItemWorkingCopyManager();
    }
}

