/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import org.apache.commons.lang3.Validate;
import org.apache.http.protocol.HTTP;

public class EncoderConfig {
    private static final String UTF_8 = "UTF-8";
    private final String defaultContentCharset;
    private final String defaultQueryParameterCharset;

    public EncoderConfig() {
        this(HTTP.DEF_CONTENT_CHARSET.toString(), UTF_8);
    }

    public EncoderConfig(String defaultContentCharset, String defaultQueryParameterCharset) {
        Validate.notBlank(defaultContentCharset, "Default encoder content charset to cannot be blank", new Object[0]);
        Validate.notBlank(defaultQueryParameterCharset, "Default protocol charset to cannot be blank", new Object[0]);
        this.defaultContentCharset = defaultContentCharset;
        this.defaultQueryParameterCharset = defaultQueryParameterCharset;
    }

    public String defaultContentCharset() {
        return this.defaultContentCharset;
    }

    public String defaultQueryParameterCharset() {
        return this.defaultQueryParameterCharset;
    }

    public EncoderConfig defaultContentCharset(String charset) {
        return new EncoderConfig(charset, this.defaultQueryParameterCharset);
    }

    public EncoderConfig defaultQueryParameterCharset(String charset) {
        return new EncoderConfig(this.defaultContentCharset, charset);
    }

    public static EncoderConfig encoderConfig() {
        return new EncoderConfig();
    }

    public EncoderConfig and() {
        return this;
    }
}

