/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.framework;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.urbancode.release.rest.framework.ClientEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public class ClientNamed<T extends ClientNamed>
extends ClientEntity<T> {
    public static final Function<ClientNamed, String> GET_NAME = new Function<ClientNamed, String>(){

        @Override
        @Nullable
        public String apply(@Nullable ClientNamed named) {
            return named.name;
        }
    };
    public static final Ordering<ClientNamed> BY_NAME = Ordering.natural().onResultOf(GET_NAME);
    public static final Ordering<ClientNamed> BY_NAME_IGNORE_CASE = Ordering.from(String.CASE_INSENSITIVE_ORDER).onResultOf(GET_NAME);
    public String name;

    public static <CN extends ClientNamed> CN findByName(String name, CN ... named) {
        for (CN entity : named) {
            if (!((ClientNamed)entity).name.equals(name)) continue;
            return entity;
        }
        return null;
    }

    public static List<String> getNames(ClientNamed[] clients) {
        return Lists.transform(Arrays.asList(clients), GET_NAME);
    }

    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        return this.name(name);
    }

    public T name(String name) {
        this.handleNull(name, "name");
        this.name = name;
        return (T)this;
    }

    public static NamedDataGenerator getDataGenerator() {
        return new NamedDataGenerator();
    }

    public static class NamedDataGenerator
    extends ClientEntity.DataGenerator<ClientNamed> {
        @Override
        public List<ClientNamed> cloneAndSaveNTimes(ClientNamed entity, int copies) {
            ArrayList<ClientNamed> result = new ArrayList<ClientNamed>();
            for (int i = 0; i < copies; ++i) {
                result.add((ClientNamed)((ClientNamed)entity.clone()).name(entity.name + "_copy_" + i));
            }
            entity.post((ClientNamed[])result.toArray());
            return result;
        }
    }
}

