/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProcessContainerHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.Enumeration;
import com.ibm.team.workitem.common.internal.enumeration.EnumerationPackage;
import com.ibm.team.workitem.common.internal.enumeration.Literal;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.model.ExternalValueRepresentationItem;
import com.ibm.team.workitem.common.internal.util.CollectionUtils;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class EnumerationsHelper {
    public static final String CREATE_LITERAL_OPERATION_ID = "com.ibm.team.workitem.operation.createLiteral";
    public static final String CREATE_LITERAL_ACTION_ID = "createliteral";

    public static IEnumeration<ILiteral> toModelledEnumeration(IAuditableCommon common, com.ibm.team.workitem.common.internal.enumeration.Enumeration enumeration) {
        List literals = enumeration.getLiterals();
        ArrayList<ILiteral> modeledLiterals = new ArrayList<ILiteral>(literals.size());
        for (Object obj : literals) {
            Literal literal = (Literal)obj;
            ILiteral modeledLiteral = EnumerationsHelper.toModelledLiteral(common, enumeration, literal);
            modeledLiterals.add(modeledLiteral);
        }
        return new Enumeration<ILiteral>(modeledLiterals, true);
    }

    private static ILiteral toModelledLiteral(IAuditableCommon common, com.ibm.team.workitem.common.internal.enumeration.Enumeration enumeration, Literal literal) {
        URL iconUrl;
        String nullLiteralId = enumeration.getUnassignedLiteralId();
        String defaultLiteralId = enumeration.getDefaultLiteralId();
        boolean isNull = nullLiteralId != null && nullLiteralId.equals(literal.getIdentifier());
        boolean isDefault = defaultLiteralId != null && defaultLiteralId.equals(literal.getIdentifier());
        boolean isArchived = literal.isArchived();
        int sequenceValue = literal.getSequenceValue();
        String externalValue = literal.getExternalValue();
        URL uRL = iconUrl = literal.getIconUrl() != null ? EnumerationsHelper.createResourceURL(common, enumeration.getProjectArea(), literal.getIconUrl(), null) : null;
        if (externalValue != null && externalValue.length() > 0) {
            return new ExternalValueRepresentationItem(enumeration.getProjectArea(), literal.getIdentifier(), literal.getName(), externalValue, iconUrl, sequenceValue, isDefault, isNull, isArchived);
        }
        return new ConfigurationItem(enumeration.getProjectArea(), literal.getIdentifier(), literal.getName(), iconUrl, sequenceValue, isDefault, isNull, isArchived);
    }

    private static URL createResourceURL(IAuditableCommon common, IProjectAreaHandle projectArea, String icon, IProgressMonitor monitor) {
        return Utils.createResourceURL(common, (IProcessContainerHandle)projectArea, icon, monitor);
    }

    public static IItemType getEnumerationItemType() {
        return IItemType.IRegistry.INSTANCE.getItemType(EnumerationPackage.eINSTANCE.getEnumeration().getName(), "com.ibm.team.workitem.enumeration");
    }

    public static Object matchValueFromEnumeration(IEnumeration<? extends ILiteral> enumeration, Object value) {
        if (enumeration != null && value instanceof ILiteral && !CollectionUtils.contains(enumeration.getEnumerationLiterals(false).toArray(), value)) {
            String valueIdentifier = ((ILiteral)value).getIdentifier2().getStringIdentifier();
            for (ILiteral iLiteral : enumeration.getEnumerationLiterals(false)) {
                if (!iLiteral.getIdentifier2().getStringIdentifier().equals(valueIdentifier)) continue;
                return iLiteral;
            }
        }
        return value;
    }
}

