/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.presentations;

import com.ibm.team.foundation.common.util.FoundationLog;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.workitem.common.query.IQueryType;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class PresentationBindingRegistries {
    private static final FoundationLog LOGGER = FoundationLog.getLog(PresentationBindingRegistries.class);
    private static final String EXTENSION_POINT_ID = "queryEditorPresentations";
    private static final String ELEMENT_DEFAULT_PRESENTATION = "defaultPresentation";
    private static final String ELEMENT_PRESENTATION = "presentation";
    private static final String ELEMENT_ITEM_TYPE = "itemType";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_QUERY_TYPE = "queryType";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_NS_URI = "nsUri";

    public static PresentationBindingRegistry createRegistry(String pluginId) {
        return new PresentationBindingRegistry(pluginId);
    }

    private static class Binding {
        protected final IConfigurationElement fElement;
        private Object fFactory;

        public Binding(IConfigurationElement element) {
            this.fElement = element;
        }

        public String getId() {
            return this.fElement.getAttribute(PresentationBindingRegistries.ATTRIBUTE_ID);
        }

        public Object getFactory() {
            if (this.fFactory == null) {
                try {
                    this.fFactory = this.fElement.createExecutableExtension(PresentationBindingRegistries.ATTRIBUTE_CLASS);
                }
                catch (CoreException e) {
                    LOGGER.error("PresentationBindingRegistries: Could not create binding", (Throwable)e);
                }
            }
            return this.fFactory;
        }
    }

    private static class DefaultBinding
    extends Binding {
        public DefaultBinding(IConfigurationElement element) {
            super(element);
        }

        public Object getDefaultFactory() {
            return this.getFactory();
        }

        public String getItemTypeId() {
            IConfigurationElement[] itemTypes = this.fElement.getChildren(PresentationBindingRegistries.ELEMENT_ITEM_TYPE);
            if (itemTypes.length > 0) {
                String name = itemTypes[0].getAttribute(PresentationBindingRegistries.ATTRIBUTE_NAME);
                String nsUri = itemTypes[0].getAttribute(PresentationBindingRegistries.ATTRIBUTE_NS_URI);
                if (name != null && nsUri != null) {
                    return DefaultBinding.getItemTypeIdentifier(name, nsUri);
                }
            }
            return null;
        }

        public String getQueryTypeId() {
            return this.fElement.getAttribute(PresentationBindingRegistries.ATTRIBUTE_QUERY_TYPE);
        }

        public static String getItemTypeIdentifier(String name, String nsUri) {
            return String.format("%s:%s", name, nsUri);
        }
    }

    public static final class PresentationBindingRegistry
    extends ExtensionRegistryReader<Binding> {
        private DefaultBinding fgDefaultBinding = null;
        private Map<String, Binding> fgBindingsById = new HashMap<String, Binding>();
        private Map<String, DefaultBinding> fgDefaultBindingsByQueryType = new HashMap<String, DefaultBinding>();
        private Map<String, DefaultBinding> fgDefaultBindingsByItemType = new HashMap<String, DefaultBinding>();

        protected PresentationBindingRegistry(String pluginId) {
            super(pluginId, PresentationBindingRegistries.EXTENSION_POINT_ID);
        }

        public Object getBinding(String presentationIdentifier) {
            this.lazyStart();
            Binding binding = this.fgBindingsById.get(presentationIdentifier);
            if (binding != null) {
                return binding.getFactory();
            }
            return null;
        }

        public boolean hasBinding(String presentationIdentifier) {
            this.lazyStart();
            Binding binding = this.fgBindingsById.get(presentationIdentifier);
            return binding != null;
        }

        public Object getDefaultBinding(IQueryType type) {
            this.lazyStart();
            DefaultBinding binding = this.fgDefaultBindingsByQueryType.get(type.getIdentifier());
            if (binding != null) {
                return binding.getDefaultFactory();
            }
            return this.getDefaultBinding(type.getQueryItemType());
        }

        public Object getDefaultBinding(IItemType type) {
            this.lazyStart();
            String itemTypeIdentifier = DefaultBinding.getItemTypeIdentifier(type.getName(), type.getNamespaceURI());
            DefaultBinding binding = this.fgDefaultBindingsByItemType.get(itemTypeIdentifier);
            if (binding != null) {
                return binding.getDefaultFactory();
            }
            return this.getDefaultBinding();
        }

        public Object getDefaultBinding() {
            this.lazyStart();
            if (this.fgDefaultBinding != null) {
                return this.fgDefaultBinding.getDefaultFactory();
            }
            return null;
        }

        private void lazyStart() {
            if (!this.isStarted()) {
                this.start();
            }
        }

        protected Binding handleExtensionAdded(IConfigurationElement element) throws Exception {
            if (PresentationBindingRegistries.ELEMENT_DEFAULT_PRESENTATION.equals(element.getName())) {
                return this.handleDefaultPresentation(element);
            }
            if (PresentationBindingRegistries.ELEMENT_PRESENTATION.equals(element.getName())) {
                return this.handlePresentation(element);
            }
            return null;
        }

        protected void handleExtensionRemoved(IConfigurationElement element, Binding descriptor) throws Exception {
            super.handleExtensionRemoved(element, (Object)descriptor);
        }

        private Binding handlePresentation(IConfigurationElement configurationElement) {
            Binding binding = new Binding(configurationElement);
            if (binding.getId() != null) {
                this.fgBindingsById.put(binding.getId(), binding);
            }
            return binding;
        }

        private DefaultBinding handleDefaultPresentation(IConfigurationElement configurationElement) {
            DefaultBinding binding = new DefaultBinding(configurationElement);
            if (binding.getQueryTypeId() != null) {
                this.fgDefaultBindingsByQueryType.put(binding.getQueryTypeId(), binding);
            }
            if (binding.getItemTypeId() != null) {
                this.fgDefaultBindingsByItemType.put(binding.getItemTypeId(), binding);
            }
            if (binding.getId() != null) {
                this.fgBindingsById.put(binding.getId(), binding);
            }
            if (binding.getQueryTypeId() == null && binding.getItemTypeId() == null) {
                this.fgDefaultBinding = binding;
            }
            return binding;
        }
    }
}

