/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.setup.builders;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.model.Attachment;
import com.ibm.team.workitem.common.internal.util.PermissionContext;
import com.ibm.team.workitem.common.model.IAttachment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class AttachmentBuilder
extends AbstractArtifactBuilder<IAttachment> {
    protected static final ValueKey<IProjectArea> PROJECT_AREA = new ValueKey(String.valueOf(AttachmentBuilder.class.getName()) + ".projectArea");
    protected static final ValueKey<File> FILE = new ValueKey(String.valueOf(AttachmentBuilder.class.getName()) + ".file");
    protected static final ValueKey<String> FILENAME = new ValueKey(String.valueOf(AttachmentBuilder.class.getName()) + ".filename");
    protected static final ValueKey<String> CONTENT_TYPE = new ValueKey(String.valueOf(AttachmentBuilder.class.getName()) + ".contentType");

    public AttachmentBuilder(IArtifactBuilderContext buildContext) {
        super(buildContext);
    }

    public AttachmentBuilder projectArea(IProjectArea projectArea) {
        this.setBuilderValue(PROJECT_AREA, projectArea);
        return this;
    }

    public AttachmentBuilder fileName(String fileName) {
        this.setBuilderValue(FILENAME, fileName);
        return this;
    }

    public AttachmentBuilder contentType(String contentType) {
        this.setBuilderValue(CONTENT_TYPE, contentType);
        return this;
    }

    public AttachmentBuilder content(File content) {
        this.setBuilderValue(FILE, content);
        return this;
    }

    protected IProcessBuilderContext getContext() {
        return (IProcessBuilderContext)super.getContext();
    }

    protected IAttachment doBuild(BuildContext context) {
        if (!this.isBuilderValueSet(PROJECT_AREA) && !context.isPropertySet(BuildContext.PROJECT_AREA)) {
            throw new IllegalArgumentException("Cannot build an attachment without specifying the project area");
        }
        IProjectArea projectAreaHandle = (IProjectArea)this.chooseValue(context, PROJECT_AREA, BuildContext.PROJECT_AREA, null);
        String filename = (String)this.getBuilderValue(FILENAME, this.isBuilderValueSet(FILE) ? ((File)this.getBuilderValue(FILE)).getName() : "default file name " + UUID.generate().getUuidValue());
        UUID attachmentUUID = UUID.generate();
        Attachment attachment = (Attachment)IAttachment.ITEM_TYPE.createItem();
        Attachment workingCopy = (Attachment)attachment.getWorkingCopy();
        workingCopy.setName(filename);
        workingCopy.setDescription(filename);
        workingCopy.setItemId(attachmentUUID);
        workingCopy.setWorkingCopy(true);
        workingCopy.setProjectArea((IProjectAreaHandle)projectAreaHandle);
        PermissionContext.setDefault((IItem)workingCopy);
        return attachment;
    }

    protected IAttachment doSave(BuildContext context) throws TeamRepositoryException {
        if (!this.isBuilderValueSet(FILE)) {
            throw new IllegalArgumentException("Cannot create an attachment without specifying the file");
        }
        File file = (File)this.getBuilderValue(FILE);
        byte[] byteArray = this.readFile(file);
        IContent content = this.getContext().storeContent((String)this.getBuilderValue(CONTENT_TYPE, "application/unknown"), "UTF-8", byteArray);
        IAttachment doBuild = this.doBuild(context);
        ((IAttachment)doBuild.getWorkingCopy()).setContent(content);
        return ((IWorkItemCommon)this.getContext().getLibrary(IWorkItemCommon.class)).saveAttachment(doBuild, (IProgressMonitor)new NullProgressMonitor());
    }

    private byte[] readFile(File file) throws TeamRepositoryException {
        byte[] byteArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                fileInputStream.read(byteArray);
            }
            catch (FileNotFoundException e) {
                throw new TeamRepositoryException(e.getMessage());
            }
            catch (IOException e1) {
                throw new TeamRepositoryException(e1.getMessage());
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    throw new TeamRepositoryException(e.getMessage());
                }
            }
        }
        return byteArray;
    }
}

