/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.air.plugin_command.runtime.FetcherException;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class Fetcher {
    protected File storageDir;
    private static final Logger logger = Logger.getLogger(Fetcher.class);

    public Fetcher(File storageDir) {
        if (storageDir != null && storageDir.isDirectory()) {
            this.storageDir = storageDir.getAbsoluteFile();
        } else {
            String tmpDirStr = System.getProperty("java.io.tmpdir");
            File tmpDir = new File(tmpDirStr);
            logger.warn((Object)("Supplied Fetcher storage directory '" + storageDir + "' does not exist. Using system temp dir '" + tmpDir.getPath() + "'."));
            this.storageDir = tmpDir;
        }
    }

    protected abstract File fetch(String var1, Long var2, String var3) throws FetcherException;

    protected abstract String getHash(String var1, Long var2) throws FetcherException;

    protected File getBaseDir() {
        return this.storageDir;
    }

    protected void cleanup(String pluginId, Long version, String hash) throws FetcherException {
        logger.debug((Object)"Performing plugin cleanup");
        if (pluginId == null) {
            logger.error((Object)"No pluginId was given to cleanup().");
            throw new NullPointerException("No pluginId was given to cleanup().");
        }
        if (version == null) {
            logger.error((Object)"No version was given to cleanup().");
            throw new NullPointerException("No version was given to cleanup().");
        }
        if (hash == null) {
            logger.error((Object)"No hash was given to cleanup().");
            throw new NullPointerException("No hash was given to cleanup().");
        }
        String pluginName = pluginId + "_" + version + "_" + hash;
        for (File file : this.storageDir.listFiles()) {
            if (!file.getName().startsWith(pluginId + "_" + version) || file.getName().equalsIgnoreCase(pluginName)) continue;
            logger.debug((Object)("Deleting plugin file " + file.getName()));
            try {
                IO.delete((File)file);
            }
            catch (IOException e) {
                logger.error((Object)("Unable to delete file " + file.getName()));
            }
        }
    }
}

