/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.util;

import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.util.XMLEscapeUtil;
import com.ibm.team.repository.common.transport.HttpUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class XMLConstructionUtil {
    private static boolean printToSystemOut = false;
    public static final String XML_HEADER_FMT = "<?xml version=\"1.0\" encoding=\"%s\" ?>";
    public static final String XML_NAMESPACE_TAG = "xmlns:";
    public static final String XSI_NAMESPACE_TAG = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
    public static final String START_ELEMENT_TAG = "<";
    public static final String END_ELEMENT_TAG = ">";
    public static final String COMMENT_START_TAG = "<!--";
    public static final String COMMENT_END_TAG = "-->";
    public static final String EMPTY_STRING = "\"\"";
    public static final String EQUAL_TAG = "=";
    public static final String SLASH_TAG = "/";
    public static final String QUOTE_CHARACTER = "\"";
    public static final String SPACE_CHARACTER = " ";
    public static final String NEWLINE_CHARACTER = "\n";
    public static final String TAB_CHARACTER = "\t";
    public static final String ITEM_ID_ATTRIBUTE_NAME = "itemId";
    public static final String STATE_ID_ATTRIBUTE_NAME = "stateId";
    public static final String XSI_TYPE_NAME = "xsi:type";
    public static final String XSI_NIL = "xsi:nil=\"true\"/>";
    private static final String nameChars = "^[a-zA-Z_][a-zA-Z0-9\\-_\\.]*";
    private static final String xmlChars = ".*(x|Xm|Ml|L).*";
    private static final Pattern nameCharsPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9\\-_\\.]*");
    private static final Pattern xmlCharsPattern = Pattern.compile(".*(x|Xm|Ml|L).*");
    private static final int ELEMENT_STATIC_LENGTH = 2 * "<".length() + 2 * ">".length() + "/".length();

    public static Writer createWriter(OutputStream outputStream, Charset charset) throws UnsupportedEncodingException {
        if (charset == null) {
            charset = HttpUtil.CharsetEncoding.UTF8.toCharset();
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream must not be null");
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));
        if (!printToSystemOut) {
            return writer;
        }
        return new SplitWriter(System.out, writer);
    }

    public static void writeXMLHeader(Writer writer, Charset charset) throws MarshallingException {
        XMLConstructionUtil.write(writer, String.format(XML_HEADER_FMT, charset.name()));
    }

    public static void writeNamespaceInformation(Writer writer, Map referencedNamespacesHashMap) throws MarshallingException {
        StringBuffer namespaceBuffer = new StringBuffer();
        if (referencedNamespacesHashMap != null && referencedNamespacesHashMap.size() > 0) {
            Iterator i = referencedNamespacesHashMap.entrySet().iterator();
            while (i.hasNext()) {
                XMLConstructionUtil.writeNewLineWithTabCharacters(namespaceBuffer, 1);
                Map.Entry e = i.next();
                String namespacePrefix = (String)e.getKey();
                String namespaceURI = (String)e.getValue();
                namespaceBuffer.append(XML_NAMESPACE_TAG);
                namespaceBuffer.append(namespacePrefix);
                namespaceBuffer.append(EQUAL_TAG);
                namespaceBuffer.append(QUOTE_CHARACTER);
                namespaceBuffer.append(namespaceURI);
                namespaceBuffer.append(QUOTE_CHARACTER);
            }
            XMLConstructionUtil.writeNewLineWithTabCharacters(namespaceBuffer, 1);
            namespaceBuffer.append(XSI_NAMESPACE_TAG);
            XMLConstructionUtil.write(writer, namespaceBuffer.toString());
        }
    }

    public static void writeComment(Writer writer, String comment) throws MarshallingException {
        StringBuffer commentBuffer = new StringBuffer();
        commentBuffer.append(COMMENT_START_TAG);
        commentBuffer.append(comment);
        commentBuffer.append(COMMENT_END_TAG);
        XMLConstructionUtil.write(writer, commentBuffer.toString());
    }

    public static void writeElement(Writer writer, String elementName, String value, int depth) throws MarshallingException {
        if (value != null) {
            int allocLength = ELEMENT_STATIC_LENGTH + 2 * elementName.length() + (int)((double)value.length() * 1.1);
            StringBuffer elementBuffer = new StringBuffer(allocLength);
            XMLConstructionUtil.writeNewLineWithTabCharacters(elementBuffer, depth);
            elementBuffer.append(START_ELEMENT_TAG);
            elementBuffer.append(elementName);
            elementBuffer.append(END_ELEMENT_TAG);
            elementBuffer.append(XMLEscapeUtil.convert(value));
            elementBuffer.append(START_ELEMENT_TAG);
            elementBuffer.append(SLASH_TAG);
            elementBuffer.append(elementName);
            elementBuffer.append(END_ELEMENT_TAG);
            XMLConstructionUtil.write(writer, elementBuffer.toString());
        }
    }

    public static void writeElementName(Writer writer, String elementName) throws MarshallingException {
        XMLConstructionUtil.write(writer, START_ELEMENT_TAG + elementName);
    }

    public static void writeEndElementTag(Writer writer) throws MarshallingException {
        XMLConstructionUtil.write(writer, END_ELEMENT_TAG);
    }

    public static void writeEndElementName(Writer writer, String elementName, int depth) throws MarshallingException {
        StringBuffer endElementNameBuffer = new StringBuffer();
        XMLConstructionUtil.writeNewLineWithTabCharacters(endElementNameBuffer, depth);
        endElementNameBuffer.append(START_ELEMENT_TAG);
        endElementNameBuffer.append(SLASH_TAG);
        endElementNameBuffer.append(elementName);
        endElementNameBuffer.append(END_ELEMENT_TAG);
        XMLConstructionUtil.write(writer, endElementNameBuffer.toString());
    }

    public static void writeAttribute(Writer writer, String attributeName, String attributeValue) throws MarshallingException {
        StringBuffer attributeBuffer = new StringBuffer();
        XMLConstructionUtil.writeAttributeToAttributeBuffer(attributeBuffer, attributeName, attributeValue);
        XMLConstructionUtil.write(writer, attributeBuffer.toString());
    }

    private static void writeAttributeToAttributeBuffer(StringBuffer attributeBuffer, String attributeName, String attributeValue) {
        attributeBuffer.append(SPACE_CHARACTER);
        attributeBuffer.append(attributeName);
        attributeBuffer.append(EQUAL_TAG);
        attributeBuffer.append(QUOTE_CHARACTER);
        attributeBuffer.append(XMLEscapeUtil.convert(attributeValue));
        attributeBuffer.append(QUOTE_CHARACTER);
    }

    public static void writeEmptyAttribute(String elementName, Writer writer) throws MarshallingException {
        StringBuffer emptyAttributeBuffer = new StringBuffer();
        emptyAttributeBuffer.append(SPACE_CHARACTER);
        emptyAttributeBuffer.append(elementName);
        emptyAttributeBuffer.append(EQUAL_TAG);
        emptyAttributeBuffer.append(EMPTY_STRING);
        XMLConstructionUtil.write(writer, emptyAttributeBuffer.toString());
    }

    public static void writeEmptyElement(Writer writer, String elementName) throws MarshallingException {
        StringBuffer emptyReferenceBuffer = new StringBuffer();
        emptyReferenceBuffer.append(START_ELEMENT_TAG);
        emptyReferenceBuffer.append(elementName);
        emptyReferenceBuffer.append(END_ELEMENT_TAG);
        emptyReferenceBuffer.append(START_ELEMENT_TAG);
        emptyReferenceBuffer.append(SLASH_TAG);
        emptyReferenceBuffer.append(elementName);
        emptyReferenceBuffer.append(END_ELEMENT_TAG);
        XMLConstructionUtil.write(writer, emptyReferenceBuffer.toString());
    }

    public static void writeNullElement(Writer writer, String elementName) throws MarshallingException {
        StringBuffer nullReferenceBuffer = new StringBuffer();
        nullReferenceBuffer.append(START_ELEMENT_TAG);
        nullReferenceBuffer.append(elementName);
        nullReferenceBuffer.append(SPACE_CHARACTER);
        nullReferenceBuffer.append(XSI_NIL);
        XMLConstructionUtil.write(writer, nullReferenceBuffer.toString());
    }

    public static void writeReference(Writer writer, String referenceAttributeName, String itemId, String stateId, String type) throws MarshallingException {
        StringBuffer referenceBuffer = new StringBuffer();
        XMLConstructionUtil.writeReferenceToReferenceBuffer(referenceBuffer, referenceAttributeName, itemId, stateId, type);
        XMLConstructionUtil.write(writer, referenceBuffer.toString());
    }

    private static void writeReferenceToReferenceBuffer(StringBuffer referenceBuffer, String referenceAttributeName, String itemId, String stateId, String type) {
        referenceBuffer.append(START_ELEMENT_TAG);
        referenceBuffer.append(referenceAttributeName);
        referenceBuffer.append(SPACE_CHARACTER);
        if (itemId != null) {
            XMLConstructionUtil.writeAttributeToAttributeBuffer(referenceBuffer, ITEM_ID_ATTRIBUTE_NAME, itemId);
            referenceBuffer.append(SPACE_CHARACTER);
        }
        if (stateId != null) {
            XMLConstructionUtil.writeAttributeToAttributeBuffer(referenceBuffer, STATE_ID_ATTRIBUTE_NAME, stateId);
            referenceBuffer.append(SPACE_CHARACTER);
        }
        if (type != null) {
            XMLConstructionUtil.writeAttributeToAttributeBuffer(referenceBuffer, XSI_TYPE_NAME, type);
            referenceBuffer.append(SPACE_CHARACTER);
        }
        referenceBuffer.append(SLASH_TAG);
        referenceBuffer.append(END_ELEMENT_TAG);
    }

    public static void writeDataType(Writer writer, String name, String value, int depth) throws MarshallingException {
        StringBuffer dataTypeBuffer = new StringBuffer();
        XMLConstructionUtil.writeNewLineWithTabCharacters(dataTypeBuffer, depth);
        dataTypeBuffer.append(START_ELEMENT_TAG);
        dataTypeBuffer.append(name);
        dataTypeBuffer.append(SPACE_CHARACTER);
        dataTypeBuffer.append(value);
        dataTypeBuffer.append(SPACE_CHARACTER);
        dataTypeBuffer.append(SLASH_TAG);
        dataTypeBuffer.append(END_ELEMENT_TAG);
        XMLConstructionUtil.write(writer, dataTypeBuffer.toString());
    }

    public static void writeNewLineCharacter(Writer writer) throws MarshallingException {
        XMLConstructionUtil.write(writer, NEWLINE_CHARACTER);
    }

    public static void writeTabCharacter(Writer writer) throws MarshallingException {
        XMLConstructionUtil.write(writer, TAB_CHARACTER);
    }

    public static void writeNewLineWithTabCharacters(Writer writer, int depth) throws MarshallingException {
        XMLConstructionUtil.writeNewLineCharacter(writer);
        int i = 0;
        while (i < depth) {
            XMLConstructionUtil.writeTabCharacter(writer);
            ++i;
        }
    }

    public static void writeNewLineWithTabCharacters(StringBuffer buffer, int depth) {
        XMLConstructionUtil.writeNewLineCharacter(buffer);
        int i = 0;
        while (i < depth) {
            XMLConstructionUtil.writeTabCharacter(buffer);
            ++i;
        }
    }

    public static void writeNewLineCharacter(StringBuffer buffer) {
        buffer.append(NEWLINE_CHARACTER);
    }

    public static void writeTabCharacter(StringBuffer buffer) {
        buffer.append(TAB_CHARACTER);
    }

    public static boolean validXMLName(String name) {
        if (name == null) {
            return false;
        }
        if (xmlCharsPattern.matcher(name).matches()) {
            return false;
        }
        return nameCharsPattern.matcher(name).matches();
    }

    private static void write(Writer writer, String output) throws MarshallingException {
        try {
            writer.write(output);
        }
        catch (IOException e) {
            throw new MarshallingException(e);
        }
    }

    private static class SplitWriter
    extends Writer {
        private final PrintStream stream;
        private final Writer writer;

        public SplitWriter(PrintStream stream, Writer writer) {
            this.stream = stream;
            this.writer = writer;
        }

        @Override
        public Writer append(char c) throws IOException {
            this.stream.append(c);
            this.writer.append(c);
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) throws IOException {
            this.stream.append(csq, start, end);
            this.writer.append(csq, start, end);
            return this;
        }

        @Override
        public Writer append(CharSequence csq) throws IOException {
            this.stream.append(csq);
            this.writer.append(csq);
            return this;
        }

        @Override
        public void close() throws IOException {
            this.stream.flush();
            this.writer.close();
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
            this.writer.flush();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.stream.append(new String(cbuf, off, len));
            this.writer.write(cbuf, off, len);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.stream.print(cbuf);
            this.writer.write(cbuf);
        }

        @Override
        public void write(int c) throws IOException {
            this.stream.write(c);
            this.writer.write(c);
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.stream.append(str, off, off + len);
            this.writer.write(str, off, len);
        }

        @Override
        public void write(String str) throws IOException {
            this.stream.print(str);
            this.writer.write(str);
        }
    }
}

