/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.ProcessExporter;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ProcessDefinitionUtil {
    public static final String NAME_TXT = "name.txt";
    public static final String PROCESS_ID_TXT = "processId.txt";
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    public static final String fgCurrentVersion = "2";
    public static final String TEMP_UPLOAD = "com.ibm.team.process.upload-";
    public static final String TEMP_EXPORT = "com.ibm.team.process.export-";
    public static final String ARCHIVE_ROOT_DIRECTORY = "template";

    public static String getProcessId(File baseDir) throws TeamRepositoryException, IOException {
        return ProcessDefinitionUtil.getAttribute(baseDir, PROCESS_ID_TXT);
    }

    public static String getName(File baseDir) throws TeamRepositoryException, IOException {
        return ProcessDefinitionUtil.getAttribute(baseDir, NAME_TXT);
    }

    private static String getAttribute(File baseDir, String attributeFileName) throws TeamRepositoryException, IOException {
        if (!baseDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionUtil.0"), baseDir));
        }
        if (!baseDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionUtil.1"), baseDir));
        }
        String versionFile = "version.txt";
        String versionString = ProcessDefinitionUtil.createStringFromFile(baseDir, versionFile);
        if (versionString == null || versionString.trim().length() == 0) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionUtil.2"), versionFile));
        }
        ProcessDefinitionUtil.assertVersionMatch(versionString, "2");
        return ProcessDefinitionUtil.createStringFromFile(baseDir, attributeFileName);
    }

    public static void assertVersionMatch(String importVersion, String currentVersion) throws TeamRepositoryException {
        if (!currentVersion.equals(importVersion)) {
            try {
                float current = Float.parseFloat(currentVersion);
                float imported = Float.parseFloat(importVersion);
                if (imported < current) {
                    throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionUtil.23"));
                }
                throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionUtil.24"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new TeamRepositoryException(Messages.getCommonString("ProcessDefinitionUtil.25"));
            }
        }
    }

    private static void writeFileToZip(File file, ZipOutputStream zipStream, IPath rootPath) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                ProcessDefinitionUtil.writeFileToZip(child, zipStream, rootPath);
                ++i;
            }
        } else {
            Path filePath = new Path(file.toString());
            int matching = filePath.matchingFirstSegments(rootPath);
            if (matching > 0 && filePath.segmentCount() > matching) {
                String relativePath = filePath.removeFirstSegments(matching).setDevice(null).toString();
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(file);
                    ZipEntry entry = new ZipEntry(relativePath);
                    zipStream.putNextEntry(entry);
                    byte[] buffer = new byte[8192];
                    int read = inputStream.read(buffer);
                    while (read > 0) {
                        zipStream.write(buffer, 0, read);
                        read = inputStream.read(buffer);
                    }
                }
                finally {
                    if (zipStream != null) {
                        zipStream.flush();
                        zipStream.closeEntry();
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                ProcessDefinitionUtil.delete(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    public static File createZip(File directory, File archive) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(archive));
        ZipOutputStream zipStream = new ZipOutputStream(stream);
        try {
            ProcessDefinitionUtil.writeFileToZip(directory, zipStream, (IPath)new Path(directory.getParent().toString()));
        }
        finally {
            zipStream.close();
        }
        return archive;
    }

    public static final String createStringFromFile(File baseDir, String fileName) throws IOException {
        File file = new File(baseDir, fileName);
        if (!file.exists()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        try {
            char[] chars = new char[512];
            int read = reader.read(chars);
            while (read > 0) {
                buffer.append(chars, 0, read);
                read = reader.read(chars);
            }
        }
        finally {
            reader.close();
        }
        return buffer.toString();
    }

    public static File unzip(File zipFileLocation, File destination, ProcessExporter.IProcessExportContext context, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        destination.mkdirs();
        ZipFile zip = new ZipFile(zipFileLocation);
        monitor.beginTask(NLS.bind(Messages.getCommonString("ProcessDefinitionUtil.15"), zip.getName()), zip.size());
        try {
            File entryFile;
            ZipEntry current;
            File rootDirectory = null;
            String cannonicalPathPrefix = String.valueOf(destination.getCanonicalPath()) + File.separator;
            Enumeration<? extends ZipEntry> e = zip.entries();
            while (e.hasMoreElements()) {
                current = e.nextElement();
                entryFile = new File(destination, current.getName());
                if (!entryFile.getCanonicalPath().contains(cannonicalPathPrefix)) {
                    throw new IOException(NLS.bind(Messages.getCommonString("ProcessDefinitionUtil.0"), current.getName()));
                }
                File foundRoot = null;
                File file = new File(destination, current.getName());
                while (file != null && !file.equals(destination)) {
                    foundRoot = file;
                    file = file.getParentFile();
                }
                if (rootDirectory == null) {
                    rootDirectory = foundRoot;
                    continue;
                }
                if (foundRoot == null || rootDirectory.equals(foundRoot)) continue;
                throw new IOException(Messages.getCommonString("ProcessDefinitionUtil.3"));
            }
            if (rootDirectory.exists()) {
                if (context != null) {
                    context.createFile(destination, rootDirectory.getName(), true);
                } else {
                    ProcessDefinitionUtil.delete(rootDirectory);
                }
            }
            e = zip.entries();
            while (e.hasMoreElements()) {
                monitor.worked(1);
                current = e.nextElement();
                if (context != null) {
                    entryFile = context.createFile(destination, current.getName(), current.isDirectory());
                } else {
                    entryFile = new File(destination, current.getName());
                    entryFile.getParentFile().mkdirs();
                    if (!entryFile.exists()) {
                        if (current.isDirectory()) {
                            entryFile.mkdir();
                        } else {
                            entryFile.createNewFile();
                        }
                    }
                }
                if (current.isDirectory()) continue;
                FileOutputStream output = new FileOutputStream(entryFile);
                InputStream input = zip.getInputStream(current);
                ProcessDefinitionUtil.transferStreams(input, output);
            }
        }
        finally {
            monitor.done();
            zip.close();
        }
        return ProcessDefinitionUtil.getTemplateRootDirectory(destination);
    }

    public static File getTemplateRootDirectory(File unzippedContent) {
        File child;
        String[] children;
        if (unzippedContent.isDirectory() && (children = unzippedContent.list()).length == 1 && (child = new File(unzippedContent, children[0])).isDirectory()) {
            return child;
        }
        return null;
    }

    private static void transferStreams(InputStream source, OutputStream destination) throws IOException {
        block27: {
            byte[] buffer = new byte[8192];
            try {
                while (true) {
                    int bytesRead = -1;
                    bytesRead = source.read(buffer);
                    if (bytesRead != -1) {
                        destination.write(buffer, 0, bytesRead);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                block25: {
                    try {
                        try {
                            source.close();
                        }
                        catch (IOException iOException) {
                            try {
                                destination.close();
                            }
                            catch (IOException iOException2) {}
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            destination.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                    try {
                        destination.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                try {
                    source.close();
                }
                catch (IOException iOException) {
                    try {
                        destination.close();
                    }
                    catch (IOException iOException3) {}
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String normalizeFileName(String proposedName) {
        proposedName = proposedName.replaceAll("[<>:\"/\\\\|?*%\\u007f\\u0000-\\u001f]", "_");
        proposedName = ProcessDefinitionUtil.normalizedSpacesAndDots(proposedName);
        return proposedName;
    }

    private static String normalizedSpacesAndDots(String proposedName) {
        if (proposedName == null || proposedName.trim().length() <= 0) {
            return proposedName;
        }
        char c = (proposedName = proposedName.replaceAll("[.]{2}", "__")).charAt(proposedName.length() - 1);
        if (c != ' ' && c != '.') {
            return proposedName;
        }
        if (c == ' ') {
            return ProcessDefinitionUtil.replaceWithUnderscore(proposedName);
        }
        int count = 0;
        int i = 0;
        while (i < proposedName.length()) {
            if (proposedName.charAt(i) != ' ' && proposedName.charAt(i) != '.') break;
            ++count;
            ++i;
        }
        if (count == proposedName.length()) {
            return ProcessDefinitionUtil.replaceWithUnderscore(proposedName);
        }
        count = 0;
        int k = proposedName.lastIndexOf(32);
        if (k < 0) {
            return proposedName;
        }
        int i2 = k;
        while (i2 < proposedName.length()) {
            if (proposedName.charAt(i2) == '.') {
                ++count;
            }
            ++i2;
        }
        if (count == proposedName.length() - k - 1) {
            return ProcessDefinitionUtil.replaceWithUnderscore(proposedName);
        }
        return proposedName;
    }

    private static String replaceWithUnderscore(String proposedName) {
        if (proposedName == null || proposedName.trim().length() <= 0) {
            return proposedName;
        }
        proposedName = proposedName.substring(0, proposedName.length() - 1);
        return String.valueOf(proposedName) + "_";
    }

    public static File createFile(File directory, String fileName, boolean isDirectory) throws IOException {
        File file = new File(directory, fileName);
        if (file.exists()) {
            throw new IOException(Messages.getCommonString("ProcessDefinitionExportUtil.3"));
        }
        if (isDirectory) {
            file.mkdir();
        } else {
            file.createNewFile();
        }
        return file;
    }

    public static void copyFile(File directory, File sourceFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(sourceFile);
        File file = ProcessDefinitionUtil.createFile(directory, sourceFile.getName(), false);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public static long writeFileFromInputStream(File directory, String fileName, InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return -1L;
        }
        File file = ProcessDefinitionUtil.createFile(directory, fileName, false);
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            long length = 0L;
            int byteData = 0;
            byteData = inputStream.read();
            while (byteData != -1) {
                ++length;
                outputStream.write(byteData);
                byteData = inputStream.read();
            }
            long l = length;
            return l;
        }
        finally {
            outputStream.close();
        }
    }

    public static void writeStringToFile(File directory, String fileName, String string) throws IOException {
        File file = ProcessDefinitionUtil.createFile(directory, fileName, false);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.write(string);
        }
        finally {
            writer.close();
        }
    }

    public static File getChild(File parentDirectory, String childFileName) throws IOException {
        File[] children;
        File[] fileArray = children = parentDirectory.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.getName().equals(childFileName)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    public static void appendStringToFile(File directory, String fileName, String string) throws IOException {
        File file = ProcessDefinitionUtil.getChild(directory, fileName);
        if (file == null) {
            file = ProcessDefinitionUtil.createFile(directory, fileName, false);
        }
        BufferedReader br = null;
        StringBuffer result = new StringBuffer();
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String str = null;
            while ((str = br.readLine()) != null) {
                result.append(str).append(System.getProperty("line.separator"));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
        result.append(string);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            writer.append(result);
        }
        finally {
            writer.close();
        }
    }

    public static String computeApplicationVersion(String appVersion) {
        if (appVersion == null || appVersion.trim().length() <= 0) {
            return "";
        }
        StringBuilder computedVersion = new StringBuilder();
        int dotCount = 0;
        int i = 0;
        while (i < appVersion.length()) {
            char c = appVersion.charAt(i);
            if (c != '.' && !Character.isDigit(c)) {
                return computedVersion.toString();
            }
            if (c == '.') {
                if (++dotCount == 1) {
                    computedVersion.append(c);
                }
            } else {
                computedVersion.append(c);
            }
            ++i;
        }
        return computedVersion.toString();
    }
}

