/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.unix;

import com.urbancode.commons.util.Check;
import com.urbancode.process.NativeProcess;
import com.urbancode.shell.impersonation.unix.NativeProcessActions;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

final class NativeProcessPostExecuteAction
extends NativeProcess {
    private static final Logger log = Logger.getLogger(NativeProcessPostExecuteAction.class);
    private final NativeProcess delegate;
    private final File impersonationScript;
    private final String postExecuteAction;
    private final AtomicBoolean actionExecuted = new AtomicBoolean();
    private final String user;
    private final String workingDirectory;

    NativeProcessPostExecuteAction(NativeProcess delegate, File impersonationScript, String postExecuteAction, String user, String workingDirectory) {
        Check.nonNull((Object)delegate, (String)"delegate");
        Check.nonNull((Object)impersonationScript, (String)"impersonationScript");
        Check.nonNull((Object)user, (String)"user");
        Check.nonNull((Object)workingDirectory, (String)"workingDirectory");
        this.delegate = delegate;
        this.impersonationScript = impersonationScript;
        this.postExecuteAction = postExecuteAction;
        this.user = user;
        this.workingDirectory = workingDirectory;
    }

    public OutputStream getOutputStream() {
        return this.delegate.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.delegate.destroy();
            this.runPostExecuteAction();
        }
        finally {
            this.impersonationScript.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyTree() {
        try {
            this.delegate.destroyTree();
            this.runPostExecuteAction();
        }
        finally {
            this.impersonationScript.delete();
        }
    }

    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exitValue() {
        int result = this.delegate.exitValue();
        try {
            this.runPostExecuteAction();
        }
        finally {
            this.impersonationScript.delete();
        }
        return result;
    }

    public void releaseResources() {
        this.delegate.releaseResources();
    }

    public void releaseResources(boolean arg0) {
        this.delegate.releaseResources(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        int result;
        try {
            result = this.delegate.waitFor();
            this.runPostExecuteAction();
        }
        finally {
            this.impersonationScript.delete();
        }
        return result;
    }

    private void runPostExecuteAction() {
        if (this.postExecuteAction != null && this.postExecuteAction.trim().length() > 0 && !this.actionExecuted.getAndSet(true)) {
            NativeProcessActions.runPostExecuteAction(this.impersonationScript, this.postExecuteAction, this.user, this.workingDirectory);
        }
    }
}

