/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.windows;

import com.urbancode.commons.util.StringUtil;
import com.urbancode.process.NativeProcess;
import com.urbancode.shell.impersonation.GetEnvCommand;
import com.urbancode.shell.impersonation.ImpersonationToken;
import com.urbancode.shell.impersonation.windows.Impersonater;
import com.urbancode.shell.impersonation.windows.ImpersonaterException;
import com.urbancode.shell.impersonation.windows.ImpersonaterStatus;
import com.urbancode.winapi.WindowsUserName;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WindowsGetEnvCommand
implements GetEnvCommand {
    private static final Logger log = Logger.getLogger(WindowsGetEnvCommand.class);
    private final ImpersonationToken impersonationToken;

    public WindowsGetEnvCommand(ImpersonationToken impersonationToken) {
        if (impersonationToken == null) {
            throw new NullPointerException("impersonationToken");
        }
        this.impersonationToken = impersonationToken;
    }

    @Override
    public Map<String, String> execute() throws IOException {
        Impersonater impersonater = new Impersonater("getenv");
        impersonater.execute();
        this.configureImpersonater(impersonater);
        ImpersonaterStatus status = impersonater.getStatus();
        if (!status.isOk()) {
            throw new ImpersonaterException(status);
        }
        return this.readVariables(impersonater.getProcess());
    }

    private void configureImpersonater(Impersonater impersonater) throws IOException {
        WindowsUserName user = WindowsUserName.parse((String)this.impersonationToken.getUser());
        impersonater.setUser(user.getUser());
        impersonater.setDomain(user.getDomain());
        impersonater.setPassword(this.impersonationToken.getPassword());
        impersonater.configurationComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readVariables(NativeProcess process) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        try {
            String line;
            InputStream inputStream = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("US-ASCII")));
            if (log.isDebugEnabled()) {
                log.debug((Object)"Reading variables");
            }
            while ((line = reader.readLine()) != null && line.length() > 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Read line: " + line));
                }
                line = StringUtil.unescapeJava((String)line);
                String[] split = line.split("=", 2);
                result.put(split[0], split[1]);
            }
            if (line == null) {
                throw new EOFException("Premature EOF");
            }
            if (reader.read() != -1) {
                throw new IOException("Spurious output following environment variables");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"All variables read");
            }
        }
        finally {
            process.releaseResources();
        }
        return result;
    }
}

