/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.IOException;
import java.io.InputStream;

public class LengthLimitedInputStream
extends InputStream {
    protected boolean mayReset;
    protected long remaining;
    protected long readSinceMark;
    protected final InputStream in;

    public LengthLimitedInputStream(InputStream in, long limit) {
        if (in == null) {
            throw new IllegalArgumentException();
        }
        if (limit < 0L) {
            throw new IllegalArgumentException();
        }
        this.in = in;
        this.remaining = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.remaining == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            return -1;
        }
        --this.remaining;
        ++this.readSinceMark;
        return result;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.remaining);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.readSinceMark = 0L;
        this.mayReset = true;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.remaining == 0L) {
            return -1;
        }
        int read = this.in.read(b, off, len = (int)Math.min((long)len, this.remaining));
        if (read == -1) {
            return -1;
        }
        this.remaining -= (long)read;
        this.readSinceMark += (long)read;
        return read;
    }

    @Override
    public void reset() throws IOException {
        if (!this.mayReset) {
            throw new IOException("Must call mark() before reset()");
        }
        this.in.reset();
        this.remaining += this.readSinceMark;
        this.readSinceMark = 0L;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = this.in.skip(Math.min(n, this.remaining));
        this.remaining -= skipped;
        this.readSinceMark += skipped;
        return skipped;
    }
}

