/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.util;

import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

public class VerifyConvertToLFInputStream
extends LineDelimiterVerifier {
    private boolean pendingChar = false;
    private int lastChar = -1;

    public VerifyConvertToLFInputStream(InputStream in, String encoding) throws UnsupportedEncodingException {
        super(in, encoding, FileLineDelimiter.LINE_DELIMITER_NONE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int read() throws IOException {
        block6: {
            if (!this.pendingChar) {
                this.lastChar = super.read();
                this.pendingChar = true;
            }
            if (this.lastChar == 13) {
                this.lastChar = super.read();
                if (this.lastChar == 10) {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CRLF);
                    break block6;
                } else {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                    if (this.lastChar == -1) {
                        this.pendingChar = false;
                    }
                    return 10;
                }
            }
            if (this.lastChar == 10) {
                this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
            }
        }
        this.pendingChar = false;
        return this.lastChar;
    }

    @Override
    public int read(char[] buffer, int off, int len) throws IOException {
        InterruptedIOException iioe;
        int charsReturned;
        block23: {
            block24: {
                if (len == 0) {
                    return 0;
                }
                if (len == 1) {
                    int b = this.read();
                    if (b == -1) {
                        return -1;
                    }
                    buffer[off] = (char)b;
                    return 1;
                }
                charsReturned = 0;
                if (this.pendingChar) {
                    buffer[off] = (char)this.lastChar;
                    this.pendingChar = false;
                    charsReturned = 1;
                }
                iioe = null;
                len = super.read(buffer, off + charsReturned, len - charsReturned);
                if (len != -1) break block23;
                if (charsReturned != 0) break block24;
                return -1;
            }
            try {
                if (buffer[off] == '\r') {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                    buffer[off] = 10;
                } else if (buffer[off] == '\n') {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
                }
                return charsReturned;
            }
            catch (InterruptedIOException e) {
                len = e.bytesTransferred;
                iioe = e;
            }
        }
        int j = off;
        int i = off;
        while (i < off + len + charsReturned) {
            this.lastChar = buffer[i];
            if (this.lastChar == 13) {
                if (this.pendingChar) {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                    buffer[j++] = 10;
                } else {
                    this.pendingChar = true;
                }
            } else {
                if (this.pendingChar) {
                    if (this.lastChar == 10) {
                        this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CRLF);
                    } else {
                        this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_CR);
                        buffer[j++] = 10;
                    }
                    this.pendingChar = false;
                } else if (this.lastChar == 10) {
                    this.validateLineDelimiter(FileLineDelimiter.LINE_DELIMITER_LF);
                }
                buffer[j++] = (char)this.lastChar;
            }
            ++i;
        }
        if (iioe != null) {
            iioe.bytesTransferred = j - off;
            throw iioe;
        }
        if (j - off == 0) {
            int b = this.read();
            if (b == -1) {
                return -1;
            }
            buffer[off] = (char)b;
            return 1;
        }
        return j - off;
    }

    @Override
    public long skip(long skipBytes) throws IOException {
        int actualCount = 0;
        try {
            while (skipBytes-- > 0L && this.read() != -1) {
                ++actualCount;
            }
            return actualCount;
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = actualCount;
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

