/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.setup.builders;

import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.IArtifactBuilderContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.HashMap;
import java.util.Map;

public class ContributorDetailsBuilder
extends AbstractArtifactBuilder<IContributorDetails> {
    protected static final ValueKey<HashMap<String, String>> LARGE_STRING_EXT_KEY = new ValueKey(String.valueOf(ContributorDetailsBuilder.class.getName()) + ".largeStringExt");
    protected static final ValueKey<IContent> PHOTO = new ValueKey(String.valueOf(ContributorDetailsBuilder.class.getName()) + ".photo");

    public ContributorDetailsBuilder(IArtifactBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(LARGE_STRING_EXT_KEY, new HashMap());
    }

    public ContributorDetailsBuilder setLargeStringExtension(String key, String value) {
        HashMap<String, String> pairs = this.getBuilderValue(LARGE_STRING_EXT_KEY);
        pairs.put(key, value);
        return this;
    }

    public ContributorDetailsBuilder photo(IContent photo) {
        this.setBuilderValue(PHOTO, photo);
        return this;
    }

    @Override
    protected IContributorDetails doSave(BuildContext context) throws TeamRepositoryException {
        throw new UnsupportedOperationException("Cannot save contributor details standalone. To save, build it into a contributor and save the contributor item.");
    }

    @Override
    protected IContributorDetails doBuild(BuildContext context) {
        IContributorDetails details = (IContributorDetails)IContributorDetails.ITEM_TYPE.createItem();
        HashMap<String, String> pairs = this.getBuilderValue(LARGE_STRING_EXT_KEY);
        for (Map.Entry<String, String> pair : pairs.entrySet()) {
            details.setLargeStringExtension(pair.getKey(), pair.getValue());
        }
        details.setPhoto(this.chooseValue(PHOTO, details.getPhoto()));
        return details;
    }
}

