/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.transaction;

import com.urbancode.transaction.JTATransactionUtil;
import com.urbancode.transaction.TransactionUtil;
import com.urbancode.transaction.TransactionUtilFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.Synchronization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionBoundDataSynchronization
implements Synchronization {
    private static final Map<Object, Map<String, Object>> transactionMap = new ConcurrentHashMap<Object, Map<String, Object>>();
    private Object tx;

    private static Map<String, Object> initializeTransactionMapEntry(Object tx) {
        Map<String, Object> txMap = transactionMap.get(tx);
        if (txMap == null) {
            try {
                TransactionUtil txUtil = TransactionUtilFactory.getInstance();
                txUtil.registerSychronization(new TransactionBoundDataSynchronization(tx));
                if (txUtil instanceof JTATransactionUtil) {
                    Map<String, Object> txDataMap = ((JTATransactionUtil)txUtil).getTxDataMap();
                    Set<Map.Entry<String, Object>> entrySet = txDataMap.entrySet();
                    for (Map.Entry<String, Object> entry : entrySet) {
                        txUtil.bind(entry.getKey(), entry.getValue());
                    }
                }
                txMap = transactionMap.get(tx);
            }
            catch (Exception e) {
                RuntimeException ex = new RuntimeException();
                ex.initCause(e);
                throw ex;
            }
        }
        return txMap;
    }

    public static void bind(Object tx, String key, Object value) {
        Map<String, Object> txMap = TransactionBoundDataSynchronization.initializeTransactionMapEntry(tx);
        txMap.put(key, value);
    }

    public static Object unbind(Object tx, String key) {
        Map<String, Object> txMap = TransactionBoundDataSynchronization.initializeTransactionMapEntry(tx);
        return txMap.remove(key);
    }

    public static Object get(Object tx, String key) {
        Map<String, Object> txMap = TransactionBoundDataSynchronization.initializeTransactionMapEntry(tx);
        return txMap.get(key);
    }

    public TransactionBoundDataSynchronization(Object tx) {
        if (tx == null) {
            throw new NullPointerException("The parameter tx must be non-null.");
        }
        this.tx = tx;
        transactionMap.put(tx, new HashMap());
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int arg0) {
        transactionMap.remove(this.tx);
    }
}

